/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.simplewebservice.wsdl.impl;

import com.sun.portal.providers.simplewebservice.wsdl.impl.TypeDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.TypeElementDescriptorImpl;
import com.sun.portal.providers.simplewebservice.wsdl.impl.WSDLException;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.java.JavaSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralAllType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayType;
import com.sun.xml.rpc.processor.model.literal.LiteralArrayWrapperType;
import com.sun.xml.rpc.processor.model.literal.LiteralAttributeMember;
import com.sun.xml.rpc.processor.model.literal.LiteralElementMember;
import com.sun.xml.rpc.processor.model.literal.LiteralEnumerationType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralIDType;
import com.sun.xml.rpc.processor.model.literal.LiteralListType;
import com.sun.xml.rpc.processor.model.literal.LiteralSequenceType;
import com.sun.xml.rpc.processor.model.literal.LiteralSimpleType;
import com.sun.xml.rpc.processor.model.literal.LiteralStructuredType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.literal.LiteralTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.RPCRequestOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCRequestUnorderedStructureType;
import com.sun.xml.rpc.processor.model.soap.RPCResponseStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPAnyType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPListType;
import com.sun.xml.rpc.processor.model.soap.SOAPOrderedStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPSimpleType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.model.soap.SOAPTypeVisitor;
import com.sun.xml.rpc.processor.model.soap.SOAPUnorderedStructureType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class WSDLTypesCollector
implements LiteralTypeVisitor,
SOAPTypeVisitor {
    private Map typeDescriptors = null;

    WSDLTypesCollector(String string, Map map) {
        this.typeDescriptors = map;
    }

    public void doAccept(String string, AbstractType abstractType) throws Exception {
        if (abstractType.isLiteralType()) {
            ((LiteralType)abstractType).accept((LiteralTypeVisitor)this);
        } else if (abstractType.isSOAPType()) {
            ((SOAPType)abstractType).accept((SOAPTypeVisitor)this);
        }
    }

    public void visit(LiteralFragmentType literalFragmentType) throws Exception {
        throw new WSDLException("OTHER_ERROR", "Literal Fragment Type" + literalFragmentType.getName() + " not supported");
    }

    public void visit(LiteralSimpleType literalSimpleType) throws Exception {
    }

    public void visit(LiteralAllType literalAllType) throws Exception {
        this.visitLiteralStructuredType((LiteralStructuredType)literalAllType);
    }

    public void visit(LiteralArrayType literalArrayType) throws Exception {
        HashMap<String, TypeElementDescriptorImpl> hashMap = new HashMap<String, TypeElementDescriptorImpl>();
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl(literalArrayType.getElementType().getName().getLocalPart(), this.getActualTypeName(literalArrayType.getElementType()), "");
        hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
        arrayList.add(typeElementDescriptorImpl.getName());
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(literalArrayType.getName().getLocalPart(), hashMap, arrayList, literalArrayType.getName().getNamespaceURI());
        typeDescriptorImpl.setArrayType(true);
        typeDescriptorImpl.setArrayTypeName(literalArrayType.getElementType().getName().getLocalPart());
        this.typeDescriptors.put(typeDescriptorImpl.getName(), typeDescriptorImpl);
        this.doAccept(literalArrayType.getElementType().getName().getLocalPart(), (AbstractType)literalArrayType.getElementType());
    }

    public void visit(LiteralSequenceType literalSequenceType) throws Exception {
        this.visitLiteralSequenceType(literalSequenceType);
    }

    public void visitLiteralSequenceType(LiteralSequenceType literalSequenceType) throws Exception {
        Iterator iterator = literalSequenceType.getElementMembers();
        LiteralElementMember literalElementMember = null;
        HashMap<String, TypeElementDescriptorImpl> hashMap = new HashMap<String, TypeElementDescriptorImpl>();
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(literalSequenceType.getName().getLocalPart(), hashMap, arrayList, literalSequenceType.getName().getNamespaceURI());
        while (iterator.hasNext()) {
            literalElementMember = (LiteralElementMember)iterator.next();
            TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl(literalElementMember.getName().getLocalPart(), this.getActualTypeName(literalElementMember.getType()), "");
            hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
            arrayList.add(typeElementDescriptorImpl.getName());
            if (literalElementMember.isRepeated()) {
                typeElementDescriptorImpl.setIsRepeated(true);
            }
            this.doAccept(literalElementMember.getName().getLocalPart(), (AbstractType)literalElementMember.getType());
        }
        this.typeDescriptors.put(typeDescriptorImpl.getName(), typeDescriptorImpl);
    }

    public void visit(LiteralEnumerationType literalEnumerationType) throws Exception {
        if (literalEnumerationType.getBaseType().getJavaType() instanceof JavaSimpleType) {
            return;
        }
        throw new WSDLException("OTHER_ERROR", "Enumeration type currently not supported");
    }

    public void visit(LiteralListType literalListType) throws Exception {
        HashMap<String, TypeElementDescriptorImpl> hashMap = new HashMap<String, TypeElementDescriptorImpl>();
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl(literalListType.getItemType().getName().getLocalPart(), this.getActualTypeName(literalListType.getItemType()), "");
        hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
        arrayList.add(typeElementDescriptorImpl.getName());
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(literalListType.getName().getLocalPart(), hashMap, arrayList, literalListType.getName().getNamespaceURI());
        typeDescriptorImpl.setArrayType(true);
        typeDescriptorImpl.setArrayTypeName(literalListType.getItemType().getName().getLocalPart());
        this.typeDescriptors.put(typeDescriptorImpl.getName(), typeDescriptorImpl);
        this.doAccept(literalListType.getItemType().getName().getLocalPart(), (AbstractType)literalListType.getItemType());
    }

    public void visit(LiteralIDType literalIDType) throws Exception {
        throw new WSDLException("OTHER_ERROR", "Literal ID Type not supported");
    }

    public void visit(LiteralArrayWrapperType literalArrayWrapperType) throws Exception {
        throw new WSDLException("OTHER_ERROR", "Literal Array Wrapper not supported");
    }

    public void visitLiteralStructuredType(LiteralStructuredType literalStructuredType) throws Exception {
        TypeElementDescriptorImpl typeElementDescriptorImpl;
        LiteralAttributeMember literalAttributeMember;
        HashMap<String, TypeElementDescriptorImpl> hashMap = new HashMap<String, TypeElementDescriptorImpl>();
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(literalStructuredType.getName().getLocalPart(), hashMap, arrayList, literalStructuredType.getName().getNamespaceURI());
        Iterator iterator = literalStructuredType.getAttributeMembers();
        while (iterator.hasNext()) {
            literalAttributeMember = (LiteralAttributeMember)iterator.next();
            typeElementDescriptorImpl = new TypeElementDescriptorImpl(literalAttributeMember.getName().getLocalPart(), this.getActualTypeName(literalAttributeMember.getType()), "");
            hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
            arrayList.add(typeElementDescriptorImpl.getName());
            this.doAccept(literalAttributeMember.getName().getLocalPart(), (AbstractType)literalAttributeMember.getType());
        }
        iterator = literalStructuredType.getElementMembers();
        while (iterator.hasNext()) {
            literalAttributeMember = (LiteralElementMember)iterator.next();
            typeElementDescriptorImpl = new TypeElementDescriptorImpl(literalAttributeMember.getName().getLocalPart(), this.getActualTypeName(literalAttributeMember.getType()), "");
            hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
            arrayList.add(typeElementDescriptorImpl.getName());
            if (literalAttributeMember.isRepeated()) {
                typeElementDescriptorImpl.setIsRepeated(true);
            }
            this.doAccept(literalAttributeMember.getName().getLocalPart(), (AbstractType)literalAttributeMember.getType());
        }
        this.typeDescriptors.put(typeDescriptorImpl.getName(), typeDescriptorImpl);
    }

    public void visit(SOAPCustomType sOAPCustomType) throws Exception {
        throw new WSDLException("OTHER_ERROR", "SOAP Custom Type not supported");
    }

    public void visit(SOAPArrayType sOAPArrayType) throws Exception {
        HashMap<String, TypeElementDescriptorImpl> hashMap = new HashMap<String, TypeElementDescriptorImpl>();
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl(sOAPArrayType.getElementType().getName().getLocalPart(), sOAPArrayType.getElementType().getName().getLocalPart(), "");
        hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
        arrayList.add(typeElementDescriptorImpl.getName());
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(sOAPArrayType.getName().getLocalPart(), hashMap, arrayList, sOAPArrayType.getName().getNamespaceURI());
        typeDescriptorImpl.setArrayType(true);
        typeDescriptorImpl.setArrayTypeName(sOAPArrayType.getElementType().getName().getLocalPart());
        this.typeDescriptors.put(typeDescriptorImpl.getName(), typeDescriptorImpl);
        this.doAccept(sOAPArrayType.getElementType().getName().getLocalPart(), (AbstractType)sOAPArrayType.getElementType());
    }

    public void visit(SOAPUnorderedStructureType sOAPUnorderedStructureType) throws Exception {
        this.visitSOAPStructureType((SOAPStructureType)sOAPUnorderedStructureType);
    }

    public void visit(SOAPOrderedStructureType sOAPOrderedStructureType) throws Exception {
        this.visitSOAPStructureType((SOAPStructureType)sOAPOrderedStructureType);
    }

    public void visit(RPCRequestOrderedStructureType rPCRequestOrderedStructureType) throws Exception {
        this.visitSOAPStructureType((SOAPStructureType)rPCRequestOrderedStructureType);
    }

    public void visit(RPCRequestUnorderedStructureType rPCRequestUnorderedStructureType) throws Exception {
        this.visitSOAPStructureType((SOAPStructureType)rPCRequestUnorderedStructureType);
    }

    public void visit(SOAPEnumerationType sOAPEnumerationType) throws Exception {
        throw new WSDLException("OTHER_ERROR", "SOAP Enumeration Type is Not Supported");
    }

    public void visit(SOAPSimpleType sOAPSimpleType) throws Exception {
    }

    public void visit(RPCResponseStructureType rPCResponseStructureType) throws Exception {
        this.visitSOAPStructureType((SOAPStructureType)rPCResponseStructureType);
    }

    public void visit(SOAPAnyType sOAPAnyType) throws Exception {
        throw new WSDLException("OTHER_ERROR", "SOAP any Type not supported");
    }

    public void visit(SOAPListType sOAPListType) throws Exception {
        HashMap<String, TypeElementDescriptorImpl> hashMap = new HashMap<String, TypeElementDescriptorImpl>();
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeElementDescriptorImpl typeElementDescriptorImpl = new TypeElementDescriptorImpl(sOAPListType.getItemType().getName().getLocalPart(), sOAPListType.getItemType().getName().getLocalPart(), "");
        hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
        arrayList.add(typeElementDescriptorImpl.getName());
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(sOAPListType.getName().getLocalPart(), hashMap, arrayList, sOAPListType.getName().getNamespaceURI());
        typeDescriptorImpl.setArrayType(true);
        typeDescriptorImpl.setArrayTypeName(sOAPListType.getItemType().getName().getLocalPart());
        this.typeDescriptors.put(typeDescriptorImpl.getName(), typeDescriptorImpl);
        this.doAccept(sOAPListType.getItemType().getName().getLocalPart(), (AbstractType)sOAPListType.getItemType());
    }

    public void visitSOAPStructureType(SOAPStructureType sOAPStructureType) throws Exception {
        TypeElementDescriptorImpl typeElementDescriptorImpl;
        SOAPStructureMember sOAPStructureMember;
        HashMap<String, TypeElementDescriptorImpl> hashMap = new HashMap<String, TypeElementDescriptorImpl>();
        ArrayList<String> arrayList = new ArrayList<String>();
        TypeDescriptorImpl typeDescriptorImpl = new TypeDescriptorImpl(sOAPStructureType.getName().getLocalPart(), hashMap, arrayList, sOAPStructureType.getName().getNamespaceURI());
        Iterator iterator = sOAPStructureType.getMembers();
        while (iterator.hasNext()) {
            sOAPStructureMember = (SOAPStructureMember)iterator.next();
            typeElementDescriptorImpl = new TypeElementDescriptorImpl(sOAPStructureMember.getName().getLocalPart(), sOAPStructureMember.getType().getName().getLocalPart(), "");
            hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
            arrayList.add(typeElementDescriptorImpl.getName());
            this.doAccept(sOAPStructureMember.getName().getLocalPart(), (AbstractType)sOAPStructureMember.getType());
        }
        iterator = sOAPStructureType.getSubtypes();
        while (iterator != null && iterator.hasNext()) {
            sOAPStructureMember = (SOAPStructureType)iterator.next();
            typeElementDescriptorImpl = new TypeElementDescriptorImpl(sOAPStructureMember.getName().getLocalPart(), sOAPStructureMember.getName().getLocalPart(), "");
            hashMap.put(typeElementDescriptorImpl.getName(), typeElementDescriptorImpl);
            arrayList.add(typeElementDescriptorImpl.getName());
            this.doAccept(sOAPStructureMember.getName().getLocalPart(), (AbstractType)sOAPStructureMember);
        }
        this.typeDescriptors.put(typeDescriptorImpl.getName(), typeDescriptorImpl);
    }

    private String getActualTypeName(LiteralType literalType) {
        String string = "";
        string = literalType instanceof LiteralEnumerationType ? ((LiteralEnumerationType)literalType).getBaseType().getName().getLocalPart() : literalType.getName().getLocalPart();
        return string;
    }
}

