/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.xslutil;

import com.iplanet.xslui.tools.Comparer;
import com.iplanet.xslui.tools.QuickSort;
import com.iplanet.xslui.xslutil.XMLDOMBuilder;
import com.iplanet.xslui.xslutil.XMLDOMContentHandler;
import com.iplanet.xslui.xslutil.XMLProcessingException;
import com.iplanet.xslui.xslutil.XMLSAXParser;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTranslator {
    public static final String DICTIONARY_ELT = "dictionary";
    public static final String WORD_ELT = "word";
    public static final String KEY_ATTR = "key";
    public static final String TOTRANSLATE_ELT = "translate";
    public static final String TOTRANSLATE_PREFIX = "prefix";
    private Hashtable _dictionaryTable = new Hashtable();
    private Hashtable _translateTable = new Hashtable();
    private String _toTranslatePrefix = null;
    private XMLDOMBuilder _domBuilder = null;
    private XSLXMLLogHandler _errorHandler;

    public XMLTranslator(File file, XSLXMLLogHandler errorHandler) throws XMLProcessingException {
        this._errorHandler = errorHandler;
        this._domBuilder = XMLDOMBuilder.getInstance(errorHandler);
        DictionarySAXParser dicParser = new DictionarySAXParser(this._dictionaryTable, this._translateTable);
        XMLSAXParser saxParser = new XMLSAXParser(dicParser, errorHandler);
        saxParser.parse(file);
        this._toTranslatePrefix = dicParser.getPrefix();
    }

    public Document translate(Document originalDoc) throws XMLProcessingException {
        Document copyDoc = null;
        TranslatorContentHandler contentHandler = new TranslatorContentHandler(this._dictionaryTable, this._translateTable);
        copyDoc = this._domBuilder.newDocument(originalDoc, contentHandler);
        return copyDoc;
    }

    public synchronized void load(File file) throws XMLProcessingException {
        ExtractSAXParser docParser = new ExtractSAXParser(this._dictionaryTable, this._translateTable, this._toTranslatePrefix);
        XMLSAXParser saxParser = new XMLSAXParser(docParser, this._errorHandler);
        saxParser.parse(file);
    }

    public void dumpToFile(File file) throws XMLProcessingException {
        FileOutputStream fout = null;
        OutputStreamWriter pout = null;
        ArrayList<String> toSort = new ArrayList<String>();
        class IgnoreCaseComparer
        implements Comparer {
            IgnoreCaseComparer() {
            }

            public int compare(Object handle, Object o1, Object o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        }
        IgnoreCaseComparer myComparer = new IgnoreCaseComparer();
        try {
            fout = new FileOutputStream(file);
        }
        catch (Exception ioe) {
            throw new XMLProcessingException("dumpToFile: can't open file: " + file.toString() + "(" + ioe.getMessage() + ")");
        }
        try {
            pout = new OutputStreamWriter((OutputStream)fout, "UTF-8");
            pout.write("<?xml version=\"1.0\"?>");
            pout.write("<dictionary>\n");
            if (this._toTranslatePrefix != null) {
                pout.write("  <prefix>");
                pout.write(this._toTranslatePrefix);
                pout.write("</prefix>\n");
            }
            Enumeration e = this._translateTable.keys();
            while (e.hasMoreElements()) {
                pout.write("  <translate>");
                pout.write((String)e.nextElement());
                pout.write("</translate>\n");
            }
            e = this._dictionaryTable.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                toSort.add(key);
            }
            QuickSort.sort(toSort, myComparer, null);
            Iterator iterator = toSort.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                pout.write("  <word");
                pout.write(" key=\"" + key);
                pout.write("\">");
                pout.write((String)this._dictionaryTable.get(key));
                pout.write("</word>\n");
            }
            pout.write("</dictionary>\n");
            pout.close();
        }
        catch (Exception e) {
            throw new XMLProcessingException("Can't write in file : " + e.getMessage());
        }
    }

    public int size() {
        return this._dictionaryTable.size();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            throw new Exception("No file provided, can do nothing !");
        }
        File xslFile = new File(args[0]);
        if (!xslFile.exists()) {
            throw new Exception("XSL file not found !");
        }
        File dicFile = new File(args[1]);
        if (!dicFile.exists()) {
            throw new Exception("Dictionary file not found !");
        }
        try {
            XMLTranslator translator = new XMLTranslator(dicFile, null);
            translator.load(xslFile);
            translator.dumpToFile(dicFile);
        }
        catch (Exception e) {
            throw new Exception("Couldn't populate dictionary : " + e.getMessage());
        }
    }

    private class TranslatorContentHandler
    extends XMLDOMContentHandler {
        Hashtable _dictionaryTable = null;
        Hashtable _translateTable = null;

        public TranslatorContentHandler(Hashtable dic, Hashtable trans) {
            this._dictionaryTable = dic;
            this._translateTable = trans;
        }

        public void elementHandler(Element element, Document doc) {
            if (this._translateTable.get(element.getTagName()) == null) {
                return;
            }
            NodeList nl = element.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Text textNode;
                String currentContent;
                String newContent;
                Node childNode = nl.item(i);
                if (childNode.getNodeType() != 3 || (newContent = (String)this._dictionaryTable.get(currentContent = (textNode = (Text)childNode).getData())) == null) continue;
                textNode.setData(newContent);
            }
        }
    }

    private class ExtractSAXParser
    extends DefaultHandler {
        Hashtable _dictionaryTable = null;
        Hashtable _translateTable = null;
        boolean _inText = false;
        StringBuffer _currentValue = null;
        boolean _ignorePrefix = true;
        String _toTranslatePrefix = null;

        public ExtractSAXParser(Hashtable dictionary, Hashtable trans, String prefix) {
            this._dictionaryTable = dictionary;
            this._translateTable = trans;
            this._toTranslatePrefix = prefix;
            this._ignorePrefix = prefix == null;
        }

        public void startDocument() throws SAXException {
            this._inText = false;
            this._currentValue = new StringBuffer();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this._translateTable.get(qName) != null) {
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
            } else {
                this._inText = false;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (this._inText) {
                String key = this._currentValue.substring(0);
                if (this._dictionaryTable.get(key) == null && key.length() > 0 && (this._ignorePrefix || key.indexOf(this._toTranslatePrefix) == 0)) {
                    int offset = key != null ? this._toTranslatePrefix.length() : 0;
                    String subStr = offset == 0 ? key : key.substring(offset);
                    this._dictionaryTable.put(key, subStr);
                }
                this._inText = false;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this._inText) {
                this._currentValue.append(ch, start, length);
            }
        }
    }

    private class DictionarySAXParser
    extends DefaultHandler {
        Hashtable _dictionaryTable = null;
        Hashtable _translateTable = null;
        String _currentKey = null;
        String _toTranslatePrefix = null;
        StringBuffer _currentValue = null;
        boolean _inText;
        boolean _ignorePrefix = true;

        public DictionarySAXParser(Hashtable dictionary, Hashtable trans) {
            this._dictionaryTable = dictionary;
            this._translateTable = trans;
        }

        public void startDocument() throws SAXException {
            this._currentKey = null;
            this._currentValue = new StringBuffer();
            this._inText = false;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals(XMLTranslator.DICTIONARY_ELT)) {
                return;
            }
            if (qName.equals(XMLTranslator.TOTRANSLATE_PREFIX)) {
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
                return;
            }
            if (qName.equals(XMLTranslator.TOTRANSLATE_ELT)) {
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
                return;
            }
            if (qName.equals(XMLTranslator.WORD_ELT)) {
                if (atts.getLength() != 1) {
                    throw new SAXException("Wrong number of attributes for word element:" + atts.getLength());
                }
                if (!atts.getQName(0).equals(XMLTranslator.KEY_ATTR)) {
                    throw new SAXException("Wrong attribute name for word element:" + atts.getLocalName(0));
                }
                this._currentKey = atts.getValue(0);
                this._currentValue.delete(0, this._currentValue.length());
                this._inText = true;
                return;
            }
            throw new SAXException("Unknown element: " + qName);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals(XMLTranslator.TOTRANSLATE_PREFIX)) {
                this._ignorePrefix = false;
                this._toTranslatePrefix = new String(this._currentValue.substring(0));
            }
            if (qName.equals(XMLTranslator.TOTRANSLATE_ELT)) {
                this._translateTable.put(this._currentValue.substring(0), "OK");
                this._inText = false;
            }
            if (qName.equals(XMLTranslator.WORD_ELT)) {
                if (this._currentKey == null) {
                    throw new SAXException("No current Key at end of element.");
                }
                String value = (String)this._dictionaryTable.get(this._currentKey);
                if (value == null) {
                    this._dictionaryTable.put(this._currentKey, this._currentValue.substring(0));
                    this._currentKey = null;
                    this._inText = false;
                } else {
                    throw new SAXException("Duplicated key: " + this._currentKey);
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this._inText) {
                return;
            }
            this._currentValue.append(ch, start, length);
        }

        public String getPrefix() {
            return this._toTranslatePrefix;
        }
    }
}

