/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.ServletRequestDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class MultipartHttpServletRequest
extends HttpServletRequestWrapper {
    private static final String CONTENT_DISPOSITION = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_NAME = "name=\"";
    private static final String CONTENT_DISPOSITION_FILENAME = "filename=\"";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_TYPE_MULTI = "multipart/form-data";
    private Hashtable _paramTable = null;
    private Hashtable _fileTable = null;

    public MultipartHttpServletRequest(HttpServletRequest servletRequest) throws IOException, IllegalArgumentException {
        super(servletRequest);
        if (servletRequest == null) {
            throw new IllegalArgumentException("null servletRequest");
        }
        this._paramTable = new Hashtable();
        this._fileTable = new Hashtable();
        ServletRequestDataSource dataSource = new ServletRequestDataSource((ServletRequest)servletRequest);
        MimeMultipart mmp = null;
        try {
            mmp = new MimeMultipart((DataSource)dataSource);
        }
        catch (MessagingException me) {
            throw new IOException("MimeMultipart failed: " + me.getMessage());
        }
        catch (ClassCastException cce) {
            throw new IOException("MimeMultipart failed: not Mime content-type " + cce.getMessage());
        }
        try {
            MultipartHttpServletRequest.parseMultiPart(mmp, this._paramTable, this._fileTable);
        }
        catch (IOException ex) {
            throw new IOException("parseMultiPart has thrown IOException: " + ex.getMessage());
        }
        catch (MessagingException ex) {
            throw new IOException("parseMultiPart has thrown MessagingException: " + ex.getMessage());
        }
    }

    public String getParameter(String name) {
        if (name == null) {
            return null;
        }
        String[] paramValues = (String[])this._paramTable.get(name);
        if (paramValues != null) {
            return paramValues[0];
        }
        return null;
    }

    public String[] getParameterValues(String name) {
        if (name == null) {
            return null;
        }
        return (String[])this._paramTable.get(name);
    }

    public Enumeration getParameterNames() {
        return this._paramTable.keys();
    }

    public Enumeration getFileParameterNames() {
        return this._fileTable.keys();
    }

    public InputStream getFileParameter(String name) {
        if (name == null) {
            return null;
        }
        return (InputStream)this._fileTable.get(name);
    }

    protected static String inputStreamToString(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int read = 0;
        while (read != -1) {
            byte[] some = new byte[1];
            read = in.read(some);
            if (read == -1) continue;
            out.write(some);
        }
        out.flush();
        out.close();
        return out.toString();
    }

    protected static void parseMultiPart(MimeMultipart mmp, Hashtable paramTable, Hashtable fileTable) throws IOException, MessagingException {
        int count = mmp.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bp = mmp.getBodyPart(i);
            if (!(bp instanceof MimeBodyPart)) {
                throw new IOException("Content is not Mime");
            }
            MimeBodyPart mbp = (MimeBodyPart)bp;
            MultipartHttpServletRequest.parseBody(mbp, paramTable, fileTable);
        }
    }

    private static void parseBody(MimeBodyPart mbp, Hashtable paramTable, Hashtable fileTable) throws IOException, MessagingException, ParseException {
        String[] retArray = MultipartHttpServletRequest.getNames(mbp);
        String paramName = retArray[0];
        if (paramName == null) {
            return;
        }
        String fileName = retArray[1];
        InputStream is = mbp.getInputStream();
        String contentType = null;
        String[] conts = mbp.getHeader(CONTENT_TYPE);
        if (conts != null || fileName != null) {
            if (conts != null && (contentType = conts[0]).startsWith("multipart")) {
                throw new IOException("nested multipart not allowed");
            }
            fileTable.put(paramName, is);
        } else {
            String value = MultipartHttpServletRequest.inputStreamToString(is);
            is.close();
            MultipartHttpServletRequest.putParameter(paramTable, paramName, value);
        }
    }

    private static String[] getNames(MimeBodyPart mbp) throws MessagingException, ParseException {
        String[] retArray = new String[2];
        String[] dis = mbp.getHeader(CONTENT_DISPOSITION);
        if (dis != null) {
            int e_index;
            int s_index = dis[0].indexOf(CONTENT_DISPOSITION_NAME);
            if (s_index != -1) {
                e_index = dis[0].indexOf("\";", s_index + CONTENT_DISPOSITION_NAME.length());
                retArray[0] = e_index == -1 ? dis[0].substring(s_index + CONTENT_DISPOSITION_NAME.length(), dis[0].length() - 1) : dis[0].substring(s_index + CONTENT_DISPOSITION_NAME.length(), e_index);
            }
            if ((s_index = dis[0].indexOf(CONTENT_DISPOSITION_FILENAME)) != -1) {
                e_index = dis[0].indexOf("\";", s_index + CONTENT_DISPOSITION_FILENAME.length());
                retArray[1] = e_index == -1 ? dis[0].substring(s_index + CONTENT_DISPOSITION_FILENAME.length(), dis[0].length() - 1) : dis[0].substring(s_index + CONTENT_DISPOSITION_FILENAME.length(), e_index);
            }
        }
        return retArray;
    }

    private static void putParameter(Hashtable paramTable, String key, String value) {
        String[] values;
        if (paramTable.containsKey(key)) {
            String[] oldValues = (String[])paramTable.get(key);
            values = new String[oldValues.length + 1];
            for (int i = 0; i < oldValues.length; ++i) {
                values[i] = oldValues[i];
            }
            values[oldValues.length] = value;
        } else {
            values = new String[]{value};
        }
        paramTable.put(key, values);
    }
}

