/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.LDAPRebindImpl;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPPool {
    private int _poolMin;
    private int _poolMax;
    private long _timeout;
    private String _host;
    private int _port;
    private String _authdn;
    private String _authpw;
    private Vector _pool;
    private boolean _poolIsFull;
    private boolean _noPool;
    private int _ldapVersion;

    public LDAPPool(int min, int max, int timeout, String host, int port, String authdn, String authpw, int ldapVersion) throws LDAPException {
        if (min < 0) {
            throw new LDAPException("ConnectionPoolSize invalid:" + min);
        }
        if (max < min) {
            throw new LDAPException("ConnectionPoolSize invalid: max = " + max + " < min = " + min);
        }
        this._poolMin = min;
        this._poolMax = max;
        if (this._poolMax == 0) {
            this._noPool = true;
        }
        this._timeout = timeout < 0 ? (long)(-timeout) : (long)(timeout * 1000);
        this._host = host;
        this._port = port;
        this._authdn = authdn;
        this._authpw = authpw;
        this._ldapVersion = ldapVersion;
        this._pool = new Vector();
        this._poolIsFull = false;
        this.setUpPool(this._poolMin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnection() throws LDAPException {
        LDAPConnection con = null;
        if (!this._noPool) {
            boolean timedout = false;
            while (!timedout) {
                Vector vector = this._pool;
                synchronized (vector) {
                    if (this._poolIsFull) {
                        try {
                            this._pool.wait(this._timeout);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (this._poolIsFull) {
                            timedout = true;
                        }
                    }
                    if ((con = this.getConnFromPool()) != null) {
                        break;
                    }
                    this._poolIsFull = true;
                }
            }
        } else {
            con = new LDAPConnection();
            Long to = new Long(this._timeout);
            Integer newLimit = new Integer(to.intValue());
            con.setOption(4, (Object)newLimit);
            con.setOption(8, (Object)new Boolean(true));
            LDAPRebindImpl reBindObj = new LDAPRebindImpl(this._authdn, this._authpw);
            con.setOption(9, (Object)reBindObj);
            con.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPConnection getConnectionNoWait() throws LDAPException {
        LDAPConnection con = null;
        if (!this._noPool) {
            Vector vector = this._pool;
            synchronized (vector) {
                if (!this._poolIsFull) {
                    con = this.getConnFromPool();
                }
            }
        } else {
            con = new LDAPConnection();
            Long to = new Long(this._timeout);
            Integer newLimit = new Integer(to.intValue());
            con.setOption(8, (Object)new Boolean(true));
            LDAPRebindImpl reBindObj = new LDAPRebindImpl(this._authdn, this._authpw);
            con.setOption(9, (Object)reBindObj);
            con.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(LDAPConnection ld) {
        if (ld == null) {
            return;
        }
        if (!this._noPool) {
            int index = -1;
            for (int i = 0; i < this._pool.size(); ++i) {
                LDAPConnectionObject co = (LDAPConnectionObject)this._pool.elementAt(i);
                if (co.getLDAPConn() != ld) continue;
                index = i;
                break;
            }
            if (index != -1) {
                LDAPConnectionObject co = (LDAPConnectionObject)this._pool.elementAt(index);
                Vector vector = this._pool;
                synchronized (vector) {
                    co.setInUse(false);
                    this._poolIsFull = false;
                    this._pool.notify();
                }
            }
        } else {
            try {
                ld.disconnect();
            }
            catch (LDAPException lDAPException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Vector vector = this._pool;
        synchronized (vector) {
            for (int i = 0; i < this._pool.size(); ++i) {
                this.disconnect((LDAPConnectionObject)this._pool.elementAt(i));
            }
            this._pool.removeAllElements();
        }
    }

    private LDAPConnection getConnFromPool() throws LDAPException {
        int i;
        LDAPConnection con = null;
        LDAPConnectionObject ldapconnobj = null;
        int pSize = this._pool.size();
        for (i = 0; i < pSize; ++i) {
            LDAPConnectionObject co = (LDAPConnectionObject)this._pool.elementAt(i);
            if (!co.isAvailable()) continue;
            ldapconnobj = co;
            break;
        }
        if (ldapconnobj == null && pSize < this._poolMax && (i = this.addConnection()) >= 0) {
            ldapconnobj = (LDAPConnectionObject)this._pool.elementAt(i);
        }
        if (ldapconnobj != null) {
            ldapconnobj.setInUse(true);
            con = ldapconnobj.getLDAPConn();
        }
        if (con != null && !con.isConnected()) {
            con.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
        }
        return con;
    }

    private void disconnect(LDAPConnectionObject ldapconnObject) {
        if (ldapconnObject != null && ldapconnObject.isAvailable()) {
            LDAPConnection ld = ldapconnObject.getLDAPConn();
            if (ld != null && ld.isConnected()) {
                try {
                    ld.disconnect();
                }
                catch (LDAPException lDAPException) {
                    // empty catch block
                }
            }
            ldapconnObject.setLDAPConn(null);
        }
    }

    private int addConnection() throws LDAPException {
        int index = -1;
        int size = this._pool.size() + 1;
        this.setUpPool(size);
        if (size == this._pool.size()) {
            index = size - 1;
        }
        return index;
    }

    private void setUpPool(int size) throws LDAPException {
        while (this._pool.size() < size) {
            LDAPConnectionObject co = new LDAPConnectionObject();
            LDAPConnection newConn = new LDAPConnection();
            Long to = new Long(this._timeout);
            Integer newLimit = new Integer(to.intValue());
            newConn.setOption(4, (Object)newLimit);
            newConn.setOption(8, (Object)new Boolean(true));
            LDAPRebindImpl reBindObj = new LDAPRebindImpl(this._authdn, this._authpw);
            newConn.setOption(9, (Object)reBindObj);
            newConn.connect(this._ldapVersion, this._host, this._port, this._authdn, this._authpw);
            co.setLDAPConn(newConn);
            co.setInUse(false);
            this._pool.addElement(co);
        }
    }

    class LDAPConnectionObject {
        private LDAPConnection ld;
        private boolean inUse;

        LDAPConnectionObject() {
        }

        LDAPConnection getLDAPConn() {
            return this.ld;
        }

        void setLDAPConn(LDAPConnection ld) {
            this.ld = ld;
        }

        void setInUse(boolean inUse) {
            this.inUse = inUse;
        }

        boolean isAvailable() {
            return !this.inUse;
        }
    }
}

