/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.base;

import java.util.Collection;
import java.util.Iterator;

public class CollectionIterator
implements Iterator {
    protected Collection collection;
    protected Object[] objects;
    protected int index;
    protected int start;
    protected int count;
    private int end;
    private int startOne;
    private int endOne;
    private int nextStart;
    private int prevStart;
    private int size;
    private boolean nextPage;
    private boolean prevPage;

    private void computeLimits() {
        this.prevStart = this.start - this.count;
        if (this.prevStart < 0) {
            this.prevStart = 0;
        }
        this.prevPage = this.start != 0;
        this.nextStart = this.start + this.count;
        if (this.nextStart >= this.size) {
            this.count = this.size - this.start;
            this.nextPage = false;
        } else {
            this.nextPage = true;
        }
        this.end = this.start + this.count;
        this.startOne = this.start + 1;
        this.endOne = this.end + 1;
        this.index = this.start;
    }

    public CollectionIterator(Collection collection) {
        this(collection, 0, collection.size());
    }

    public CollectionIterator(Collection collection, int start, int count) {
        this.collection = collection;
        this.start = start;
        this.count = count;
        this.objects = collection.toArray();
        this.size = this.objects.length;
        this.computeLimits();
    }

    public Collection getCollection() {
        return this.collection;
    }

    public boolean hasNext() {
        return this.index < this.end;
    }

    public Object next() {
        if (this.index < this.end) {
            return this.objects[this.index++];
        }
        return null;
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public int getIndex() {
        return this.index - 1;
    }

    public int getIndexOne() {
        return this.index;
    }

    public String getStart() {
        return Integer.toString(this.start);
    }

    public int getStartInt() {
        return this.start;
    }

    public void setStart(String s) {
        if (s == null || s.length() == 0) {
            this.start = 0;
        } else {
            try {
                this.start = Integer.parseInt(s);
            }
            catch (Exception e) {
                this.start = 0;
            }
        }
        this.computeLimits();
    }

    public String getCount() {
        return Integer.toString(this.count);
    }

    public int getCountInt() {
        return this.count;
    }

    public void setCount(String s) {
        if (s == null || s.length() == 0) {
            this.count = this.size;
        } else {
            try {
                this.count = Integer.parseInt(s);
            }
            catch (Exception e) {
                this.count = 0;
            }
        }
        this.computeLimits();
    }

    public int getEnd() {
        return this.end - 1;
    }

    public int getStartOne() {
        return this.startOne;
    }

    public int getEndOne() {
        return this.endOne - 1;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isNextPage() {
        return this.nextPage;
    }

    public boolean isPrevPage() {
        return this.prevPage;
    }

    public int getNextStart() {
        return this.nextStart;
    }

    public int getPrevStart() {
        return this.prevStart;
    }
}

