/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.ab;

import com.sun.addressbook.Element;
import com.sun.addressbook.Group;
import com.sun.portal.wireless.taglibs.ab.ABBaseCommandTag;
import com.sun.portal.wireless.taglibs.ab.ABContext;
import com.sun.portal.wireless.taglibs.ab.ContactDB;
import com.sun.portal.wireless.taglibs.base.Edit;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;

public class ABDeleteGroupMembersTag
extends ABBaseCommandTag {
    protected String members = null;
    protected String groupid = null;
    private Edit edit = null;

    public String getMembers() {
        return this.members;
    }

    public void setMembers(String members) {
        this.members = this.evalAttribute(members);
    }

    public String getGroupid() {
        return this.groupid;
    }

    public void setGroupid(String groupid) {
        this.groupid = this.evalAttribute(groupid);
    }

    public void verifyGroupid() throws JspException {
        if (this.groupid == null) {
            throw new JspException("ABDeleteGroupMembersTag.verifyGroupid(): 'groupid' attribute not specified");
        }
    }

    public void setEdit(String edit) {
        this.edit = (Edit)this.pageContext.getAttribute(edit);
    }

    public boolean execute() throws JspException {
        this.verifyGroupid();
        ContactDB contactDB = this.getContactDB();
        Element element = this.getEntry(Integer.parseInt(this.groupid));
        if (element.getElementType() != 2) {
            ABContext.warningLog("ABDeleteTag: Element type is not Group");
            this.getABContext().setErrorCode("");
            return false;
        }
        Group group = (Group)element;
        if (this.edit != null) {
            this.members = this.edit.editString(this.members.toString());
        }
        if (this.members != null && !this.members.equals("")) {
            StringTokenizer tok = new StringTokenizer(this.members, ",");
            while (tok.hasMoreTokens()) {
                Element elemToDel = this.getABContext().getGroupmember(Integer.parseInt(tok.nextToken()));
                if (contactDB.deleteElementFromGroup(elemToDel, group)) continue;
                ABContext.warningLog("ABDeleteGroupMembersTag: Delete Group element failed");
                this.getABContext().setErrorCode("");
                return false;
            }
        }
        return true;
    }

    public void release() {
        super.release();
        this.members = null;
        this.edit = null;
    }
}

