/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.mail;

import com.sun.portal.wireless.taglibs.base.Util;
import javax.mail.Folder;
import javax.mail.MessagingException;

public class FolderBean {
    private Folder folder = null;

    public FolderBean(Folder f) {
        this.folder = f;
    }

    public FolderBean() {
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void close() {
        try {
            if (this.folder.isOpen()) {
                this.folder.close(true);
            }
        }
        catch (MessagingException e) {
            Util.logError((String)(this.getClass().getName() + ".close()"), (Throwable)e);
        }
    }

    public boolean isHoldfolders() throws MessagingException {
        return (this.folder.getType() & 2) != 0;
    }

    public boolean isHoldmessages() throws MessagingException {
        return (this.folder.getType() & 1) != 0;
    }

    public String getName() {
        return this.folder.getName();
    }

    public String getFullName() {
        return this.folder.getFullName();
    }

    public int getNumFolders() throws MessagingException {
        if ((this.folder.getType() & 2) != 0) {
            Folder[] tmp = this.folder.list();
            return tmp.length;
        }
        return 0;
    }

    public int getNumMsgs() throws MessagingException {
        if ((this.folder.getType() & 1) != 0) {
            int count = this.folder.getMessageCount();
            return count > 0 ? count : 0;
        }
        return 0;
    }

    public boolean isReadwrite() throws MessagingException {
        boolean readwrite = true;
        if (this.folder.isOpen()) {
            readwrite = this.folder.getMode() == 2;
        } else {
            try {
                this.folder.open(2);
                this.folder.close(false);
            }
            catch (Exception e) {
                readwrite = false;
            }
        }
        return readwrite;
    }
}

