/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdm;

import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RDMClassification
implements Comparable {
    RDMClassification parent;
    List children;
    List xrefs;
    String subcategory;
    int depth;
    int ndescendant;
    int ndocs;
    int ndescdocs;
    SOIF soif = new SOIF("CLASSIFICATION", null);

    public RDMClassification(String string) {
        this.setSubcategory(string);
    }

    public RDMClassification(SOIFInputStream sOIFInputStream) throws Exception {
        this((String)null);
        SOIF sOIF = sOIFInputStream.readSOIF();
        if (sOIF == null || !sOIF.getSchemaName().equalsIgnoreCase("CLASSIFICATION")) {
            throw new Exception("invalid classification");
        }
        this.setSubcategory(sOIF.getValue("id"));
        this.soif.merge(sOIF);
    }

    public void setSubcategory(String string) {
        if (string != null) {
            this.soif.insert("id", string);
            int n = string.lastIndexOf(58);
            n = n != -1 ? ++n : 0;
            this.subcategory = string.substring(n);
        }
    }

    public RDMClassification find(String string) {
        int n = 0;
        int n2 = 0;
        while (n != -1) {
            n = string.indexOf(58, n + 1);
            ++n2;
        }
        return this.classfind(string, n2);
    }

    public void insertChild(RDMClassification rDMClassification) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(rDMClassification);
        rDMClassification.depth = this.depth + 1;
        Collections.sort(this.children);
        RDMClassification rDMClassification2 = this;
        for (int i = 0; rDMClassification2 != null && i <= this.depth; ++i) {
            ++rDMClassification2.ndescendant;
            rDMClassification2 = rDMClassification2.parent;
        }
    }

    public void deleteChild(String string) throws Exception {
        RDMClassification rDMClassification = this.find(string);
        if (rDMClassification != null) {
            RDMClassification rDMClassification2 = rDMClassification.getParent();
            if (rDMClassification2 != null) {
                int n = rDMClassification.getNumDescendant();
                int n2 = this.children.indexOf(rDMClassification);
                this.children.remove(n2);
                Collections.sort(this.children);
                for (RDMClassification rDMClassification3 = rDMClassification2; rDMClassification3 != null; rDMClassification3 = rDMClassification3.getParent()) {
                    rDMClassification3.ndescendant -= n + 1;
                }
            }
        } else {
            throw new Exception("RDMClassification - deleteChild() - child not in current classification");
        }
    }

    public void insertXref(String string) {
        if (this.xrefs == null) {
            this.xrefs = new ArrayList();
        }
        this.xrefs.add(string);
    }

    public void deleteXref(String string) {
    }

    public void apply(int n, RDMCallback rDMCallback) throws Exception {
        int n2 = this.nChildren();
        switch (n) {
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    this.nthChild(i).apply(n, rDMCallback);
                }
                rDMCallback.callback(this);
                break;
            }
            case 0: 
            case 1: {
                rDMCallback.callback(this);
                for (int i = 0; i < n2; ++i) {
                    this.nthChild(i).apply(n, rDMCallback);
                }
                break;
            }
        }
    }

    public RDMClassification nthChild(int n) {
        return (RDMClassification)this.children.get(n);
    }

    public RDMClassification nthXref(int n) {
        return (RDMClassification)this.xrefs.get(n);
    }

    public int nChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public int nXrefs() {
        if (this.xrefs == null) {
            return 0;
        }
        return this.children.size();
    }

    public static String subcategory(String string, int n) {
        Object var2_2 = null;
        int n2 = 0;
        int n3 = 0;
        if (n < 1) {
            return null;
        }
        if (n == 1) {
            int n4 = string.indexOf(58);
            n3 = n4 != -1 ? n4 : string.length();
        } else {
            int n5;
            int n6 = 0;
            for (int i = 0; i < n - 1; ++i) {
                n5 = string.indexOf(58, n6);
                if (n5 == -1) {
                    return null;
                }
                n6 = ++n5;
            }
            n2 = n6;
            n5 = string.indexOf(58, n6);
            n3 = n5 != -1 ? n5 : string.length();
        }
        if (n3 - n2 < 1) {
            return null;
        }
        return string.substring(n2, n3);
    }

    public String getId() {
        return this.soif.getValue("id");
    }

    public String getParentId() {
        return this.soif.getValue("parent-id");
    }

    public String getTaxonomyId() {
        return this.soif.getValue("taxonomy-id");
    }

    public String getDescription() {
        return this.soif.getValue("description");
    }

    public String getMatchingRule() {
        return this.soif.getValue("matching-rule");
    }

    public SOIF getSOIF() {
        return this.soif;
    }

    public int getNumDocs() {
        return this.ndocs;
    }

    public int getNumDescDocs() {
        return this.ndescdocs;
    }

    public int getNumDescendant() {
        return this.ndescendant;
    }

    public void setNumDescendant(int n) {
        this.ndescendant = n;
    }

    public int getDepth() {
        return this.depth;
    }

    public List getChildren() {
        return this.children;
    }

    public RDMClassification getParent() {
        return this.parent;
    }

    public String getSubcategory() {
        return this.subcategory;
    }

    public void setId(String string) {
        this.soif.replace("id", string);
    }

    public void setParentId(String string) {
        this.soif.replace("parent-id", string);
    }

    public void setTaxonomyId(String string) {
        this.soif.replace("taxonomy-id", string);
    }

    public void setDescription(String string) {
        this.soif.replace("description", string);
    }

    public void setMatchingRule(String string) {
        this.soif.replace("matching-rule", string);
    }

    public void setNumDocs(int n) {
        this.ndocs = n;
    }

    public void setNumDescDocs(int n) {
        this.ndescdocs = n;
    }

    protected RDMClassification classfind(String string, int n) {
        String string2 = null;
        if (this.depth == n) {
            if (this.getId().equals(string)) {
                return this;
            }
            return null;
        }
        if (this.depth > n) {
            return null;
        }
        string2 = RDMClassification.subcategory(string, this.depth + 1);
        if (string2 == null) {
            return null;
        }
        int n2 = this.nChildren();
        for (int i = 0; i < n2; ++i) {
            RDMClassification rDMClassification = this.nthChild(i);
            if (rDMClassification == null || rDMClassification.subcategory == null || !rDMClassification.subcategory.equals(string2)) continue;
            return rDMClassification.classfind(string, n);
        }
        return null;
    }

    public String toString() {
        return this.toString(this);
    }

    private String toString(RDMClassification rDMClassification) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(new String(rDMClassification.getSOIF().toByteArray()));
            if (rDMClassification.getNumDescendant() != 0) {
                stringBuffer.append("\n");
                for (int i = 0; i < rDMClassification.getChildren().size(); ++i) {
                    stringBuffer.append(this.toString(rDMClassification.nthChild(i)));
                }
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int compareTo(Object object) {
        return this.subcategory.compareToIgnoreCase(((RDMClassification)object).subcategory);
    }
}

