/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.DataCipherMsg;
import com.sun.portal.netlet.econnection.MessageConstants;
import com.sun.portal.netlet.econnection.ReaderWriterCrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class ReaderWriterEncrypt
extends ReaderWriterCrypt
implements MessageConstants {
    private long activityTime = System.currentTimeMillis();
    private int netletKeepAliveInterval = 0;

    public ReaderWriterEncrypt(ReaderWriterLock l, InputStream inStream, OutputStream outStream, int netletKeepAliveInterval) {
        super(l, inStream, outStream);
        this.netletKeepAliveInterval = netletKeepAliveInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        DataCipherMsg dMsg = new DataCipherMsg();
        try {
            int numBytes = 0;
            byte[] buffer = new byte[8192];
            while (this.go) {
                try {
                    numBytes = this.in.read(buffer, 0, 4096);
                    if (numBytes > 0) {
                        dMsg.setDataByRef(buffer, numBytes);
                        if (this.rwLock.atomicWriteMsg(dMsg, this.out) != 0) continue;
                        this.sent = true;
                        this.activityTime = System.currentTimeMillis();
                        continue;
                    }
                    if (numBytes == 0) {
                        System.out.println("ReaderWriterEncrypt received 0 bytes");
                        continue;
                    }
                    this.go = false;
                }
                catch (InterruptedIOException iioe) {
                    int rc = this.rwLock.atomicWriteDummyMsg(this.out);
                    if (rc != -1) continue;
                    this.go = false;
                    Object var7_8 = null;
                    this.rwLock.atomicWriteCloseConnectionMsg(dMsg, this.out);
                    this.rwLock.atomicStop(this);
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
                catch (Exception e) {
                    System.out.println("ReaderWriterEncrypt caught exception:");
                    e.printStackTrace();
                    this.go = false;
                    Object var7_9 = null;
                    this.rwLock.atomicWriteCloseConnectionMsg(dMsg, this.out);
                    this.rwLock.atomicStop(this);
                    this.rwLock.notifyFinished(this);
                    this.rwLock = null;
                    return;
                }
                Object var7_7 = null;
                this.rwLock.atomicWriteCloseConnectionMsg(dMsg, this.out);
                this.rwLock.atomicStop(this);
                this.rwLock.notifyFinished(this);
                this.rwLock = null;
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.rwLock.atomicWriteCloseConnectionMsg(dMsg, this.out);
            this.rwLock.atomicStop(this);
            this.rwLock.notifyFinished(this);
            this.rwLock = null;
            throw throwable;
        }
        Object var7_10 = null;
        this.rwLock.atomicWriteCloseConnectionMsg(dMsg, this.out);
        this.rwLock.atomicStop(this);
        this.rwLock.notifyFinished(this);
        this.rwLock = null;
    }

    protected int writeDummyMsg(DataOutputStream out) {
        try {
            out.writeByte(1);
            out.writeShort(4);
            out.writeInt(0);
            out.writeInt(0);
        }
        catch (IOException ioe) {
            System.out.println("ReaderWriterEncrypt caught exception while sending dummy msg:");
            ioe.printStackTrace();
            return -1;
        }
        return 0;
    }

    public long getLastActivityTime() {
        return this.activityTime;
    }
}

