/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.econnection;

import com.sun.portal.netlet.econnection.CipherMsg;
import com.sun.portal.netlet.econnection.ProxyMsgConstants;
import com.sun.portal.netlet.econnection.SizeConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ProxyCipherMsg
extends CipherMsg
implements ProxyMsgConstants,
SizeConstants {
    protected int srcPort;
    protected int hostNameLen;
    protected byte[] hostName;
    protected final int MAX_HOSTNAME_LEN = 255;
    protected final int MAX_PROXY_LEN = 263;
    protected int dstPortLen;
    protected byte[] dstPortList;

    public ProxyCipherMsg() {
        super((byte)1, (short)2);
    }

    public ProxyCipherMsg(int sp, byte[] dp, int dpl, byte[] hn, int hnl) {
        super((byte)1, (short)2);
        if (hnl <= 255) {
            this.srcPort = sp;
            this.dstPortLen = dpl;
            this.dstPortList = new byte[dpl];
            System.arraycopy(dp, 0, this.dstPortList, 0, dpl);
            this.hostNameLen = hnl;
            this.hostName = new byte[hnl];
            this.msgLen = 12 + hnl + dpl;
            System.arraycopy(hn, 0, this.hostName, 0, hnl);
        }
    }

    public int readMsg(DataInputStream in) {
        int rc = 0;
        rc = this.readHeader(in);
        if (rc == 0) {
            if (this.msgLen > 0 && this.msgLen <= 263) {
                byte[] buffer = new byte[this.msgLen];
                try {
                    in.readFully(buffer, 0, this.msgLen);
                    DataInputStream db_in = new DataInputStream(new ByteArrayInputStream(buffer));
                    this.srcPort = db_in.readInt();
                    this.dstPortLen = db_in.readInt();
                    this.dstPortList = new byte[this.dstPortLen];
                    this.hostNameLen = db_in.readInt();
                    if (this.hostNameLen > 512) {
                        rc = -1;
                    } else {
                        this.hostName = new byte[this.hostNameLen];
                    }
                    db_in.readFully(this.dstPortList, 0, this.dstPortLen);
                    db_in.readFully(this.hostName, 0, this.hostNameLen);
                }
                catch (IOException e) {
                    System.out.println("ProxyMsg: IOE reading proxy info: " + e);
                    rc = -1;
                }
            } else {
                rc = -1;
            }
        }
        return rc;
    }

    public int writeMsg(DataOutputStream out) {
        int rc = 0;
        if (this.hostNameLen > 0 && this.hostNameLen < 255) {
            try {
                ByteArrayOutputStream d_out = new ByteArrayOutputStream(this.msgLen);
                DataOutputStream dd_out = new DataOutputStream(d_out);
                dd_out.writeInt(this.srcPort);
                dd_out.writeInt(this.dstPortLen);
                dd_out.writeInt(this.hostNameLen);
                d_out.write(this.dstPortList, 0, this.dstPortLen);
                d_out.write(this.hostName, 0, this.hostNameLen);
                byte[] buffer = new byte[this.msgLen];
                System.arraycopy(d_out.toByteArray(), 0, buffer, 0, this.msgLen);
                ByteArrayOutputStream b_out = new ByteArrayOutputStream(274);
                int oldmsgLen = this.msgLen;
                this.writeHeaderToByteArray(b_out);
                b_out.write(buffer, 0, this.msgLen);
                b_out.writeTo(out);
                out.flush();
                this.msgLen = oldmsgLen;
                buffer = null;
            }
            catch (IOException e) {
                System.out.println("ProxyMsg: IOE writing proxy info: " + e);
                rc = -1;
            }
        } else {
            rc = -1;
        }
        return rc;
    }

    public byte[] getToDataStream() {
        ByteArrayOutputStream b_out = new ByteArrayOutputStream(263);
        DataOutputStream db_out = new DataOutputStream(b_out);
        try {
            db_out.writeInt(this.srcPort);
            db_out.writeInt(this.dstPortLen);
            db_out.writeInt(this.hostNameLen);
            b_out.write(this.dstPortList, 0, this.dstPortLen);
            b_out.write(this.hostName, 0, this.hostNameLen);
        }
        catch (IOException e) {
            System.out.println("ProxyMsg: IOE writing proxy info to data stream: " + e);
            return null;
        }
        return b_out.toByteArray();
    }

    public int setFromDataStream(byte[] buffer, int buffer_len) {
        int rc = 0;
        if (buffer_len > 0 && buffer_len <= 263) {
            try {
                DataInputStream db_in = new DataInputStream(new ByteArrayInputStream(buffer));
                this.msgLen = buffer_len;
                this.srcPort = db_in.readInt();
                this.dstPortLen = db_in.readInt();
                this.dstPortList = new byte[this.dstPortLen];
                this.hostNameLen = db_in.readInt();
                if (this.hostNameLen > 512) {
                    rc = -1;
                } else {
                    this.hostName = new byte[this.hostNameLen];
                }
                db_in.readFully(this.dstPortList, 0, this.dstPortLen);
                db_in.readFully(this.hostName, 0, this.hostNameLen);
            }
            catch (IOException e) {
                System.out.println("ProxyMsg: IOE reading proxy info from data stream: " + e);
                rc = -1;
            }
        } else {
            rc = -1;
        }
        return rc;
    }

    public int getSrcPort() {
        return this.srcPort;
    }

    public void setSrcPort(int sp) {
        this.srcPort = sp;
    }

    public String getDstPort() {
        return new String(this.dstPortList);
    }

    public String getHostName() {
        return new String(this.hostName);
    }

    public void setHostName(String hn) {
        this.hostNameLen = 0;
        if (this.hostName != null) {
            this.hostName = null;
        }
        if (hn.length() <= 255) {
            this.hostNameLen = hn.length();
            this.hostName = new byte[this.hostNameLen];
            System.arraycopy(hn, 0, this.hostName, 0, this.hostNameLen);
        }
    }
}

