/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp;

import com.sun.portal.netlet.client.common.BrowserType;
import com.sun.portal.netlet.client.common.ClientConfig;
import com.sun.portal.netlet.client.common.ClientUtil;
import com.sun.portal.netlet.client.common.ProxyAuthFailedException;
import com.sun.portal.netlet.client.common.ProxyAuthNeededException;
import com.sun.portal.netlet.client.common.ProxyInfo;
import com.sun.portal.netlet.client.common.ProxyInfoDialog;
import com.sun.portal.netlet.client.common.ProxyInfoHelpDialog;
import com.sun.portal.netlet.client.common.ProxySConn;
import com.sun.portal.netlet.client.common.ProxyWarning;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.InputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;

public class JWSProxyInfo
implements ProxyInfo,
ActionListener,
ItemListener {
    private boolean proxyMode = false;
    private String proxySSL = "";
    private int proxySSLPort = 0;
    private Vector noProxiesFor = new Vector();
    private ProxyWarning pw = null;
    private static ProxyInfoDialog pid = null;
    private static ProxyInfoHelpDialog pihd = null;

    public JWSProxyInfo() {
        if (ClientConfig.isProxyletMode()) {
            this.loadProxyFromProxylet();
        } else {
            this.loadProxyFromJWS();
        }
        if (this.inNoProxiesFor(ClientConfig.getDestHost())) {
            this.proxyMode = false;
            System.out.println("Host : " + ClientConfig.getDestHost() + " in noProxyList, setting proxyType to DIRECT");
        }
    }

    private void loadProxyFromProxylet() {
        this.proxySSL = System.getProperty("com.sun.portal.proxylet.proxyHost");
        String portStr = System.getProperty("com.sun.portal.proxylet.proxyPort");
        if (portStr != null && portStr.length() > 0) {
            this.proxySSLPort = Integer.parseInt(portStr);
        }
        System.out.println("JWSProxyInfo.loadProxyFromProxylet proxySSL " + this.proxySSL);
        System.out.println("JWSProxyInfo.loadProxyFromProxylet proxySSLPort " + this.proxySSLPort);
        if (this.proxySSL == null || this.proxySSLPort < 0) {
            this.proxySSL = "";
            this.proxySSLPort = 0;
            this.proxyMode = false;
        } else {
            this.proxyMode = true;
        }
    }

    private void loadProxyFromJWS() {
        this.proxySSL = System.getProperty("https.proxyHost");
        String strPort = System.getProperty("https.proxyPort");
        if (strPort != null && strPort.length() > 0) {
            this.proxySSLPort = Integer.parseInt(strPort);
        }
        if (this.proxySSL == null || this.proxySSLPort < 0) {
            this.proxySSL = "";
            this.proxySSLPort = 0;
            this.proxyMode = false;
        } else {
            this.proxyMode = true;
        }
        String proxyOverrideList = System.getProperty("https.nonProxyHosts");
        System.out.println("Proxy override - " + proxyOverrideList);
        this.parseProxyOverrideList(proxyOverrideList);
        if (!this.isProxySettingsValid()) {
            this.useNetletProfile();
        }
    }

    private void parseProxyOverrideList(String proxyOverrideList) {
        if (proxyOverrideList == null || proxyOverrideList.trim().length() == 0) {
            return;
        }
        StringTokenizer nst = new StringTokenizer(proxyOverrideList, "|");
        while (nst.hasMoreTokens()) {
            String s = nst.nextToken().toLowerCase().trim();
            if (s.trim().length() == 0) continue;
            this.noProxiesFor.addElement(s);
        }
    }

    private boolean isProxySettingsValid() {
        Socket out_s;
        ProxySConn sconn = null;
        if (this.proxyMode) {
            try {
                sconn = new ProxySConn(this.proxySSLPort, this.proxySSL, ClientConfig.getDestPort(), ClientConfig.getDestHost(), null);
            }
            catch (ProxyAuthNeededException e) {
                try {
                    sconn = new ProxySConn(this.proxySSLPort, this.proxySSL, ClientConfig.getDestPort(), ClientConfig.getDestHost(), true, null);
                }
                catch (ProxyAuthNeededException ee) {
                    System.out.println("Invalid proxy information");
                }
                catch (ProxyAuthFailedException ee) {
                    System.out.println("Invalid proxy information");
                }
            }
            catch (ProxyAuthFailedException e) {
                System.out.println("Invalid proxy information");
            }
        } else {
            sconn = new ProxySConn(ClientConfig.getDestPort(), ClientConfig.getDestHost(), null);
        }
        return (out_s = sconn.getconn()) != null;
    }

    private void useNetletProfile() {
        this.readNetletProfile();
        boolean valid = this.isProxySettingsValid();
        if (!valid) {
            pid = new ProxyInfoDialog(new JFrame(), this, this);
            pid.showWarning();
            pid.waitForAction();
            valid = this.isProxySettingsValid();
            if (valid) {
                System.setProperty("https.proxyHost", this.proxySSL);
                System.setProperty("https.proxyPort", Integer.toString(this.proxySSLPort));
                this.storeProxySettings();
            }
        } else {
            System.setProperty("https.proxyHost", this.proxySSL);
            System.setProperty("https.proxyPort", Integer.toString(this.proxySSLPort));
            this.parseProxyOverrideList(ClientConfig.getParam("proxyoverride"));
        }
    }

    private void readNetletProfile() {
        String temp = ClientConfig.getParam("proxytype");
        this.proxyMode = temp == null || !temp.equalsIgnoreCase("DIRECT");
        temp = ClientConfig.getParam("proxyhost");
        if (temp != null && temp.trim().length() != 0) {
            this.proxySSL = temp;
        }
        if ((temp = ClientConfig.getParam("proxyport")) != null && temp.trim().length() != 0) {
            try {
                this.proxySSLPort = Integer.parseInt(temp);
            }
            catch (NumberFormatException nfe) {
                this.proxySSLPort = 0;
            }
        }
    }

    private void storeProxySettings() {
        String postBody = "&proxytype=";
        postBody = !this.proxyMode ? postBody + "DIRECT" : postBody + "MANUAL";
        postBody = postBody + "&proxyhost=" + this.proxySSL;
        postBody = postBody + "&proxyport=" + this.proxySSLPort;
        String temp = this.noProxiesFor.toString();
        temp = temp.substring(temp.indexOf("[") + 1, temp.indexOf("]")).trim();
        postBody = postBody + "&proxyoverride=" + temp;
        InputStream in = ClientUtil.sendByPost("storeProxySettings", postBody);
    }

    public String getProxySSL() {
        return this.proxySSL;
    }

    public int getProxySSLPort() {
        return this.proxySSLPort;
    }

    public boolean getProxyMode() {
        return this.proxyMode;
    }

    private boolean inNoProxiesFor(String host) {
        System.out.println("inNoProxiesFor host " + host);
        Enumeration e = this.noProxiesFor.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            System.out.println("noProxyList element " + s);
            if (!ClientUtil.wildcardMatch(host.toLowerCase(), s.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent evt) {
        Object obj = evt.getSource();
        if ("OK".equals(evt.getActionCommand())) {
            if (obj == JWSProxyInfo.pid.ok) {
                pid.setVisible(false);
                if (JWSProxyInfo.pid.direct.isSelected()) {
                    this.proxyMode = false;
                } else if (JWSProxyInfo.pid.manual.isSelected()) {
                    this.proxyMode = true;
                    this.proxySSL = JWSProxyInfo.pid.proxyHost.getText();
                    try {
                        this.proxySSLPort = Integer.parseInt(JWSProxyInfo.pid.proxyPort.getText());
                    }
                    catch (NumberFormatException nfe) {
                        this.proxySSLPort = 0;
                        System.out.println("Invalid SSL proxy host: " + nfe);
                    }
                    this.parseProxyOverrideList(JWSProxyInfo.pid.noProxy.getText());
                } else if (JWSProxyInfo.pid.auto.isSelected()) {
                    this.parsePACFileURL(JWSProxyInfo.pid.autoURL.getText());
                }
                if (pihd != null) {
                    pihd.setVisible(false);
                    pihd = null;
                }
                pid.notifyAction();
            }
        } else if ("Cancel".equals(evt.getActionCommand())) {
            if (obj == JWSProxyInfo.pid.cancel) {
                pid.setVisible(false);
                if (pihd != null) {
                    pihd.setVisible(false);
                    pihd = null;
                }
                pid.notifyAction();
            }
        } else if ("Help".equals(evt.getActionCommand()) && obj == JWSProxyInfo.pid.help) {
            if (pihd == null) {
                pihd = new ProxyInfoHelpDialog(new JFrame());
            }
            pihd.show();
        }
    }

    private void parsePACFileURL(String pacFileURL) {
        if (pacFileURL == null || pacFileURL.trim().length() == 0) {
            this.proxyMode = false;
            return;
        }
        String inputLine = ClientUtil.parsePACFile(pacFileURL);
        if (inputLine == null || inputLine.trim().length() == 0 || inputLine.equals("null")) {
            this.proxyMode = false;
            return;
        }
        if (inputLine.equalsIgnoreCase("DIRECT")) {
            this.proxyMode = false;
            return;
        }
        if (inputLine.startsWith("PROXY")) {
            this.proxyMode = true;
            if (inputLine.length() > 5) {
                String proxySt = inputLine.substring(5);
                int firstProxy = proxySt.indexOf(";");
                if (firstProxy < 0) {
                    firstProxy = proxySt.length();
                }
                String firstProxyURL = proxySt.substring(0, firstProxy);
                int index = firstProxyURL.lastIndexOf(":");
                String proxyPort = firstProxyURL.substring(index + 1);
                String proxyHost = firstProxyURL.substring(0, index);
                this.proxySSL = proxyHost.trim();
                try {
                    this.proxySSLPort = Integer.parseInt(proxyPort);
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Invalid SSL Proxy port");
                    this.proxySSLPort = 0;
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent evt) {
        if (JWSProxyInfo.pid.direct.isSelected()) {
            pid.setState(0);
        } else if (JWSProxyInfo.pid.manual.isSelected()) {
            pid.setState(1);
        } else if (JWSProxyInfo.pid.auto.isSelected()) {
            pid.setState(2);
        }
    }

    public ProxyWarning getProxyWarning() {
        if (this.pw == null) {
            this.pw = new ProxyWarning(new Frame(), this, BrowserType.getInstance().getBrowserName());
        }
        return this.pw;
    }
}

