/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.sun.portal.netlet.client.common.NetletSocketWrapper;
import java.net.Socket;

public class NetletSocketFactory {
    private static boolean isHTTPSGW = true;
    private NetletSocketWrapper nsw = null;
    private static NetletSocketFactory nsf = null;
    private boolean isJSSEEnabled = false;
    private boolean requireClientCert = false;

    private NetletSocketFactory(String gwProtocol, boolean isJSSEEnabled, boolean requireClientCert) {
        isHTTPSGW = gwProtocol.equalsIgnoreCase("https");
        this.isJSSEEnabled = isJSSEEnabled;
        this.requireClientCert = requireClientCert;
        this.init();
    }

    public Socket getSocket(String destHost, int destPort, String[] cipherSuites) {
        return this.nsw.getSocket(destHost, destPort, cipherSuites);
    }

    public Socket getSocket(Socket tunnelSocket, String host, int port, String[] cipherSuites) {
        return this.nsw.getSocket(tunnelSocket, host, port, cipherSuites);
    }

    public static synchronized NetletSocketFactory getNetletSocketFactory(String gwProtocol, boolean isJSSE, boolean requireClientCert) {
        if (nsf == null) {
            nsf = new NetletSocketFactory(gwProtocol, isJSSE, requireClientCert);
        }
        return nsf;
    }

    private void init() {
        try {
            this.nsw = !isHTTPSGW ? (NetletSocketWrapper)Class.forName("com.sun.portal.netlet.client.common.PlainSocketWrapper").newInstance() : (!this.isJSSEEnabled ? (NetletSocketWrapper)Class.forName("com.sun.portal.netlet.client.common.KSSLSocketWrapper").newInstance() : (NetletSocketWrapper)Class.forName("com.sun.portal.netlet.client.common.JSSEWrapper").newInstance());
            this.nsw.init(this.requireClientCert);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

