/*
 * Decompiled with CFR 0.152.
 */
package com.sun.addressbook.wabp;

import com.sun.addressbook.ABDebug;
import com.sun.addressbook.ABSearchTerm;
import com.sun.addressbook.ABStoreException;

public class WabpABSearchTerm
extends ABSearchTerm {
    public WabpABSearchTerm(String name, String value, boolean exact) {
        super(name, value, exact);
    }

    public WabpABSearchTerm(ABSearchTerm term, int op) throws ABStoreException {
        super(term, op);
    }

    public WabpABSearchTerm(ABSearchTerm[] terms, int op) throws ABStoreException {
        super(terms, op);
    }

    public Object compute() throws ABStoreException {
        String searchFilter = null;
        String operator = null;
        if (this.terms != null) {
            if (this.op == 0) {
                searchFilter = "(!" + this.terms[0].compute() + ")";
                return searchFilter;
            }
            if (this.op == 2) {
                operator = "&";
            } else if (this.op == 1) {
                operator = "|";
            } else {
                String msg = "WabpABSearchTerm: invalid operator: " + this.op + ". Operator can only be one of AND/OR/NOT";
                throw new ABStoreException(msg);
            }
            searchFilter = operator;
            for (int i = 0; i < this.terms.length; ++i) {
                searchFilter = searchFilter + "(" + this.terms[i].compute() + ")";
            }
        } else {
            searchFilter = this.computeTerm(this);
        }
        ABDebug.logMessage("WabpABSearchTerm: compute search filter = " + searchFilter);
        return searchFilter;
    }

    private String computeTerm(ABSearchTerm searchTerm) {
        String term = null;
        String newValue = null;
        String searchVal = searchTerm.getValue();
        newValue = !searchTerm.isExact() && searchVal != null && searchVal.indexOf(42) < 0 ? "*" + searchVal + "*" : searchVal;
        if (searchTerm.getName().equals("any")) {
            term = "entry/displayname=" + newValue;
        } else {
            String key = searchTerm.getName();
            if (key.equals("fn")) {
                key = "person/givenname";
            } else if (key.equals("ln")) {
                key = "person/surname";
            } else if (key.equals("cn")) {
                key = "entry/displayname";
            } else if (key.equals("em")) {
                key = "email";
            } else if (key.equals("bp")) {
                key = "phone";
            } else if (key.equals("fp")) {
                key = "phone";
            } else if (key.equals("hp")) {
                key = "phone";
            } else if (key.equals("mp")) {
                key = "phone";
            } else if (key.equals("pp")) {
                key = "phone";
            }
            term = key + "=" + newValue;
        }
        ABDebug.logMessage("WabpABSearchTerm: compute term = " + term);
        return term;
    }
}

