/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.UserSession;
import com.iplanet.xslui.auth.UserSessionFactory;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import com.iplanet.xslui.ui.XSLServlet;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class XSLAuthServlet
extends XSLServlet {
    public static final String CONFIG_FILENAME = "xslauth.properties";
    public static final String CONFIG_USERSESSION_PREFIX = "usersession";
    public static final String CONFIG_DEFAULTDOMAIN = "defaultdomain";
    private UserSessionFactory _userFactory = null;
    private String _defaultDomain = null;

    public void init(ServletConfig config) throws ServletException {
        this._config_filename = CONFIG_FILENAME;
        super.init(config);
        PropertyReader propertyReader = super.getPropertyReader();
        this._defaultDomain = propertyReader.getStringProperty(CONFIG_DEFAULTDOMAIN, "iplanet.com");
        try {
            this._userFactory = (UserSessionFactory)propertyReader.getObjectProperty(CONFIG_USERSESSION_PREFIX, true);
        }
        catch (Exception ex) {
            Logging.error(2, "Exception thrown while creating UserFactory");
            Logging.errorPrintStackTrace(ex);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String passwd;
        HttpSession session = request.getSession(true);
        UserSession userSession = (UserSession)session.getAttribute("com.iplanet.xslui.ui.usersession");
        if (userSession != null) {
            return;
        }
        session.setAttribute("domainname", (Object)this._defaultDomain);
        this.log("brand new session");
        String uid = request.getParameter("login");
        if (uid == null) {
            return;
        }
        Logging.trace(8, "login from " + uid);
        if (!(uid.equals("anonymous") || (passwd = request.getParameter("password")) != null && passwd.equals("iplanet"))) {
            return;
        }
        userSession = this._userFactory.newUserSession(uid, this._defaultDomain);
        if (userSession == null) {
            Logging.trace(8, "couldnt create user " + uid + "(domain " + this._defaultDomain + ")");
            return;
        }
        String lang = userSession.getPreferredLanguage();
        session.setAttribute("userlang", (Object)lang);
        session.setAttribute("com.iplanet.xslui.ui.usersession", (Object)userSession);
    }
}

