/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.auth;

import com.iplanet.xslui.auth.Domain;
import com.iplanet.xslui.auth.DomainMap;
import com.iplanet.xslui.auth.LDAPDomain;
import com.iplanet.xslui.tools.LDAPConfigReader;
import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;

public class LDAPDomainMap
implements DomainMap {
    public static final String DOMAINMAPCONFIGPREFIX = "domainmap.";
    public static final String DCROOT = "domainmap.dcroot";
    public static final String DOMAINATTR = "domainmap.domainattr";
    public static final String DOMAINFILTER = "domainmap.domainfilter";
    public static final String ENABLED = "domainmap.enabled";
    private LDAPPool _ldapPool = null;
    private String _dcroot = null;
    private String[] _domainAttr = null;
    private String _domainFilter = null;
    private Hashtable _domainMap = null;

    public boolean init(File configPath) {
        PropertyReader propertyReader = null;
        try {
            propertyReader = new PropertyReader(configPath);
        }
        catch (IOException ioe) {
            Logging.error(64, "LDAPDomainMap: Cant read config at: " + configPath.getAbsolutePath() + ":" + ioe.getMessage());
            return false;
        }
        if (!propertyReader.getBooleanProperty(ENABLED, "false")) {
            return false;
        }
        try {
            this._ldapPool = LDAPConfigReader.getLDAPPool((PropertyReader)propertyReader, (String)DOMAINMAPCONFIGPREFIX);
        }
        catch (LDAPException le) {
            Logging.error(64, "LDAPDomainMap: Cant get LDAP pool: " + configPath.getAbsolutePath() + ":" + le.getMessage());
            return false;
        }
        this._dcroot = propertyReader.getStringProperty(DCROOT, "o=internet");
        if (this._dcroot.length() > 0) {
            this._dcroot = "," + this._dcroot;
        }
        this._domainAttr = propertyReader.getStringArrayProperty(DOMAINATTR, "inetDomainBaseDN");
        this._domainFilter = propertyReader.getStringProperty(DOMAINFILTER, "objectClass=*");
        this._domainMap = new Hashtable();
        return true;
    }

    public Domain getDomainObject(String domainName) {
        int j;
        Domain domain = (Domain)this._domainMap.get(domainName);
        if (domain != null) {
            return domain;
        }
        String domaindn = "dc=";
        int i = 0;
        while ((j = domainName.indexOf(46, i)) != -1) {
            domaindn = domaindn + domainName.substring(i, j) + ",dc=";
            i = j + 1;
        }
        domaindn = domaindn + domainName.substring(i) + this._dcroot;
        LDAPConnection ldapc = null;
        try {
            ldapc = this._ldapPool.getConnection();
        }
        catch (LDAPException le) {
            Logging.error(64, "couldn't get a connection from the pool:" + le.getMessage());
            return null;
        }
        if (ldapc == null) {
            Logging.error(64, "couldn't get a connection from the pool: timeout");
            return null;
        }
        try {
            LDAPSearchResults results = ldapc.search(domaindn, 0, this._domainFilter, this._domainAttr, false);
            if (!results.hasMoreElements()) {
                Logging.error(64, "LDAPDomainMap: no result for: " + domainName);
                this._ldapPool.close(ldapc);
                return null;
            }
            LDAPEntry entry = results.next();
            domain = new LDAPDomain(domainName, entry);
        }
        catch (LDAPException e) {
            Logging.error(64, "LDAPDomainMap: search Returned: " + e.toString() + "for " + domainName);
            this._ldapPool.close(ldapc);
            return null;
        }
        this._ldapPool.close(ldapc);
        this._domainMap.put(domainName, domain);
        return domain;
    }
}

