/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.portlet.cli.PDDPUpdater;
import com.sun.portal.portlet.cli.PDProviderEntryGenerator;
import com.sun.portal.portlet.cli.PortletDeployerException;
import com.sun.portal.portlet.cli.PortletDeployerLocalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;

class PDUNDeploy {
    private static final String CONFIG_LOCATION_PROPERTY = "deployer.propertiesFile";
    private static final String DD_LOCATION = "DDFileLocation";
    private static final String DD_SUFFIX = "_portlet.xml";
    private Properties configProps = new Properties();

    public PDUNDeploy() throws PortletDeployerException {
        String configName = System.getProperty(CONFIG_LOCATION_PROPERTY);
        if (configName == null) {
            throw new PortletDeployerException("errorConfigFile");
        }
        try {
            this.configProps.load(new FileInputStream(configName));
        }
        catch (FileNotFoundException fnfe) {
            Object[] tokens = new Object[]{fnfe.toString()};
            throw new PortletDeployerException("errorConfigFile", tokens);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorConfigFile", tokens);
        }
    }

    public String process(DSAMEAdminDPContext dadc, String dn, boolean global, String warName, boolean verbose) throws PortletDeployerException {
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgGettingPortletDD");
        }
        String ddLocation = this.configProps.getProperty(DD_LOCATION);
        String ddName = warName + DD_SUFFIX;
        FileInputStream in = null;
        File portletFile = null;
        try {
            portletFile = new File(ddLocation, ddName);
            in = new FileInputStream(portletFile);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorStreamRead", tokens);
        }
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgCreatingProviderNames");
        }
        PDProviderEntryGenerator providerGen = new PDProviderEntryGenerator(in, null, this.configProps, warName);
        List providerNames = providerGen.getProviderNames();
        try {
            ((InputStream)in).close();
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new PortletDeployerException("errorStreamClose", tokens);
        }
        if (verbose) {
            PortletDeployerLocalizer.debug("dbgRemovingProviders");
        }
        PDDPUpdater dpUpdater = new PDDPUpdater(dadc, dn, global, verbose);
        dpUpdater.removeProviders(providerNames);
        if (portletFile != null) {
            portletFile.delete();
        }
        return PortletDeployerLocalizer.getLocalizedString("msgSuccess");
    }
}

