/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.cli;

import com.sun.portal.common.logging.Logger;
import com.sun.portal.common.logging.impl.LoggerImpl;
import com.sun.portal.portlet.cli.PortletDeployerException;
import com.sun.portal.portletcontainercommon.PortletPreferencesUtility;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorException;
import com.sun.portal.portletcontainercommon.descriptor.DeploymentDescriptorReader;
import com.sun.portal.portletcontainercommon.descriptor.PortletAppDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletInfoDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletPreferencesDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PortletsDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.PreferenceDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityConstraintDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SecurityRoleRefDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.SupportsDescriptor;
import com.sun.portal.portletcontainercommon.descriptor.UserAttributeDescriptor;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDProviderEntryGenerator {
    public static final String PortletWindowClassName = "com.sun.portal.providers.portletwindow.PortletWindowProvider";
    public static final String[][] defaultProperties = new String[][]{{"width", "thick"}, {"fontFace1", "Sans-serif"}, {"productName", "Sun JavaTM System Portal Server"}};
    public static final String[][] advancedProperties = new String[][]{{"refreshTime", "0"}, {"editType", "edit_complete"}, {"contentPage", "PortletHelp.jsp"}, {"editPage", "PortletEdit.jsp"}, {"processPage", ""}};
    public static final String mimeType = "text/html";
    public static final String PORTLET_PREFIX = "__Portlet__";
    public static final String PREF_PROPS_NAME = "__Portlet__PreferenceProperties";
    public static final String ADDL_PREF_NAME = "__Portlet__AdditionalPreferences";
    public static final String DOT_SEPARATOR = ".";
    public static final String ENTITY_ID_PREFIX_NAME = "entityIDPrefix";
    public static final String TITLE_NAME = "title";
    public static final String SHORT_TITLE_NAME = "shortTitle";
    public static final String KEYWORDS_NAME = "keywords";
    public static final String CONTENT_TYPE_NAME = "supportedContentTypes";
    public static final String TRANSPORT_GUARANTEE_NAME = "transportGuarantee";
    public static final String IS_EDITABLE_COLLECTION = "isEditableByMimeType";
    public static final String HAS_HELP_COLLECTION = "hasHelpByMimeType";
    public static final String ROLE_MAP_NAME = "roleMap";
    public static final String ROLE_DESCRIPTIONS_NAME = "roleDescriptions";
    public static final String SUPPORTS_MAP_NAME = "supportsMap";
    public static final String SUPPORTED_LOCALES_MAP_NAME = "supportedLocalesMap";
    public static final String DISPLAY_NAME_MAP_NAME = "displayNameMap";
    public static final String DESCRIPTION_MAP_NAME = "descriptionMap";
    public static final String UI_MAP_NAME = "userInfoMap";
    public static final String UI_DESCRIPTIONS_NAME = "userInfoDescriptions";
    public static final String NAME_STRING = "name";
    public static final String VALUE_STRING = "value";
    public static final String ADVANCED_STRING = "advanced";
    public static final String CLASS_STRING = "class";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String HELP_URL = "helpURL";
    private PortletsDescriptor psd = null;
    private PortletAppDescriptor pad = null;
    private String portletAppName = null;
    private Properties configProps = null;

    public PDProviderEntryGenerator(InputStream in, InputStream extStream, Properties props, String appName) throws PortletDeployerException {
        this.configProps = props;
        String DDSchemaLocation = System.getProperty(DeploymentDescriptorReader.PORTLET_SCHEMA_LOCATION);
        DeploymentDescriptorReader ddReader = new DeploymentDescriptorReader(this.getLogger(), DDSchemaLocation);
        String validateProp = this.configProps.getProperty("validate_schema");
        try {
            if (validateProp != null && validateProp.toLowerCase().equals(TRUE)) {
                System.setProperty("validate_schema", TRUE);
            }
            this.pad = ddReader.loadPortletAppDescriptor(in, extStream);
        }
        catch (DeploymentDescriptorException dde) {
            Object[] tokens = new Object[]{dde.toString()};
            throw new PortletDeployerException("errorReadingPortletDD", tokens);
        }
        this.portletAppName = appName;
        this.psd = this.pad.getPortletsDescriptor();
    }

    public String getPortletAppName() {
        return this.portletAppName;
    }

    public List createProviderElements(Properties roleProps, Properties uiProps, List webAppRoles) throws PortletDeployerException {
        ArrayList<Element> providerElements = new ArrayList<Element>();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception ex) {
            Object[] tokens = new Object[]{ex.toString()};
            throw new PortletDeployerException("errorDocumentBuilder", tokens);
        }
        Document d = null;
        try {
            d = db.newDocument();
        }
        catch (Exception e) {
            Object[] tokens = new Object[]{e.toString()};
            throw new PortletDeployerException("errorNewDocument", tokens);
        }
        List portletDescriptors = this.psd.getPortletDescriptors();
        for (int i = 0; i < portletDescriptors.size(); ++i) {
            String tgType;
            List constrainedPortlets;
            SecurityConstraintDescriptor scd;
            List supportedLocales;
            Map descriptionMap;
            Map displayNameMap;
            List supportsDescriptors;
            Iterator<Object> j;
            Iterator<Object> j2;
            List securityRoleRefDescriptors;
            String mode;
            PortletDescriptor pd = (PortletDescriptor)portletDescriptors.get(i);
            String portletName = pd.getPortletName();
            String providerName = PORTLET_PREFIX + this.portletAppName + DOT_SEPARATOR + portletName;
            String entityIDPrefix = this.portletAppName + "|" + portletName;
            PortletInfoDescriptor pInfo = pd.getPortletInfoDescriptor();
            String title = "javax.portlet.title";
            String shortTitle = null;
            List keywords = null;
            if (pInfo != null) {
                title = pInfo.getTitle();
                shortTitle = pInfo.getShortTitle();
                keywords = pInfo.getKeywords();
            }
            String description = "";
            if (pd.getDescription() != null) {
                description = pd.getDescription();
            }
            String isEditable = FALSE;
            String helpUrl = "";
            List supportedPortletModes = pd.getSupportedPortletModes(mimeType);
            if (supportedPortletModes != null) {
                for (int k = 0; k < supportedPortletModes.size(); ++k) {
                    String mode2 = (String)supportedPortletModes.get(k);
                    if (mode2.equalsIgnoreCase("EDIT")) {
                        isEditable = TRUE;
                        continue;
                    }
                    if (!mode2.equalsIgnoreCase("HELP")) continue;
                    helpUrl = HELP_URL;
                }
            }
            boolean sessionEnabled = pd.sessionEnabled();
            boolean allowSavePref = this.pad.isSavePreferencesAllowed();
            Element propertiesElement = null;
            try {
                propertiesElement = d.createElement("Properties");
                propertiesElement = this.addDefaultProperties(propertiesElement, d);
                propertiesElement.appendChild(this.createPropertyElement("String", d, TITLE_NAME, title, FALSE));
                if (shortTitle != null) {
                    propertiesElement.appendChild(this.createPropertyElement("String", d, SHORT_TITLE_NAME, shortTitle, TRUE));
                }
                if (keywords != null) {
                    Element keywordsElement = d.createElement("Collection");
                    keywordsElement.setAttribute(NAME_STRING, KEYWORDS_NAME);
                    keywordsElement.setAttribute(ADVANCED_STRING, TRUE);
                    Iterator j3 = keywords.iterator();
                    while (j3.hasNext()) {
                        String keyword = (String)j3.next();
                        Element keywordElement = this.createPropertyElement("String", d, null, keyword, FALSE);
                        keywordsElement.appendChild(keywordElement);
                    }
                    propertiesElement.appendChild(keywordsElement);
                }
                propertiesElement.appendChild(this.createPropertyElement("String", d, "description", description, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("String", d, ENTITY_ID_PREFIX_NAME, entityIDPrefix, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "isEditable", isEditable, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "showExceptions", FALSE, FALSE));
                propertiesElement.appendChild(this.createPropertyElement("String", d, HELP_URL, helpUrl, TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "sessionEnabled", new Boolean(sessionEnabled).toString(), TRUE));
                propertiesElement.appendChild(this.createPropertyElement("Boolean", d, "allowSavePref", new Boolean(allowSavePref).toString(), TRUE));
                Element emptyPref = d.createElement("Collection");
                emptyPref.setAttribute(NAME_STRING, ADDL_PREF_NAME);
                emptyPref.setAttribute(ADVANCED_STRING, TRUE);
                propertiesElement.appendChild(emptyPref);
            }
            catch (DOMException de) {
                Object[] tokens = new Object[]{de.toString()};
                throw new PortletDeployerException("errorCreatePropertiesElement", tokens);
            }
            PortletPreferencesDescriptor ppd = pd.getPortletPreferencesDescriptor();
            List preferenceDescriptors = null;
            if (ppd != null) {
                preferenceDescriptors = ppd.getPreferenceDescriptors();
            }
            try {
                Element prefPropsElement = d.createElement("Collection");
                prefPropsElement.setAttribute(NAME_STRING, PREF_PROPS_NAME);
                Element defaultElement = d.createElement("Collection");
                defaultElement.setAttribute(NAME_STRING, "default");
                Element isReadOnlyElement = d.createElement("Collection");
                isReadOnlyElement.setAttribute(NAME_STRING, "isReadOnly");
                if (preferenceDescriptors != null && !preferenceDescriptors.isEmpty()) {
                    for (int j4 = 0; j4 < preferenceDescriptors.size(); ++j4) {
                        PreferenceDescriptor prd = (PreferenceDescriptor)preferenceDescriptors.get(j4);
                        String name = prd.getPrefName();
                        List values = prd.getPrefValues();
                        String value = PortletPreferencesUtility.getPreferenceString((List)values);
                        defaultElement.appendChild(this.createPropertyElement("String", d, name, value, FALSE));
                        String isReadOnly = String.valueOf(prd.getReadOnly());
                        isReadOnlyElement.appendChild(this.createPropertyElement("Boolean", d, name, isReadOnly, FALSE));
                        propertiesElement.appendChild(this.createPropertyElement("String", d, PORTLET_PREFIX + name, value, FALSE));
                    }
                }
                prefPropsElement.appendChild(defaultElement);
                prefPropsElement.appendChild(isReadOnlyElement);
                propertiesElement.appendChild(prefPropsElement);
            }
            catch (DOMException de) {
                Object[] tokens = new Object[]{de.toString()};
                throw new PortletDeployerException("errorCreatePreferenceElement", tokens);
            }
            List supportDescriptors = pd.getSupportsDescriptors();
            if (!supportDescriptors.isEmpty()) {
                try {
                    Element contentTypeElement = d.createElement("Collection");
                    contentTypeElement.setAttribute(NAME_STRING, CONTENT_TYPE_NAME);
                    contentTypeElement.setAttribute(ADVANCED_STRING, TRUE);
                    Element isEditableCollection = d.createElement("Collection");
                    isEditableCollection.setAttribute(NAME_STRING, IS_EDITABLE_COLLECTION);
                    isEditableCollection.setAttribute(ADVANCED_STRING, TRUE);
                    Element hasHelpCollection = d.createElement("Collection");
                    hasHelpCollection.setAttribute(NAME_STRING, HAS_HELP_COLLECTION);
                    hasHelpCollection.setAttribute(ADVANCED_STRING, TRUE);
                    for (int j5 = 0; j5 < supportDescriptors.size(); ++j5) {
                        SupportsDescriptor sd = (SupportsDescriptor)supportDescriptors.get(j5);
                        String contentType = sd.getMimeType();
                        Element property = d.createElement("String");
                        property.setAttribute(VALUE_STRING, contentType);
                        contentTypeElement.appendChild(property);
                        String editable = FALSE;
                        String helpLink = "";
                        List supportedModes = pd.getSupportedPortletModes(contentType);
                        if (supportedModes != null) {
                            for (int k = 0; k < supportedModes.size(); ++k) {
                                mode = (String)supportedModes.get(k);
                                if (mode.equalsIgnoreCase("EDIT")) {
                                    editable = TRUE;
                                    continue;
                                }
                                if (!mode.equalsIgnoreCase("HELP")) continue;
                                helpLink = HELP_URL;
                            }
                        }
                        Element editableElement = d.createElement("Boolean");
                        editableElement.setAttribute(NAME_STRING, contentType);
                        editableElement.setAttribute(VALUE_STRING, editable);
                        isEditableCollection.appendChild(editableElement);
                        Element helpElement = d.createElement("String");
                        helpElement.setAttribute(NAME_STRING, contentType);
                        helpElement.setAttribute(VALUE_STRING, helpLink);
                        hasHelpCollection.appendChild(helpElement);
                    }
                    propertiesElement.appendChild(contentTypeElement);
                    propertiesElement.appendChild(isEditableCollection);
                    propertiesElement.appendChild(hasHelpCollection);
                }
                catch (DOMException de) {
                    Object[] tokens = new Object[]{de.toString()};
                    throw new PortletDeployerException("errorCreatecontentTypeElement", tokens);
                }
            }
            if ((securityRoleRefDescriptors = pd.getSecurityRoleRefDescriptors()).size() > 0) {
                Object[] tokens;
                Collection<Object> roleValues = roleProps.values();
                for (int k = 0; k < securityRoleRefDescriptors.size(); ++k) {
                    Object[] tokens2;
                    SecurityRoleRefDescriptor srd = (SecurityRoleRefDescriptor)securityRoleRefDescriptors.get(k);
                    String roleLink = srd.getRoleLink();
                    String portletRole = srd.getRoleName();
                    if (webAppRoles.contains(roleLink)) {
                        if (roleValues.contains(roleLink)) continue;
                        tokens2 = new Object[]{roleLink};
                        throw new PortletDeployerException("errorRoleMapping", tokens2);
                    }
                    if (webAppRoles.contains(portletRole)) {
                        if (roleValues.contains(portletRole)) continue;
                        tokens2 = new Object[]{portletRole};
                        throw new PortletDeployerException("errorRoleMapping", tokens2);
                    }
                    tokens2 = new Object[]{portletRole};
                    throw new PortletDeployerException("errorRoleValidation", tokens2);
                }
                Set<Object> roleKeys = roleProps.keySet();
                HashMap<String, String> reverseMap = new HashMap<String, String>();
                if (!roleKeys.isEmpty()) {
                    try {
                        Element roleMapElement = d.createElement("Collection");
                        roleMapElement.setAttribute(NAME_STRING, ROLE_MAP_NAME);
                        roleMapElement.setAttribute(ADVANCED_STRING, TRUE);
                        j2 = roleKeys.iterator();
                        while (j2.hasNext()) {
                            String key = (String)j2.next();
                            String value = roleProps.getProperty(key);
                            reverseMap.put(value, key);
                            roleMapElement.appendChild(this.createPropertyElement("String", d, key, value, FALSE));
                        }
                        propertiesElement.appendChild(roleMapElement);
                    }
                    catch (DOMException de) {
                        tokens = new Object[]{de.toString()};
                        throw new PortletDeployerException("errorCreateRoleMapElement", tokens);
                    }
                }
                System.out.println("security role refs exist");
                try {
                    boolean hasRoleDescriptions = false;
                    Element roleDescElement = d.createElement("Collection");
                    roleDescElement.setAttribute(NAME_STRING, ROLE_DESCRIPTIONS_NAME);
                    roleDescElement.setAttribute(ADVANCED_STRING, TRUE);
                    for (int k = 0; k < securityRoleRefDescriptors.size(); ++k) {
                        SecurityRoleRefDescriptor srd = (SecurityRoleRefDescriptor)securityRoleRefDescriptors.get(k);
                        Map roleDescMap = srd.getDescriptionMap();
                        System.out.println("roleDescMap=" + roleDescMap);
                        if (roleDescMap == null || roleDescMap.size() <= 0) continue;
                        hasRoleDescriptions = true;
                        String name = (String)reverseMap.get(srd.getRoleName());
                        if (name == null) {
                            throw new PortletDeployerException("could not lookup physical role name from portlet role name=" + srd.getRoleName());
                        }
                        Element roleDescSubElement = d.createElement("Collection");
                        roleDescSubElement.setAttribute(NAME_STRING, name);
                        roleDescSubElement.setAttribute(ADVANCED_STRING, TRUE);
                        Iterator j6 = roleDescMap.keySet().iterator();
                        while (j6.hasNext()) {
                            String lang = (String)j6.next();
                            String desc = (String)roleDescMap.get(lang);
                            roleDescSubElement.appendChild(this.createPropertyElement("String", d, lang, desc, FALSE));
                        }
                        roleDescElement.appendChild(roleDescSubElement);
                    }
                    if (hasRoleDescriptions) {
                        propertiesElement.appendChild(roleDescElement);
                    }
                }
                catch (DOMException de) {
                    tokens = new Object[]{de.toString()};
                    throw new PortletDeployerException("errorCreateRoleDescElement", tokens);
                }
            }
            if (!uiProps.isEmpty()) {
                try {
                    Element uiMapElement = d.createElement("Collection");
                    uiMapElement.setAttribute(NAME_STRING, UI_MAP_NAME);
                    uiMapElement.setAttribute(ADVANCED_STRING, TRUE);
                    Set<Object> keys = uiProps.keySet();
                    Iterator<Object> j7 = keys.iterator();
                    while (j7.hasNext()) {
                        String key = (String)j7.next();
                        String value = uiProps.getProperty(key);
                        uiMapElement.appendChild(this.createPropertyElement("String", d, key, value, FALSE));
                    }
                    propertiesElement.appendChild(uiMapElement);
                }
                catch (DOMException de) {
                    Object[] tokens = new Object[]{de.toString()};
                    throw new PortletDeployerException("errorCreateUIMapElement", tokens);
                }
            }
            boolean hasUserAttrDescriptions = false;
            List userAttrDescriptors = this.pad.getUserAttributeDescriptors();
            if (userAttrDescriptors.size() > 0) {
                System.out.println("user attributes existed");
                try {
                    Element userAttrDescElement = d.createElement("Collection");
                    userAttrDescElement.setAttribute(NAME_STRING, UI_DESCRIPTIONS_NAME);
                    userAttrDescElement.setAttribute(ADVANCED_STRING, TRUE);
                    Iterator di = userAttrDescriptors.iterator();
                    while (di.hasNext()) {
                        UserAttributeDescriptor uad = (UserAttributeDescriptor)di.next();
                        Map userAttrDescMap = uad.getDescriptionMap();
                        System.out.println("userAttrDescMap=" + userAttrDescMap);
                        if (userAttrDescMap.size() <= 0) continue;
                        hasUserAttrDescriptions = true;
                        Element userAttrDescSubElement = d.createElement("Collection");
                        userAttrDescSubElement.setAttribute(NAME_STRING, uad.getName());
                        userAttrDescSubElement.setAttribute(ADVANCED_STRING, TRUE);
                        j = userAttrDescMap.keySet().iterator();
                        while (j.hasNext()) {
                            String lang = (String)j.next();
                            String desc = (String)userAttrDescMap.get(lang);
                            userAttrDescSubElement.appendChild(this.createPropertyElement("String", d, lang, desc, FALSE));
                        }
                        userAttrDescElement.appendChild(userAttrDescSubElement);
                    }
                    if (hasUserAttrDescriptions) {
                        propertiesElement.appendChild(userAttrDescElement);
                    }
                }
                catch (DOMException de) {
                    Object[] tokens = new Object[]{de.toString()};
                    throw new PortletDeployerException("errorCreateUIDescElement", tokens);
                }
            }
            if ((supportsDescriptors = pd.getSupportsDescriptors()) != null) {
                Element supportsElement = d.createElement("Collection");
                supportsElement.setAttribute(NAME_STRING, SUPPORTS_MAP_NAME);
                supportsElement.setAttribute(ADVANCED_STRING, TRUE);
                j2 = supportsDescriptors.iterator();
                while (j2.hasNext()) {
                    SupportsDescriptor sd = (SupportsDescriptor)j2.next();
                    String mimeType = sd.getMimeType();
                    List portletModes = sd.getPortletModes();
                    Element mimeTypeElement = d.createElement("Collection");
                    mimeTypeElement.setAttribute(NAME_STRING, mimeType);
                    Iterator k = portletModes.iterator();
                    while (k.hasNext()) {
                        mode = (String)k.next();
                        Element modeElement = this.createPropertyElement("String", d, null, mode, FALSE);
                        mimeTypeElement.appendChild(modeElement);
                    }
                    supportsElement.appendChild(mimeTypeElement);
                }
                propertiesElement.appendChild(supportsElement);
            }
            if ((displayNameMap = pd.getDisplayNameMap()) != null) {
                Element dnMapElement = d.createElement("Collection");
                dnMapElement.setAttribute(NAME_STRING, DISPLAY_NAME_MAP_NAME);
                dnMapElement.setAttribute(ADVANCED_STRING, TRUE);
                Iterator j8 = displayNameMap.keySet().iterator();
                while (j8.hasNext()) {
                    String lang = (String)j8.next();
                    String dn = (String)displayNameMap.get(lang);
                    Element dnElement = this.createPropertyElement("String", d, lang, dn, FALSE);
                    dnMapElement.appendChild(dnElement);
                }
                propertiesElement.appendChild(dnMapElement);
            }
            if ((descriptionMap = pd.getDescriptionMap()) != null) {
                Element descMapElement = d.createElement("Collection");
                descMapElement.setAttribute(NAME_STRING, DESCRIPTION_MAP_NAME);
                descMapElement.setAttribute(ADVANCED_STRING, TRUE);
                Iterator j9 = descriptionMap.keySet().iterator();
                while (j9.hasNext()) {
                    String lang = (String)j9.next();
                    String desc = (String)descriptionMap.get(lang);
                    Element descElement = this.createPropertyElement("String", d, lang, desc, FALSE);
                    descMapElement.appendChild(descElement);
                }
                propertiesElement.appendChild(descMapElement);
            }
            if ((supportedLocales = pd.getSupportedLocales()) != null) {
                Element supportedLocalesElement = d.createElement("Collection");
                supportedLocalesElement.setAttribute(NAME_STRING, SUPPORTED_LOCALES_MAP_NAME);
                supportedLocalesElement.setAttribute(ADVANCED_STRING, TRUE);
                j = supportedLocales.iterator();
                while (j.hasNext()) {
                    String supportedLocale = (String)j.next();
                    Element supportedLocaleElement = this.createPropertyElement("String", d, null, supportedLocale, FALSE);
                    supportedLocalesElement.appendChild(supportedLocaleElement);
                }
                propertiesElement.appendChild(supportedLocalesElement);
            }
            if ((scd = this.pad.getSecurityConstraintDescriptor()) != null && (constrainedPortlets = scd.getConstrainedPortlets()) != null && constrainedPortlets.contains(portletName) && (tgType = scd.getTransportGuaranteeType()) != null && tgType.length() > 0) {
                Element tgElement = this.createPropertyElement("String", d, TRANSPORT_GUARANTEE_NAME, tgType, FALSE);
                propertiesElement.appendChild(tgElement);
            }
            Element providerElement = null;
            try {
                providerElement = d.createElement("Provider");
            }
            catch (DOMException de) {
                Object[] tokens = new Object[]{de.toString()};
                throw new PortletDeployerException("errorCreateProviderElement", tokens);
            }
            providerElement.setAttribute(NAME_STRING, providerName);
            providerElement.setAttribute(CLASS_STRING, PortletWindowClassName);
            providerElement.appendChild(propertiesElement);
            providerElements.add(providerElement);
        }
        return providerElements;
    }

    public List getProviderNames() {
        ArrayList<String> providerNames = new ArrayList<String>();
        List portletNames = this.psd.getPortletNames();
        for (int i = 0; i < portletNames.size(); ++i) {
            String portletName = (String)portletNames.get(i);
            String providerName = PORTLET_PREFIX + this.portletAppName + DOT_SEPARATOR + portletName;
            providerNames.add(providerName);
        }
        return providerNames;
    }

    private Element addDefaultProperties(Element propertiesElement, Document d) throws DOMException {
        Element property;
        int i;
        for (i = 0; i < defaultProperties.length; ++i) {
            property = this.createPropertyElement("String", d, defaultProperties[i][0], defaultProperties[i][1], FALSE);
            propertiesElement.appendChild(property);
        }
        for (i = 0; i < advancedProperties.length; ++i) {
            property = this.createPropertyElement("String", d, advancedProperties[i][0], advancedProperties[i][1], TRUE);
            propertiesElement.appendChild(property);
        }
        return propertiesElement;
    }

    private Element createPropertyElement(String tagname, Document d, String name, String value, String advanced) throws DOMException {
        Element property = d.createElement(tagname);
        if (name != null) {
            property.setAttribute(NAME_STRING, name);
        }
        property.setAttribute(VALUE_STRING, value);
        if (advanced.equals(TRUE)) {
            property.setAttribute(ADVANCED_STRING, advanced);
        }
        return property;
    }

    public Logger getLogger() {
        LoggerImpl logger = new LoggerImpl();
        logger.init("PortletSample", this.configProps);
        return logger;
    }
}

