/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rewriter.util.clip;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.comm.https.JSSInit;
import com.sun.portal.rewriter.RewriterModule;
import com.sun.portal.rewriter.util.Resource;
import com.sun.portal.rewriter.util.clip.CLIHandler;
import com.sun.portal.rewriter.util.clip.CLIPException;
import com.sun.portal.rewriter.util.clip.CLIPOption;
import com.sun.portal.rewriter.util.clip.CLIPParser;
import com.sun.portal.rewriter.util.clip.CLIPSpecHelper;
import com.sun.portal.rewriter.util.clip.CLIPSubCommand;
import com.sun.portal.rewriter.util.i18n.LocaleHelper;
import com.sun.portal.rewriter.util.xml.Document;
import com.sun.portal.rewriter.util.xml.Node;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CLIPSpec {
    private static LocaleHelper defaultLocaleHelper;
    private Class commandHandler;
    private String commandHandlerClassName;
    private String localeID;
    private CLIPParser clipParser;
    public static final String COMMANDNAME = "rwadmin";
    public static final String COMMANDVERSION = "1.1";

    public CLIPSpec(String aSpecFile) throws Exception {
        String lXMLString = Resource.read(aSpecFile);
        if (lXMLString.trim().length() == 0) {
            System.out.println("CLI Spec file: " + aSpecFile + " not found or permisstion denied (contanct vendor)");
            System.exit(0);
        }
        Node rootNode = Document.create(lXMLString).getRootNode();
        this.setMetaData(rootNode);
        CLIPOption[] commonOptions = CLIPSpecHelper.getCommonOptions(rootNode);
        Node[] subCommands = rootNode.selectNodes("\\\\CLIPToolSpec\\SUBCommand");
        CLIPSubCommand[] clipSubCommands = new CLIPSubCommand[subCommands.length];
        for (int i = 0; i < subCommands.length; ++i) {
            clipSubCommands[i] = CLIPSpecHelper.createSubCommand(subCommands[i], commonOptions);
        }
        this.clipParser = new CLIPParser(clipSubCommands, rootNode.getAttributeValue("help"));
    }

    private void setMetaData(Node aRootNode) throws Exception {
        this.commandHandlerClassName = aRootNode.getAttributeValue("commandHandler");
        this.commandHandler = Class.forName(this.commandHandlerClassName);
        this.localeID = aRootNode.getAttributeValue("localeID");
    }

    public CLIPParser getCLIPParser() {
        return this.clipParser;
    }

    public void doDefaultTasks(String[] args) throws CLIPException {
        String stdExitOption = CLIPParser.scanForStdExitOptions(args);
        if (stdExitOption != null && stdExitOption.equals("--version")) {
            CLIPSpec.printVersionInfo();
        }
        this.clipParser.verifyArguments(args);
        this.checkForHelp(args);
    }

    private static void printVersionInfo() {
        ResourceBundle prodRB = PropertyResourceBundle.getBundle("PSversion");
        StringBuffer vinfo = new StringBuffer();
        vinfo.append(COMMANDNAME).append(" (").append(prodRB.getString("productname")).append(" ").append(prodRB.getString("productversion")).append(") ").append(COMMANDVERSION);
        vinfo.append("\n").append(prodRB.getString("copyright"));
        System.err.println(vinfo.toString());
        System.exit(0);
    }

    private void checkForHelp(String[] args) {
        if (this.clipParser.needsHelp(args)) {
            System.out.println(this.clipParser.getHelp(args));
            System.exit(0);
        }
    }

    public Object executeCommand(String[] args) {
        try {
            CLIHandler cliHandler = (CLIHandler)this.commandHandler.newInstance();
            return cliHandler.executeCommand(this, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public String toString() {
        return "Tool Name: rwadmin\n" + this.clipParser.toString();
    }

    public static LocaleHelper getLocaleHelper() {
        return defaultLocaleHelper;
    }

    public static String[] getCLIArgs(String[] args) {
        String[] cliArgs = CLIPSpecHelper.removeFirstNArguments(args, 1);
        if (cliArgs.length == 0) {
            cliArgs = new String[]{"--help"};
        }
        return cliArgs;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Error:Script File should prepend two parms i.e CLI Spec File Location");
            System.exit(0);
        }
        JSSInit.initialize();
        RewriterModule.initIDSAME();
        SystemProperties.initializeProperties((String)"com.sun.identity.security.amadmin", (String)"true");
        String[] cliArgs = CLIPSpec.getCLIArgs(args);
        CLIPSpec spec = new CLIPSpec(args[0]);
        LocaleHelper.store(spec.localeID, CLIPSpecHelper.findLocale(cliArgs));
        defaultLocaleHelper = LocaleHelper.getLocaleHelper(spec.localeID);
        spec.doDefaultTasks(cliArgs);
        spec.executeCommand(cliArgs);
    }
}

