/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.portal.portlet;

import com.sun.identity.security.DecryptAction;
import com.sun.identity.security.EncryptAction;
import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public class IMPortlet
extends GenericPortlet {
    private PortletContext pContext;
    public static final String CONTENT_PAGE = "contentPage";
    public static final String EDIT_PAGE = "editPage";
    public static final String HELP_PAGE = "helpPage";
    public static final String SSOTOKEN = "ssotoken";
    public static final String SSOTOKEN_ATT = "javax.portlet.portletc.ssotoken";
    public static final String EDIT_FINISHED = "Finished";
    public static final String EDIT_CANCEL = "Cancel";
    public static final String EMPTY_STRING = "";
    public static final String CONTACT_GROUP = "contactGroup";
    public static final String CONTACT_GROUP_ALL = "__ALL__";
    public static final String SERVER = "server";
    public static final String PORT = "port";
    public static final String PORT_ERROR_PARAM = "portError";
    public static final String MUX = "mux";
    public static final String MUX_PORT = "muxport";
    public static final String MUX_PORT_ERROR_PARAM = "muxportError";
    public static final String CLIENT_RUN_MODE = "clientRunMode";
    public static final String PLUGIN_RUN_MODE = "plugin";
    public static final String JNLP_RUN_MODE = "jnlp";
    public static final String CRM_ERROR_PARAM = "crmError";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String GENERIC_ERROR_PARAM = "hasError";

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.pContext = config.getPortletContext();
    }

    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletSession ports = request.getPortletSession();
        PortletPreferences pref = request.getPreferences();
        ports.setAttribute(this.getChannelname(response), (Object)pref, 1);
        String userdn = request.getRemoteUser();
        String username = userdn.substring(userdn.indexOf(61) + 1, userdn.indexOf(44));
        ports.setAttribute(USERNAME, (Object)username, 1);
        ports.setAttribute(SSOTOKEN, request.getAttribute(SSOTOKEN_ATT), 1);
        String contentPage = pref.getValue(CONTENT_PAGE, EMPTY_STRING);
        String localizedContentPage = this.getLocalizedJSP(request.getLocale(), contentPage);
        response.setContentType(request.getResponseContentType());
        if (localizedContentPage != null && localizedContentPage.length() != 0) {
            PortletRequestDispatcher dispatcher = this.pContext.getRequestDispatcher(localizedContentPage);
            try {
                dispatcher.include(request, response);
            }
            catch (IOException e) {
                throw new PortletException("IMPortlet.doView IOException", (Throwable)e);
            }
            catch (Exception e) {
                throw new PortletException("IMPortlet.doView Exception.\tcontentPage=" + contentPage + " localCP=" + localizedContentPage + " disp=" + dispatcher, (Throwable)e);
            }
        }
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException {
        PortletPreferences pref = request.getPreferences();
        String editPage = pref.getValue(EDIT_PAGE, EMPTY_STRING);
        String localizedEditPage = this.getLocalizedJSP(request.getLocale(), editPage);
        response.setContentType(request.getResponseContentType());
        if (editPage != null && editPage.length() != 0) {
            try {
                PortletRequestDispatcher dispatcher = this.pContext.getRequestDispatcher(localizedEditPage);
                dispatcher.include(request, response);
            }
            catch (IOException e) {
                throw new PortletException("JSPPortlet.doEdit IOException", (Throwable)e);
            }
        }
    }

    public void doHelp(RenderRequest request, RenderResponse response) throws PortletException {
        PortletPreferences pref = request.getPreferences();
        String helpPage = pref.getValue(HELP_PAGE, EMPTY_STRING);
        String localizedHelpPage = this.getLocalizedJSP(request.getLocale(), helpPage);
        response.setContentType(request.getResponseContentType());
        if (helpPage != null && helpPage.length() != 0) {
            try {
                PortletRequestDispatcher dispatcher = this.pContext.getRequestDispatcher(localizedHelpPage);
                dispatcher.include(request, response);
            }
            catch (IOException e) {
                throw new PortletException("JSPPortlet.doEdit IOException", (Throwable)e);
            }
        }
    }

    public void processAction(ActionRequest request, ActionResponse actionResponse) throws PortletException, IOException {
        PortletPreferences pref = request.getPreferences();
        if (request.getParameter(EDIT_CANCEL) != null) {
            actionResponse.setPortletMode(PortletMode.VIEW);
        } else if (request.getParameter(EDIT_FINISHED) != null) {
            boolean hasError = false;
            String val = request.getParameter(CONTACT_GROUP);
            if (val != null && val.length() > 0) {
                if (val.equals(CONTACT_GROUP_ALL)) {
                    val = EMPTY_STRING;
                }
                if (!val.equals(pref.getValue(CONTACT_GROUP, EMPTY_STRING))) {
                    pref.setValue(CONTACT_GROUP, val);
                }
            }
            if ((val = request.getParameter(SERVER)) != null && val.length() > 0) {
                pref.setValue(SERVER, val);
            }
            if ((val = request.getParameter(PORT)) != null && val.length() > 0) {
                try {
                    int port = Integer.parseInt(val);
                    if (port == 0 || port > 65535) {
                        throw new NumberFormatException();
                    }
                    pref.setValue(PORT, val);
                }
                catch (NumberFormatException nfe) {
                    actionResponse.setRenderParameter(PORT_ERROR_PARAM, val);
                    hasError = true;
                }
            }
            if ((val = request.getParameter(MUX)) != null && val.length() > 0) {
                pref.setValue(MUX, val);
            }
            if ((val = request.getParameter(MUX_PORT)) != null && val.length() > 0) {
                try {
                    int muxport = Integer.parseInt(val);
                    if (muxport == 0 || muxport > 65535) {
                        throw new NumberFormatException();
                    }
                    pref.setValue(MUX_PORT, val);
                }
                catch (NumberFormatException nfe) {
                    actionResponse.setRenderParameter(MUX_PORT_ERROR_PARAM, val);
                    hasError = true;
                }
            }
            if ((val = request.getParameter(CLIENT_RUN_MODE)) != null && val.length() > 0) {
                if (val.equals(PLUGIN_RUN_MODE) || val.equals(JNLP_RUN_MODE)) {
                    pref.setValue(CLIENT_RUN_MODE, val);
                } else {
                    actionResponse.setRenderParameter(CRM_ERROR_PARAM, val);
                    hasError = true;
                }
            }
            if ((val = request.getParameter(USERNAME)) != null && val.length() > 0) {
                pref.setValue(USERNAME, val);
            }
            if ((val = request.getParameter(PASSWORD)) != null && val.length() > 0 && !val.equals(this.getDummyPassword(pref))) {
                val = (String)AccessController.doPrivileged(new EncryptAction(val));
                pref.setValue(PASSWORD, val);
            }
            pref.store();
            if (!hasError) {
                actionResponse.setPortletMode(PortletMode.VIEW);
            } else {
                actionResponse.setRenderParameter(GENERIC_ERROR_PARAM, EMPTY_STRING);
                actionResponse.setPortletMode(PortletMode.EDIT);
            }
        }
    }

    public String getDummyPassword(PortletPreferences pref) {
        StringBuffer dummy = new StringBuffer();
        int len = ((String)AccessController.doPrivileged(new DecryptAction(pref.getValue(PASSWORD, EMPTY_STRING)))).length();
        for (int i = 0; i < len; ++i) {
            dummy.append('*');
        }
        return dummy.toString();
    }

    protected String getLocalizedJSP(Locale locale, String jspPath) {
        String realJspPath = jspPath;
        if (locale != null) {
            String searchPath;
            int separator = jspPath.lastIndexOf(47);
            String jspBaseDir = separator > 0 ? jspPath.substring(0, separator) : "/";
            String jspFileName = jspPath.substring(separator + 1);
            PortletContext pContext = this.getPortletContext();
            if (pContext.getResourceAsStream(searchPath = this.getJSPPath(jspBaseDir, locale.toString(), jspFileName)) != null) {
                realJspPath = searchPath;
            } else if (locale.getCountry().length() > 0 && pContext.getResourceAsStream(searchPath = this.getJSPPath(jspBaseDir, locale.getLanguage(), jspFileName)) != null) {
                realJspPath = searchPath;
            }
        }
        return realJspPath;
    }

    private String getJSPPath(String jspBaseDir, String localeStr, String jspFileName) {
        StringBuffer sb = new StringBuffer();
        sb.append(jspBaseDir).append('_').append(localeStr).append('/').append(jspFileName);
        return sb.toString();
    }

    private String getChannelname(RenderResponse rRes) {
        String text = rRes.getNamespace();
        StringBuffer escaped = new StringBuffer();
        block3: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    escaped.append('_');
                    continue block3;
                }
                default: {
                    escaped.append(c);
                    continue block3;
                }
            }
        }
        return escaped.toString();
    }
}

