/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.portal.search.db.RDMDb;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.db.SearchOnlyDb;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.SearchConfig;
import com.sun.portal.search.util.Semaphore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DbAccess {
    static Map dbMap = new HashMap();
    static final int defaultDbConcurrent = 8;
    Semaphore dbsem;
    static DbAccess dbaccess;

    private DbAccess() {
        int n;
        int n2 = 8;
        String string = SearchConfig.getValue("database-max-concurrent");
        if (string != null && (n = Integer.parseInt(string)) > 0) {
            n2 = n;
        }
        this.dbsem = new Semaphore(n2);
    }

    static synchronized DbAccess getInstance() {
        if (dbaccess == null) {
            dbaccess = new DbAccess();
        }
        return dbaccess;
    }

    public synchronized void shutdown(SToken sToken) throws Exception {
        Iterator iterator = dbMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            RDMDb rDMDb = (RDMDb)entry.getValue();
            rDMDb.close(sToken);
        }
        dbMap.clear();
    }

    public RDMDb readStart(SToken sToken, String string) throws Exception {
        return this.writeStart(sToken, string);
    }

    public void readFinish(SToken sToken, RDMDb rDMDb) throws Exception {
        this.writeFinish(sToken, rDMDb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RDMDb writeStart(SToken sToken, String string) throws Exception {
        this.dbsem.acquire();
        RDMDb rDMDb = null;
        Map map = dbMap;
        synchronized (map) {
            rDMDb = (RDMDb)dbMap.get(string);
            if (rDMDb != null) {
                return rDMDb;
            }
            rDMDb = this.dbOpen(sToken, string, 4);
            dbMap.put(string, rDMDb);
        }
        return rDMDb;
    }

    public void writeFinish(SToken sToken, RDMDb rDMDb) throws Exception {
        this.dbsem.release();
    }

    protected RDMDb dbOpen(SToken sToken, String string, int n) throws Exception {
        RDMDb rDMDb;
        String string2 = SearchConfig.getValue("database-root");
        if (string2 == null) {
            CSLog.error(1, 1, "Missing database-root parameter");
            return null;
        }
        if (string.equalsIgnoreCase("taxonomy")) {
            rDMDb = new SearchOnlyDb();
        } else {
            String string3 = SearchConfig.getValue("database-class");
            if (string3 == null) {
                string3 = "com.sun.portal.search.db.IndexedSOIFDb";
            }
            rDMDb = (RDMDb)Class.forName(string3).newInstance();
        }
        rDMDb.open(sToken, string2, string, n, 420);
        return rDMDb;
    }
}

