/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp.connect;

import com.sun.portal.netlet.client.jnlp.connect.HTTPRequestStream;
import com.sun.portal.netlet.client.jnlp.connect.HTTPResponseStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class HTTPFields
implements Serializable,
Cloneable {
    private Vector fieldNames = new Vector();
    private Vector fieldValues = new Vector();
    private String firstLine;
    private HTTPFields requestHeader = null;
    private byte[] requestBody;
    private HTTPFields responseHeader = null;
    private byte[] responseBody;
    String host;
    private int port;
    private String path;
    private String file;
    private String scheme;
    private String protocol;
    private InetAddress clientAddress;
    private String httpVersion;
    private InetAddress remoteAddress;
    private String socketInfo;
    private String requestString;

    public HTTPFields getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(HTTPFields requestHeader) {
        this.requestHeader = requestHeader;
    }

    public byte[] getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(byte[] requestBody) {
        this.requestBody = requestBody;
    }

    public HTTPFields getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(HTTPFields responseHeader) {
        this.responseHeader = responseHeader;
    }

    public byte[] getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(byte[] responseBody) {
        this.responseBody = responseBody;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public InetAddress getClientAddress() {
        return this.clientAddress;
    }

    public void setClientAddress(InetAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(InetAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public String getRequestString() {
        return this.requestString;
    }

    public void setRequestString(String requestString) {
        this.requestString = requestString;
    }

    public void read(HTTPRequestStream in) throws IOException {
        this.firstLine = in.readLine();
        String line = in.readLine();
        String key = null;
        StringBuffer value = null;
        while (line != null && line.length() != 0) {
            if (line.startsWith(" ")) {
                if (value == null) {
                    throw new IOException("Found header field continuation before a header field!: \"" + line + "\"");
                }
                value.append(line);
            } else {
                int colon;
                if (key != null) {
                    this.addField(key, value.toString());
                }
                if ((colon = line.indexOf(":")) == -1) {
                    throw new IOException("Found a line in the headers that does not define a header!: \"" + line + "\"");
                }
                key = line.substring(0, colon);
                value = new StringBuffer();
                value.append(line.substring(colon + 2));
            }
            line = in.readLine();
        }
        if (key != null) {
            this.addField(key, value.toString());
        }
    }

    public void write(HTTPResponseStream out) throws IOException {
        if (this.firstLine != null) {
            out.write(this.firstLine);
            out.write("\r\n");
        }
        int n = this.fieldNames.size();
        for (int i = 0; i < n; ++i) {
            String key = (String)this.fieldNames.get(i);
            String value = (String)this.fieldValues.get(i);
            out.write(key);
            out.write(": ");
            out.write(value);
            out.write("\r\n");
        }
        out.write("\r\n");
        out.flush();
    }

    public Vector getFieldNames() {
        return this.fieldNames;
    }

    public String get(String fieldName) {
        return this.getField(fieldName);
    }

    public String getField(String fieldName) {
        int n = this.fieldNames.size();
        for (int i = 0; i < n; ++i) {
            String key = (String)this.fieldNames.get(i);
            if (!key.equalsIgnoreCase(fieldName)) continue;
            return (String)this.fieldValues.get(i);
        }
        return null;
    }

    public int getIntField(String fieldName) throws NumberFormatException {
        String value = this.getField(fieldName);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return 0;
    }

    public Vector getFieldValues(String fieldName) {
        int n = this.fieldNames.size();
        Vector ray = new Vector();
        for (int i = 0; i < n; ++i) {
            String key = (String)this.fieldNames.get(i);
            if (!key.equalsIgnoreCase(fieldName)) continue;
            ray.add(this.fieldValues.get(i));
        }
        if (ray.isEmpty()) {
            return null;
        }
        return ray;
    }

    public void addField(String key, String value) {
        this.fieldNames.add(key);
        this.fieldValues.add(value);
    }

    public void appendField(String key, String value) {
        String existingval = this.getField(key);
        existingval = existingval == null ? value : existingval + ";" + value;
        this.removeField(key);
        this.addField(key, existingval);
    }

    public void removeField(String fieldName) {
        int n = this.fieldNames.size();
        for (int i = 0; i < n; ++i) {
            String key = (String)this.fieldNames.get(i);
            if (!key.equalsIgnoreCase(fieldName)) continue;
            this.fieldNames.remove(i);
            this.fieldValues.remove(i);
            --i;
            --n;
        }
    }

    public void renameField(String fromFieldName, String toFieldName) {
        String val = this.get(fromFieldName);
        this.removeField(fromFieldName);
        this.addField(toFieldName, val);
        val = null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        HTTPResponseStream out = new HTTPResponseStream(bout);
        try {
            this.write(out);
            out.flush();
        }
        catch (IOException e) {
            return new String(bout.toByteArray());
        }
        return bout.toString();
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public void setFirstLine(String firstLine) {
        this.firstLine = firstLine;
    }

    public String getRedirectURL() {
        String value = null;
        int index = -1;
        System.out.println("firstLine " + this.firstLine);
        index = this.firstLine.indexOf("?");
        if (index != -1) {
            value = this.firstLine.substring(this.firstLine.indexOf("=", index + 1) + 1, this.firstLine.lastIndexOf(" "));
        }
        System.out.println("index " + index);
        System.out.println(" index 2 " + this.firstLine.indexOf(" "));
        System.out.println("value " + value);
        return value;
    }

    public int getStatus() {
        try {
            if (this.firstLine == null || !this.firstLine.startsWith("HTTP/")) {
                return -1;
            }
            StringTokenizer tok = new StringTokenizer(this.firstLine, " ");
            String httpVersion = tok.nextToken();
            int status = Integer.parseInt(tok.nextToken());
            return status;
        }
        catch (NoSuchElementException e) {
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public void setSocketInfo(String info) {
        this.socketInfo = info;
    }

    public String getSocketInfo() {
        return this.socketInfo;
    }

    public static void main(String[] args) {
        try {
            File f = new File("c:\\temp\\http_get_response.txt");
            FileInputStream in = new FileInputStream(f);
            HTTPRequestStream httpReqStrm = new HTTPRequestStream(in);
            HTTPFields hf = new HTTPFields();
            hf.read(httpReqStrm);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void parseRequest() throws IOException {
        String httpVersion;
        String requestString;
        String scheme;
        this.setRequestHeader(this);
        String firstLine = this.getFirstLine();
        StringTokenizer tok = new StringTokenizer(firstLine);
        try {
            scheme = tok.nextToken();
            requestString = tok.nextToken();
            if (requestString.startsWith("/")) {
                requestString = requestString.substring(1, requestString.length());
            }
            httpVersion = tok.nextToken();
        }
        catch (NoSuchElementException e) {
            throw new IOException("Invalid first proxy line \"" + firstLine + "\"");
        }
        this.setScheme(scheme);
        this.setHttpVersion(httpVersion);
        this.setRequestString(requestString);
        this.setFirstLine(scheme + " " + requestString + " " + httpVersion);
        if (!scheme.equals("CONNECT")) {
            URL url;
            try {
                url = new URL(requestString);
            }
            catch (MalformedURLException e) {
                throw new IOException("Malformed HTTP URL \"" + requestString + "\"");
            }
            String protocol = url.getProtocol();
            this.setHost(url.getHost());
            this.setPort(url.getPort());
            this.setPath(HTTPFields.extractPath(url.getFile()));
            this.setFile(url.getFile());
            this.setProtocol(protocol);
        } else {
            int i = requestString.lastIndexOf(58);
            if (i == -1) {
                throw new IOException("CONNECT request didn't include a port: " + firstLine);
            }
            String host = requestString.substring(0, i);
            int port = Integer.parseInt(requestString.substring(i + 1));
            this.setHost(host);
            this.setPort(port);
            this.setProtocol("https");
        }
    }

    private static String extractPath(String fileInfo) {
        return fileInfo.substring(0, fileInfo.indexOf(63) == -1 ? fileInfo.length() : fileInfo.indexOf("?"));
    }
}

