/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp;

import com.sun.portal.netlet.client.common.ClientConfig;
import com.sun.portal.netlet.client.common.ClientUtil;
import com.sun.portal.netlet.client.common.SClientMgr;
import com.sun.portal.netlet.client.jnlp.ClientManager;
import com.sun.portal.netlet.client.jnlp.JWSProxyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Properties;

public class NetletHandler {
    private boolean netletRunning = false;
    private boolean netletLoaded = false;
    Hashtable clientPorts;
    private SClientMgr scm = null;

    public NetletHandler(Hashtable params) {
        ClientConfig.addParams(params);
        try {
            Class.forName("javax.net.ssl.SSLContext");
            ClientConfig.addParam("isJSSEEnabled", "true");
        }
        catch (ClassNotFoundException e) {
            System.out.println("JSSE Not supported");
        }
        ClientConfig.addParam("codebaseURL", ClientManager.getCodeBaseUrl());
        String proxyletEnabledParameter = System.getProperty("com.sun.portal.proxylet.proxyletMode");
        if (proxyletEnabledParameter != null && proxyletEnabledParameter.equals("true")) {
            ClientConfig.addParam("proxyletMode", "true");
        }
    }

    public void setNetletLoaded() {
        if (!this.netletLoaded) {
            ClientConfig.init();
            this.loadProxyDetails();
            this.netletLoaded = true;
        }
    }

    private void loadProxyDetails() {
        JWSProxyInfo jwsPI = new JWSProxyInfo();
        ClientConfig.loadProxyDetails(jwsPI);
    }

    public void startClient() {
        boolean addNetletTab = false;
        if (!this.netletLoaded) {
            InputStream is = ClientUtil.netletConfig("loadNetletArgs");
            Properties props = new Properties();
            try {
                props.load(is);
            }
            catch (IOException e) {
                System.err.println("Unable to load netlet args");
            }
            Hashtable newParams = (Hashtable)((Object)props.values());
            ClientConfig.addParams(newParams);
            this.setNetletLoaded();
            addNetletTab = true;
        }
        if (this.netletRunning) {
            return;
        }
        if (this.scm == null) {
            this.scm = new SClientMgr(ClientConfig.getNumOfRules());
        }
        this.loadRules();
        if (this.scm != null) {
            this.scm.start();
            this.scm.waitToStart();
            this.netletRunning = true;
            System.out.println("netlet started");
            String clntPorts = this.scm.getFormattedClientPorts();
            String clntListenURL = ClientManager.getClientListener().getClientListenerURL();
            ClientUtil.sendByPost("setJWSLoaded&jwsListenURL=" + URLEncoder.encode(clntListenURL), "clientPorts=" + URLEncoder.encode(clntPorts));
        }
        if (ClientManager.getSRAContentPane() != null) {
            if (addNetletTab) {
                ClientManager.getSRAContentPane().refresh();
            } else {
                ClientManager.getSRAContentPane().refreshNetletTab();
            }
        }
    }

    private void loadRules() {
        int srcPort = 0;
        int nor = ClientConfig.getNumOfRules();
        for (int i = 0; i < nor; ++i) {
            try {
                srcPort = Integer.parseInt(ClientConfig.getParam("listenPort_" + i));
            }
            catch (NumberFormatException n) {
                System.out.println("Netlet unable to parse source port: " + i);
            }
            String ruleName = ClientConfig.getParam("ruleName_" + i);
            String serverHost = ClientConfig.getParam("serverHost_" + i);
            String serverPort = ClientConfig.getParam("serverPort_" + i);
            System.out.println("Netlet rule " + i + ": local:" + srcPort + "  destination:" + serverHost + ":" + serverPort);
            String threadname = "atprox_" + i + "_" + ClientConfig.getDestPort() + "_" + ClientConfig.getDestHost();
            String cipherName = ClientConfig.getParam("cipher_" + i);
            this.scm.addconfig(ruleName, srcPort, serverPort, serverHost, threadname, cipherName);
        }
    }

    public Hashtable getClientPorts() {
        return this.scm.getClientPorts();
    }

    public boolean netletClientRuning() {
        return this.netletRunning;
    }

    public boolean netletClientLoaded() {
        return this.netletLoaded;
    }

    public void stopClient(boolean sendMessage) {
        if (this.netletRunning) {
            this.scm.stopProcessing();
            if (this.scm != null) {
                this.scm.stop();
                this.scm = null;
            }
            if (sendMessage) {
                ClientUtil.netletConfig("stopped");
            }
            this.netletRunning = false;
        }
    }

    public void unloadNetlet() {
        this.stopClient(false);
        ClientUtil.netletConfig("unload");
        this.netletLoaded = false;
    }
}

