/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.jnlp;

import com.sun.portal.netlet.client.common.ClientUtil;
import com.sun.portal.netlet.client.common.NetletErrorDialog;
import com.sun.portal.netlet.client.common.ResourceProperties;
import com.sun.portal.netlet.client.jnlp.NetletHandler;
import com.sun.portal.netlet.client.jnlp.ProxyletHandler;
import com.sun.portal.netlet.client.jnlp.connect.ClientListener;
import com.sun.portal.netlet.client.jnlp.ui.SRAContentPane;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ClientManager
extends WindowAdapter
implements ActionListener {
    private static ClientManager clientManager = null;
    private static NetletHandler netletHandler = null;
    private static ProxyletHandler proxyletHandler = null;
    private static ClientListener cl = null;
    private static SRAContentPane sraContentPane = null;
    private static JFrame sraClientWindow = null;
    private static Hashtable parameters = new Hashtable();
    private NetletErrorDialog cbiped = null;
    private static BasicService bs;

    public static void main(String[] args) {
        if (clientManager == null) {
            clientManager = new ClientManager(args);
        }
    }

    private ClientManager(String[] args) {
        String startProxylet;
        this.initParams(args);
        if (netletHandler == null) {
            netletHandler = new NetletHandler(parameters);
        }
        if (proxyletHandler == null) {
            proxyletHandler = new ProxyletHandler(parameters);
        }
        this.initResources();
        this.cbiped = new NetletErrorDialog(new Frame(), this, ResourceProperties.getString("cbiped.1"), ResourceProperties.getString("cbiped.2"));
        String cbip = ClientManager.getParam("clientBindIP");
        if (!ClientUtil.isClientBindIPValid(cbip)) {
            this.cbiped.setErrorMessage(ResourceProperties.getString("cbiped.3") + " " + cbip + ". " + ResourceProperties.getString("cbiped.4"));
            this.cbiped.setVisible(true);
            this.cbiped.toFront();
            this.cbiped.waitForAction();
            System.exit(0);
        }
        this.initJnlpServices();
        this.startClientListener();
        String startNetlet = (String)parameters.get("startNetlet");
        if (startNetlet != null && startNetlet.equalsIgnoreCase("true")) {
            netletHandler.setNetletLoaded();
            netletHandler.startClient();
        }
        if ((startProxylet = (String)parameters.get("startProxylet")) == null || startProxylet.equalsIgnoreCase("true")) {
            // empty if block
        }
        this.showUI();
    }

    private void initParams(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            parameters.put(args[i], args[++i]);
        }
    }

    private void initResources() {
        String res = ClientManager.getParam("resourceBundle");
        if (res != null) {
            ResourceProperties.loadResources(res);
        } else {
            ResourceProperties.loadResources();
        }
    }

    private void startClientListener() {
        System.out.println("startClientListener");
        if (cl == null) {
            cl = new ClientListener(45000);
            cl.start();
        }
    }

    private void showUI() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JFrame.setDefaultLookAndFeelDecorated(true);
                sraClientWindow = new JFrame(ResourceProperties.getString("jws.sraFrame"));
                sraClientWindow.setSize(350, 350);
                sraClientWindow.setResizable(false);
                sraContentPane = new SRAContentPane();
                sraContentPane.setOpaque(true);
                sraClientWindow.getContentPane().add(sraContentPane);
                sraClientWindow.addWindowListener(clientManager);
                sraClientWindow.pack();
                sraClientWindow.setVisible(true);
            }
        });
    }

    private void initJnlpServices() {
        try {
            bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException e) {
            System.out.println("UnavailableServiceException " + (Object)((Object)e));
            bs = null;
        }
    }

    public static ClientManager getInstance() {
        return clientManager;
    }

    public static NetletHandler getNetletHandler() {
        return netletHandler;
    }

    public static ProxyletHandler getProxyletHandler() {
        return proxyletHandler;
    }

    public static ClientListener getClientListener() {
        return cl;
    }

    public static SRAContentPane getSRAContentPane() {
        return sraContentPane;
    }

    public static JFrame getSRAClientWindow() {
        return sraClientWindow;
    }

    public void windowClosing(WindowEvent e) {
        ClientManager.stopProcessing();
    }

    public static String getParam(String name) {
        return (String)parameters.get(name);
    }

    public static BasicService getBasicService() {
        return bs;
    }

    public static String getCodeBaseUrl() {
        String cbUrl = null;
        if (bs != null) {
            cbUrl = bs.getCodeBase().toString();
        }
        return cbUrl;
    }

    public static void stopProcessing() {
        if (cl != null) {
            cl.close();
        }
        if (netletHandler != null) {
            netletHandler.unloadNetlet();
        }
        System.exit(0);
    }

    public void actionPerformed(ActionEvent evt) {
        Object obj;
        if ("OK".equals(evt.getActionCommand()) && (obj = evt.getSource()) == this.cbiped.okButton) {
            this.cbiped.notifyAction();
            this.cbiped.setVisible(false);
        }
    }
}

