/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.sun.portal.netlet.client.common.SClient;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SClientMgr
implements Runnable {
    private SClient[] allproxies;
    private int numConfig = 0;
    private String[] ruleNames;
    private int[] srcPort;
    private String[] serverPort;
    private String[] serverHost;
    private String[] threadname;
    private int[] keyLength;
    private String[] cipherName;
    private int numProxies;
    private Thread t = null;
    private Hashtable clientPorts;
    private boolean started = false;

    public SClientMgr(int numProxies) {
        this.numProxies = numProxies;
        this.ruleNames = new String[numProxies];
        this.srcPort = new int[numProxies];
        this.serverPort = new String[numProxies];
        this.serverHost = new String[numProxies];
        this.threadname = new String[numProxies];
        this.allproxies = new SClient[numProxies];
        this.keyLength = new int[numProxies];
        this.cipherName = new String[numProxies];
        this.clientPorts = new Hashtable();
    }

    public void start() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        for (int i = 0; i < this.numConfig; ++i) {
            this.addproxy(this.ruleNames[i], this.srcPort[i], this.serverPort[i], this.serverHost[i], this.threadname[i], false, this.cipherName[i], this.keyLength[i]);
        }
        System.out.println("Local port configuration -> " + this.clientPorts.toString());
        SClientMgr sClientMgr = this;
        synchronized (sClientMgr) {
            this.started = true;
        }
        this.notifyStart();
    }

    public synchronized void waitToStart() {
        if (this.started) {
            return;
        }
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public synchronized void notifyStart() {
        this.notify();
    }

    public Hashtable getClientPorts() {
        return this.clientPorts;
    }

    public String getFormattedClientPorts() {
        StringBuffer clientPortSB = new StringBuffer();
        Enumeration enumeration = this.clientPorts.keys();
        int htSize = this.clientPorts.size();
        while (enumeration.hasMoreElements()) {
            String ruleName = (String)enumeration.nextElement();
            clientPortSB.append(ruleName).append("->");
            Vector v = (Vector)this.clientPorts.get(ruleName);
            int vSize = v.size();
            Enumeration ports = v.elements();
            while (ports.hasMoreElements()) {
                String port = (String)ports.nextElement();
                clientPortSB.append(port);
                if (--vSize <= 0) continue;
                clientPortSB.append(",");
            }
            if (--htSize <= 0) continue;
            clientPortSB.append("|");
        }
        return clientPortSB.toString();
    }

    public void stop() {
        if (this.t != null) {
            this.t.stop();
            this.t = null;
        }
    }

    public void addconfig(String ruleName, int srcp, String srvp, String srvh, String tname, String ciphername) {
        this.ruleNames[this.numConfig] = ruleName;
        this.srcPort[this.numConfig] = srcp;
        this.serverPort[this.numConfig] = new String(srvp);
        this.serverHost[this.numConfig] = new String(srvh);
        this.threadname[this.numConfig] = new String(tname);
        this.cipherName[this.numConfig] = new String(ciphername);
        ++this.numConfig;
    }

    public void addproxy(String ruleName, int srcp, String srvp, String srvh, String tname, boolean trans, String ciphername, int keylength) {
        boolean foundthread = false;
        int firstthread = -1;
        for (int i = 0; i < this.numProxies; ++i) {
            if (this.allproxies[i] != null && !this.allproxies[i].stopped) {
                if (!this.allproxies[i].getName().equals(tname)) continue;
                foundthread = true;
                continue;
            }
            if (firstthread != -1) continue;
            firstthread = i;
        }
        if (!foundthread && firstthread != -1) {
            SClient sc;
            this.allproxies[firstthread] = sc = new SClient(srcp, srvp, srvh, tname, this, trans, ciphername, keylength);
            this.allproxies[firstthread].start();
            Object obj = this.clientPorts.get(this.ruleNames[firstthread]);
            Vector<String> v = null;
            v = obj != null ? (Vector<String>)obj : new Vector<String>();
            v.addElement(this.allproxies[firstthread].getSrcPortInRule() + ":" + this.allproxies[firstthread].getSrcPort());
            this.clientPorts.put(this.ruleNames[firstthread], v);
        } else if (firstthread == -1) {
            System.out.println("Netlet: SCM Required number of proxies already started");
        }
    }

    public void stopProcessing() {
        for (int i = 0; i < this.numConfig; ++i) {
            if (this.allproxies[i] == null) continue;
            this.allproxies[i].stop();
            this.allproxies[i] = null;
        }
    }
}

