/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netlet.client.common;

import com.sun.portal.netlet.client.common.ClientConfig;
import com.sun.portal.netlet.client.common.NetletErrorDialog;
import com.sun.portal.netlet.client.common.ProxyAuthFailedException;
import com.sun.portal.netlet.client.common.ProxyAuthNeededException;
import com.sun.portal.netlet.client.common.ProxySConn;
import com.sun.portal.netlet.client.common.ReaderWriterDecryptExchange;
import com.sun.portal.netlet.client.common.ReaderWriterDecryptFtp;
import com.sun.portal.netlet.client.common.ReaderWriterEncryptFtp;
import com.sun.portal.netlet.client.common.ResourceProperties;
import com.sun.portal.netlet.client.common.SClient;
import com.sun.portal.netlet.client.common.SClientMgr;
import com.sun.portal.netlet.econnection.ESessionMsg;
import com.sun.portal.netlet.econnection.KeyConstants;
import com.sun.portal.netlet.econnection.ProxyCipherMsg;
import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterDecrypt;
import com.sun.portal.netlet.econnection.ReaderWriterEncrypt;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.netlet.econnection.SessionCipherMsg;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class RWGroupCrypt
extends ReaderWriterLock
implements KeyConstants,
ActionListener {
    volatile boolean done = false;
    private int srcPort;
    private String serverPort;
    private String serverHost;
    private Socket in_s;
    private Socket out_s;
    private String cipherName;
    private ReaderWriterEncrypt src_to_dst;
    private ReaderWriterDecrypt dst_to_src;
    private ProxySConn sconn;
    private Thread s2dThread;
    private Thread d2sThread;
    private SClient sc;
    public String newFtpAddrPort;
    private NetletErrorDialog ned;

    RWGroupCrypt(Socket in, int connectionType, int sport, int srvport, String srvhost, SClientMgr scm, SClient sclient, String ciphername, int keylength) {
        this(in, connectionType, sport, new String("" + srvport), srvhost, scm, sclient, ciphername, keylength);
    }

    RWGroupCrypt(Socket in, int connectionType, int sport, String srvport, String srvhost, SClientMgr scm, SClient sclient, String ciphername, int keylength) {
        this.in_s = in;
        this.srcPort = sport;
        this.serverPort = srvport;
        this.serverHost = srvhost;
        this.sc = sclient;
        this.cipherName = ciphername;
        this.ned = new NetletErrorDialog(new Frame(), this, null, null);
        System.out.println("============================");
        System.out.println("RWGroupCrypt sport " + sport);
        System.out.println("RWGroupCrypt srvport " + srvport);
        System.out.println("RWGroupCrypt srvhost " + srvhost);
        System.out.println("RWGroupCrypt ciphername " + ciphername);
        System.out.println("============================");
        if (ClientConfig.isProxyMode()) {
            String fail = null;
            try {
                this.sconn = new ProxySConn(ClientConfig.getProxyPort(), ClientConfig.getProxyHost(), ClientConfig.getDestPort(), ClientConfig.getDestHost(), ciphername);
            }
            catch (ProxyAuthNeededException e) {
                try {
                    this.sconn = new ProxySConn(ClientConfig.getProxyPort(), ClientConfig.getProxyHost(), ClientConfig.getDestPort(), ClientConfig.getDestHost(), true, ciphername);
                }
                catch (ProxyAuthNeededException ee) {
                    fail = ee.getMessage();
                }
                catch (ProxyAuthFailedException ee) {
                    fail = ee.getMessage();
                }
            }
            catch (ProxyAuthFailedException e) {
                fail = e.getMessage();
            }
            if (fail != null) {
                System.out.println("Netlet unable to authenticate to proxy server: " + fail);
                this.ned.setErrorMessage(ResourceProperties.getString("rwgroup.1") + " " + ClientConfig.getProxyHost() + ":" + ClientConfig.getProxyPort());
                this.ned.setVisible(true);
                this.notifyparent();
                return;
            }
        } else {
            this.sconn = new ProxySConn(ClientConfig.getDestPort(), ClientConfig.getDestHost(), ciphername);
        }
        this.out_s = this.sconn.getconn();
        InputStream fromServer = null;
        OutputStream toServer = null;
        try {
            fromServer = this.out_s.getInputStream();
            toServer = this.out_s.getOutputStream();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.earlyExit();
            return;
        }
        if (this.out_s == null) {
            if (ClientConfig.isProxyMode()) {
                System.out.println("Netlet (RWGC-a) unable to make connection to proxy: " + ClientConfig.getProxyHost());
                this.ned.setErrorMessage(ResourceProperties.getString("rwgroup.1") + " " + ClientConfig.getProxyHost() + ":" + ClientConfig.getProxyPort());
            } else {
                System.out.println("Netlet (RWGC-a) unable to make connection to gateway: " + ClientConfig.getDestHost());
                this.ned.setErrorMessage(ResourceProperties.getString("rwgroup.2") + " " + ClientConfig.getDestHost() + ":" + ClientConfig.getDestPort());
            }
            this.ned.setVisible(true);
            this.notifyparent();
            return;
        }
        ESessionMsg eMsg = new ESessionMsg("RP1.0".getBytes());
        if (eMsg.writeMsg(new DataOutputStream(toServer)) != 0) {
            this.earlyExit();
            return;
        }
        if (this.encryptSessionId(ClientConfig.getSessionID().getBytes(), ClientConfig.getSessionID().getBytes().length, new DataOutputStream(toServer)) != 0) {
            this.earlyExit();
            return;
        }
        ProxyCipherMsg pMsg = new ProxyCipherMsg(this.srcPort, this.serverPort.getBytes(), this.serverPort.getBytes().length, this.serverHost.getBytes(), this.serverHost.getBytes().length);
        if (pMsg.writeMsg(new DataOutputStream(toServer)) != 0) {
            this.earlyExit();
            return;
        }
        pMsg = null;
        if (srvport.equals("-1")) {
            try {
                DataInputStream dis = new DataInputStream(fromServer);
                this.newFtpAddrPort = dis.readInt() + "," + dis.readInt() + "," + dis.readInt() + "," + dis.readInt() + "," + dis.readInt() + "," + dis.readInt();
                System.out.println("newFtpAddrPort " + this.newFtpAddrPort);
            }
            catch (Exception ex) {
                this.earlyExit();
                return;
            }
        }
        InputStream fromClient = null;
        OutputStream toClient = null;
        try {
            fromClient = this.in_s.getInputStream();
            toClient = this.in_s.getOutputStream();
        }
        catch (IOException ex) {
            System.out.println("Unable to get the input/output stream from the client");
            ex.printStackTrace();
        }
        this.src_to_dst = connectionType == 1 ? new ReaderWriterEncryptFtp(this, fromClient, toServer, 0, scm) : new ReaderWriterEncrypt(this, fromClient, toServer, 0);
        this.dst_to_src = connectionType == 2 ? new ReaderWriterDecryptExchange(this, fromServer, toClient, srvhost, scm) : (connectionType == 1 ? new ReaderWriterDecryptFtp(this, fromServer, toClient, scm) : new ReaderWriterDecrypt(this, fromServer, toClient));
        this.s2dThread = new Thread(this.src_to_dst);
        this.s2dThread.start();
        this.d2sThread = new Thread(this.dst_to_src);
        this.d2sThread.start();
    }

    public void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            this.s2dThread = null;
            Thread d2sTemp = this.d2sThread;
            if (d2sTemp != null) {
                try {
                    this.dst_to_src.stop();
                    d2sTemp.stop();
                    d2sTemp.join();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            this.d2sThread = null;
        } else if (obj == this.dst_to_src) {
            this.d2sThread = null;
            Thread s2dTemp = this.s2dThread;
            if (s2dTemp != null) {
                try {
                    this.src_to_dst.stop();
                    s2dTemp.stop();
                    s2dTemp.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.s2dThread = null;
        }
        this.cleanup();
    }

    public synchronized void stopAll() {
        if (!this.done) {
            if (this.dst_to_src != null) {
                this.dst_to_src.netletstop();
            }
            if (this.src_to_dst != null) {
                this.src_to_dst.netletstop();
            }
            this.cleanup();
        }
    }

    void earlyExit() {
        this.notifyparent();
    }

    void cleanup() {
        if (this.in_s != null) {
            try {
                this.in_s.close();
                this.in_s = null;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.out_s != null) {
            try {
                this.out_s.close();
                this.out_s = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.src_to_dst = null;
        this.dst_to_src = null;
        this.sconn = null;
        if (this.sc != null && this.sc.isTrans()) {
            this.sc.stopped = true;
        }
        this.notifyparent();
    }

    void notifyparent() {
        this.done = true;
    }

    private int encryptSessionId(byte[] id, int id_len, DataOutputStream out) {
        SessionCipherMsg sMsg;
        int rc = 0;
        if (this.cipherName == null) {
            this.cipherName = "SSL_RSA_WITH_RC4_128_MD5";
        }
        if ((sMsg = new SessionCipherMsg(id = (new String(id) + "|" + this.cipherName).getBytes(), id_len += this.cipherName.length() + 1)).writeMsg(out) != 0) {
            System.out.println("Netlet (RWGC-a) unable to process session id");
            rc = -1;
        }
        return rc;
    }

    public long getLastActivityTime() {
        return 0L;
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return 0L;
    }

    public void actionPerformed(ActionEvent evt) {
        Object obj;
        if ("OK".equals(evt.getActionCommand()) && (obj = evt.getSource()) == this.ned.okButton) {
            this.ned.setVisible(false);
        }
    }
}

