/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.providers.simplewebservice.rpc;

import com.sun.portal.providers.simplewebservice.WebServiceDescriptor;
import com.sun.portal.providers.simplewebservice.rpc.RPCCallHandler;
import com.sun.portal.providers.simplewebservice.rpc.SWSCallFactory;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public class RPCCallFactoryImpl
implements SWSCallFactory {
    private static RPCCallFactoryImpl ourInstance;
    private static final String ENCODING_STYLE_URI_PROPERTY = "javax.xml.rpc.encodingstyle.namespace.uri";
    private static final int COMPLEX_TYPE_SERIALIZER = 1;
    private static final int COMPLEX_ARRAY_TYPE_SERIALIZER = 2;

    public static synchronized RPCCallFactoryImpl getInstance() {
        if (ourInstance == null) {
            ourInstance = new RPCCallFactoryImpl();
        }
        return ourInstance;
    }

    private RPCCallFactoryImpl() {
    }

    public Call createCallObject(Service service, WebServiceDescriptor webServiceDescriptor) throws ServiceException {
        RPCCallHandler rPCCallHandler = new RPCCallHandler();
        Call call = rPCCallHandler.createCall(service, webServiceDescriptor);
        this.setCallProperties(call, webServiceDescriptor);
        return call;
    }

    private void setCallProperties(Call call, WebServiceDescriptor webServiceDescriptor) throws JAXRPCException {
        call.setTargetEndpointAddress(webServiceDescriptor.getEndPointURL());
        String string = webServiceDescriptor.getSOAPBindingStyle();
        if (string == null) {
            string = "rpc";
        }
        call.setProperty("javax.xml.rpc.soap.operation.style", (Object)string);
        String string2 = webServiceDescriptor.getSOAPAction();
        if (string2 == null) {
            string2 = "";
        }
        call.setProperty("javax.xml.rpc.soap.http.soapaction.use", (Object)new Boolean(true));
        call.setProperty("javax.xml.rpc.soap.http.soapaction.uri", (Object)string2);
        String string3 = webServiceDescriptor.getInputEncodingStyleURI();
        if (string3 != null) {
            call.setProperty(ENCODING_STYLE_URI_PROPERTY, (Object)webServiceDescriptor.getInputEncodingStyleURI());
        }
    }
}

