/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.netmail.security;

import com.sun.portal.netmail.security.SecurityCall;
import java.io.FileNotFoundException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class AppletSecurityCalls {
    public static final int FILE = 0;
    public static final int ACCEPT = 1;
    public static final int CONNECT = 2;
    public static final int SYSTEM = 3;
    public static final int NETSCAPE = 0;
    public static final int MICROSOFT = 1;
    public static final int OTHER = 3;
    static /* synthetic */ Class class$java$lang$String;

    public static SecurityCall askPermission(int n) throws Exception {
        if (System.getProperty("os.name").toUpperCase().startsWith("MAC")) {
            return new SecurityCall(3);
        }
        char c = System.getProperty("java.version").charAt(0);
        if (c > '1') {
            return new SecurityCall(3);
        }
        c = System.getProperty("java.version").charAt(2);
        if (c > '2') {
            return new SecurityCall(3);
        }
        try {
            Method method = null;
            switch (AppletSecurityCalls.getVendor()) {
                case 0: {
                    Class<?> clazz = Class.forName("netscape.security.PrivilegeManager");
                    method = clazz.getMethod("enablePrivilege", class$java$lang$String == null ? (class$java$lang$String = AppletSecurityCalls.class$("java.lang.String")) : class$java$lang$String);
                    String string = null;
                    switch (n) {
                        case 0: {
                            string = "UniversalFileAccess";
                            break;
                        }
                        case 1: {
                            string = "UniversalAccept";
                            break;
                        }
                        default: {
                            string = "UniversalConnect";
                        }
                    }
                    return new SecurityCall(0, method, new String[]{string});
                }
                case 1: {
                    Class<?> clazz = Class.forName("com.ms.security.PolicyEngine");
                    Class<?> clazz2 = Class.forName("com.ms.security.PermissionID");
                    Field field = null;
                    switch (n) {
                        case 0: {
                            field = clazz2.getField("FILEIO");
                            break;
                        }
                        default: {
                            field = clazz2.getField("NETIO");
                        }
                    }
                    Object object = field.get(null);
                    method = clazz.getMethod("assertPermission", clazz2);
                    return new SecurityCall(1, method, new Object[]{object});
                }
            }
            return new SecurityCall();
        }
        catch (Exception exception) {
            if (!(exception instanceof ClassNotFoundException) && !(exception instanceof FileNotFoundException)) {
                throw exception;
            }
            return new SecurityCall();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new SecurityCall();
        }
    }

    public static int getVendor() {
        if (System.getProperty("java.vendor").toUpperCase().startsWith("NETSCAPE")) {
            return 0;
        }
        if (System.getProperty("java.vendor").toUpperCase().startsWith("MICROSOFT")) {
            return 1;
        }
        return 3;
    }

    public static boolean isForbiddenTargetException(Exception exception) {
        try {
            Class<?> clazz = Class.forName("netscape.security.ForbiddenTargetException");
            return clazz.isInstance(exception);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

