/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.cal;

import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.RecurrencePattern;
import com.sun.portal.wireless.taglibs.base.BeanTag;
import com.sun.portal.wireless.taglibs.base.Util;
import com.sun.portal.wireless.taglibs.cal.CalContext;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class RecurrenceTag
extends BeanTag {
    private Object frequency = new Integer(50);
    private int interval = 1;
    private String repeatOn = "";
    private Object repeatUntil = new Integer(-1);

    public Object findBean() throws Exception {
        if (this.name != null) {
            return this.pageContext.getAttribute(this.name);
        }
        Object result = this.newBean();
        if (this.id != null) {
            this.pageContext.setAttribute(this.id, result);
        }
        return result;
    }

    public Object newBean() throws Exception {
        RecurrencePattern result = null;
        if (this.repeatUntil instanceof Integer) {
            if (this.frequency instanceof Integer) {
                result = new RecurrencePattern(((Integer)this.frequency).intValue(), this.interval, ((Integer)this.repeatUntil).intValue());
            } else if (this.frequency instanceof String) {
                result = new RecurrencePattern((String)this.frequency, this.interval, ((Integer)this.repeatUntil).intValue());
            }
        } else if (this.repeatUntil instanceof DateTime && this.frequency instanceof Integer) {
            result = new RecurrencePattern(((Integer)this.frequency).intValue(), this.interval, (DateTime)this.repeatUntil);
        }
        if (result == null) {
            throw new Exception("Not able to create a RecurrencePattern");
        }
        RecurrenceTag.setRecRepeatOn(result, this.frequency, this.repeatOn);
        return result;
    }

    public void setFrequency(String freq) throws Exception {
        try {
            this.frequency = RecurrenceTag.getRecFrequency(freq);
        }
        catch (Exception ex) {
            Util.logError((String)"Error", (Throwable)ex);
            throw ex;
        }
    }

    public void setInterval(String theInterval) throws Exception {
        try {
            if (theInterval != null) {
                this.interval = Integer.parseInt(theInterval);
            }
        }
        catch (Exception ex) {
            Util.logWarning((String)("Non Numeric repeatInterval " + this.interval + " . please specify Numeric repeat interval " + ex.getMessage()));
        }
    }

    public void setRepeatOn(String repeatOn) throws Exception {
        if (repeatOn != null) {
            this.repeatOn = repeatOn;
        }
    }

    public void setRepeatUntil(String until) throws Exception {
        if (until != null) {
            CalContext context = CalContext.getContext(this.pageContext);
            TimeZone tz = context.getTimeZone();
            this.repeatUntil = RecurrenceTag.getRecRepeatUntil(until, tz);
        }
    }

    private static Object getRecRepeatUntil(String until, TimeZone tz) throws Exception {
        Integer result = null;
        if (until.length() >= 6) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MMddyyyy");
                dateFormat.setTimeZone(tz);
                Date date = dateFormat.parse(until);
                DateTime tempResult = new DateTime(tz);
                tempResult.setTime(date);
                tempResult.set(10, 23);
                tempResult.set(12, 59);
                tempResult.set(13, 59);
                result = tempResult;
            }
            catch (NumberFormatException ex) {
                throw new Exception("Unable to parse " + until);
            }
        }
        try {
            result = new Integer(until);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Not able to parse " + until);
        }
        return result;
    }

    private static Object getRecFrequency(String param) throws Exception {
        Integer result;
        block6: {
            result = null;
            try {
                result = new Integer(param);
            }
            catch (NumberFormatException ex) {
                if (param.equals("DAILY")) {
                    result = new Integer(40);
                }
                if (param.equals("WEEKLY")) {
                    result = new Integer(50);
                }
                if (param.equals("MONTHLY")) {
                    result = new Integer(60);
                }
                if (!param.equals("YEARLY")) break block6;
                result = new Integer(70);
            }
        }
        if (result == null) {
            throw new Exception("Incorrect frequency=" + param);
        }
        return result;
    }

    private static void setRecRepeatOn(RecurrencePattern recPat, Object freq, String repOn) throws Exception {
        if (repOn == null || repOn.trim().equals("")) {
            return;
        }
        repOn = repOn.replace(';', ',');
        if (freq == null) {
            throw new Exception("frequency is Null in setRepeatOn");
        }
        String freqSt = freq.toString();
        if (freqSt.equals("DAILY") || freqSt.equals(String.valueOf(40)) || freqSt.equals("WEEKLY") || freqSt.equals(String.valueOf(50))) {
            if (!repOn.trim().equals("0")) {
                recPat.setByDay(repOn);
            }
        } else if (freqSt.equals("MONTHLY") || freqSt.equals(String.valueOf(60))) {
            recPat.setByMonthDay(repOn);
        } else if (freqSt.equals("YEARLY") || freqSt.equals(String.valueOf(70))) {
            if (repOn.length() >= 2 && repOn.length() <= 4) {
                try {
                    String dd = repOn.substring(repOn.length() - 2);
                    String mm = repOn.substring(0, repOn.length() - 2);
                    Integer.parseInt(dd);
                    Integer.parseInt(mm);
                    recPat.setByMonthDay(dd);
                    recPat.setByMonth(mm);
                }
                catch (Exception ex) {
                    throw new Exception(" Date format error of mmdd " + repOn);
                }
            } else {
                throw new Exception(" Date format size error of mmdd " + repOn);
            }
        }
    }
}

