/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdmserver;

import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.rdm.RDMRequest;
import com.sun.portal.search.rdm.RDMResponse;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.rdm.RDMView;
import com.sun.portal.search.rdmserver.RDMService;
import com.sun.portal.search.rdmserver.RDMServiceDescriptor;
import com.sun.portal.search.soif.AVPair;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.CSLog;
import com.sun.portal.search.util.Encoder;
import com.sun.portal.search.util.SearchConfig;

public class SchemaService
extends RDMService {
    RDMSchema schema;

    public SchemaService() {
        this.supportedServices.add(new RDMServiceDescriptor("schema-description-request", null));
        this.supportedServices.add(new RDMServiceDescriptor("schema-description-request", "schema-basic"));
    }

    public void service(RDMRequest rDMRequest, RDMResponse rDMResponse) throws Exception {
        this.normalizeRequest(rDMRequest);
        rDMResponse.getHeader().setType("schema-description-response");
        String string = rDMRequest.getQuery().getScope();
        QLSchemaQuery qLSchemaQuery = new QLSchemaQuery();
        if (string == null || string.length() == 0 || !this.scopeParse(string, qLSchemaQuery)) {
            CSLog.warn(1, 20, "Got invalid scope: '" + string + "'");
            rDMResponse.getHeader().setErrorMessage("Invalid Scope");
            return;
        }
        this.getResults(rDMRequest, rDMResponse, qLSchemaQuery);
    }

    public void normalizeRequest(RDMRequest rDMRequest) {
        String string;
        RDMHeader rDMHeader = rDMRequest.getHeader();
        String string2 = rDMHeader.getType();
        String string3 = rDMHeader.getQueryLanguage();
        if (string3 == null || string3.length() == 0) {
            rDMHeader.setQueryLanguage("schema-basic");
        }
        if (rDMRequest.getQuery() == null) {
            rDMRequest.setQuery(new RDMQuery((String)null));
        }
        if ((string = rDMRequest.getQuery().getScope()) == null || string.length() == 0) {
            rDMRequest.getQuery().setScope("defined soif-attribute");
        }
    }

    protected boolean scopeParse(String string, QLSchemaQuery qLSchemaQuery) {
        qLSchemaQuery.attr = null;
        if (string.regionMatches(true, 0, "defined", 0, 7)) {
            int n;
            for (n = 7; n < string.length() && string.charAt(n) == ' '; ++n) {
            }
            if (n < string.length()) {
                qLSchemaQuery.attr = string.substring(7).trim().toLowerCase();
                return true;
            }
        }
        return false;
    }

    protected synchronized void loadSchema(String string) throws Exception {
        if (this.schema == null) {
            String string2 = SearchConfig.getValue("schema-description");
            if (string2 == null) {
                CSLog.error(1, 1, "Missing 'schema-description' parameter.");
                throw new Exception("Missing schema configuration");
            }
            SOIFInputStream sOIFInputStream = null;
            try {
                sOIFInputStream = new SOIFInputStream(string2);
            }
            catch (Exception exception) {
                CSLog.warn(1, 1, "Schema Unavailable: " + string2);
                throw new Exception("Schema Unavailable: " + string2);
            }
            try {
                this.schema = new RDMSchema(sOIFInputStream.readSOIF());
            }
            catch (Exception exception) {
                CSLog.warn(1, 1, "Schema invalid: " + string2);
                throw new Exception("Schema Unavailable: " + string2);
            }
        }
    }

    protected void getResults(RDMRequest rDMRequest, RDMResponse rDMResponse, QLSchemaQuery qLSchemaQuery) throws Exception {
        if (this.schema == null) {
            this.loadSchema(rDMRequest.getHeader().getCSID());
        }
        SOIFOutputStream sOIFOutputStream = rDMResponse.getOutputStream();
        rDMResponse.sendHeader();
        RDMView rDMView = new RDMView(rDMRequest);
        if (rDMView.attr != null) {
            sOIFOutputStream.setAllowed(rDMView.attr);
        }
        this.printDefined(this.schema, qLSchemaQuery, sOIFOutputStream);
        rDMRequest.logRDM("scope=\"" + Encoder.quotedEscape(rDMRequest.getQuery().getScope()) + "\"");
    }

    protected boolean printDefined(RDMSchema rDMSchema, QLSchemaQuery qLSchemaQuery, SOIFOutputStream sOIFOutputStream) throws Exception {
        AVPair aVPair;
        String string = qLSchemaQuery.attr;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        String string2 = rDMSchema.getNumEntries();
        if (string2 != null) {
            n2 = Integer.parseInt(string2);
        }
        if ((aVPair = rDMSchema.getSOIF().getAVPair("soif-attribute")) != null && n2 < aVPair.valueCount()) {
            n2 = aVPair.valueCount();
        }
        for (n = 0; n2 == 0 || n < n2; ++n) {
            if (rDMSchema.getSOIFAttribute(n) != null) continue;
            n2 = n + 1;
            break;
        }
        if (string.equalsIgnoreCase("soif-attribute")) {
            sOIFOutputStream.write(rDMSchema.getSOIF());
            return false;
        }
        aVPair = rDMSchema.getSOIF().getAVPair(string);
        if (aVPair == null) {
            return true;
        }
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!aVPair.nthValid(n)) {
                rDMSchema.deleteColumn(n);
                continue;
            }
            ++n3;
        }
        rDMSchema.setNumEntries("" + n3);
        sOIFOutputStream.write(rDMSchema.getSOIF());
        return false;
    }

    class QLSchemaQuery {
        String attr;

        QLSchemaQuery() {
        }
    }
}

