/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.rdm;

import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFException;
import com.sun.portal.search.soif.SOIFInputStream;

public class RDMServerDescription {
    SOIF soif;

    public RDMServerDescription(String string) {
        this.soif = new SOIF("RDMSERVER", string);
    }

    public RDMServerDescription(SOIFInputStream sOIFInputStream, String string) throws Exception {
        SOIF sOIF = sOIFInputStream.readSOIF();
        if (sOIF == null || !sOIF.getSchemaName().equalsIgnoreCase("RDMSERVER")) {
            throw new Exception("Invalid server description");
        }
        this.soif = new SOIF("RDMSERVER", string);
        this.soif.merge(sOIF);
    }

    public String getSupportedRDMType() {
        return this.soif.getValue("supported-rdm-type");
    }

    public String getSupportedRDMQL() {
        return this.soif.getValue("supported-rdm-query-language");
    }

    public String getSupportedCSID() {
        return this.soif.getValue("supported-catalog-service-id");
    }

    public String getLastModified() {
        return this.soif.getValue("sd-last-modified");
    }

    public String getExpires() {
        return this.soif.getValue("sd-expires");
    }

    public String getDescription() {
        return this.soif.getValue("description");
    }

    public String getMaintainer() {
        return this.soif.getValue("maintainer");
    }

    public SOIF getSOIF() {
        return this.soif;
    }

    public void setSupportedRDMType(String string) throws SOIFException {
        this.soif.replace("supported-rdm-type", string);
    }

    public void setSupportedRDMQL(String string) throws SOIFException {
        this.soif.replace("supported-rdm-query-language", string);
    }

    public void setSupportedCSID(String string) throws SOIFException {
        this.soif.replace("supported-catalog-service-id", string);
    }

    public void setLastModified(String string) throws SOIFException {
        this.soif.replace("sd-last-modified", string);
    }

    public void setExpires(String string) throws SOIFException {
        this.soif.replace("sd-expires", string);
    }

    public void setDescription(String string) throws SOIFException {
        this.soif.replace("description", string);
    }

    public void setMaintainer(String string) throws SOIFException {
        this.soif.replace("maintainer", string);
    }
}

