/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.taglibs.ab;

import com.sun.addressbook.Element;
import com.sun.addressbook.Entry;
import com.sun.addressbook.Group;
import com.sun.portal.wireless.taglibs.ab.ABContext;
import com.sun.portal.wireless.taglibs.ab.ContactDB;
import com.sun.portal.wireless.taglibs.base.CommandTag;
import javax.servlet.jsp.JspException;

public abstract class ABBaseCommandTag
extends CommandTag {
    protected ABContext abContext = null;
    protected String name = null;
    protected String entryid = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEntryid() {
        return this.entryid;
    }

    public void setEntryid(String entryid) {
        this.entryid = this.evalAttribute(entryid);
    }

    public ABContext getABContext() throws JspException {
        try {
            this.abContext = ABContext.getContext(this.pageContext);
        }
        catch (Exception e) {
            throw new JspException(e.getMessage());
        }
        if (this.abContext == null) {
            throw new JspException("ABBaseCommandTag.execute(): Address Book context not found");
        }
        return this.abContext;
    }

    public ContactDB getContactDB() throws JspException {
        ContactDB contactDB = this.getABContext().getContactDB();
        if (contactDB == null) {
            throw new JspException("ABBaseCommandTag.getContactDB(): ContactDB object not found");
        }
        return contactDB;
    }

    public void verifyEntryid() throws JspException {
        if (this.entryid == null) {
            throw new JspException("ABCommangTag.verifyEntryid(): 'entryid' attribute not specified");
        }
    }

    public boolean requiredPropertiesExist(Element e) throws JspException {
        if (e.isEntry()) {
            Entry entry = (Entry)e;
            if (entry.getLn() != null && !entry.getLn().equals("")) {
                return true;
            }
            this.getABContext().setErrorCode("AB_001");
            ABContext.log("ABCommangTag.verifyLn(): Property 'ln' empty while adding contact");
        } else if (e.isGroup()) {
            Group group = (Group)e;
            if (group.getCn() != null && !group.getCn().equals("")) {
                return true;
            }
            this.getABContext().setErrorCode("AB_002");
            ABContext.log("ABCommangTag.verifyLn(): Property 'cn' empty while adding group");
        }
        return false;
    }

    public Element getElement() throws JspException {
        if (this.name == null) {
            throw new JspException("ABCommangTag.getEntry(): 'name' attribute not specified");
        }
        Element element = (Element)this.pageContext.getAttribute(this.name);
        if (element == null) {
            throw new JspException("ABBaseCommandTag.getEntry(): Bean corresponding to " + this.name + "not found in address book context");
        }
        return element;
    }

    public Element getEntry(int entryid) throws JspException {
        Element element;
        if (this.abContext == null) {
            this.abContext = this.getABContext();
        }
        if ((element = this.abContext.getEntry(entryid)) == null) {
            throw new JspException("ABBaseCommandTag.getEntry(): Element bean corresponding to " + entryid + " not found in the collection");
        }
        return element;
    }

    public void release() {
        super.release();
        this.abContext = null;
        this.name = null;
        this.entryid = null;
    }
}

