/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Enumeration;
import java.util.Properties;
import javax.mail.Session;
import javax.mail.Store;

public class JavaMailSSOAdapter
extends SSOAdapter {
    protected Store mailStore = null;
    protected Session mailSession = null;
    public static final String imap = "imap";
    public static final String imaps = "imaps";
    public static final String psimap = "psimap";
    public static final String psimaps = "psimaps";
    public static final String pop3 = "pop3";
    public static final String pop3s = "pop3s";
    public String imapProtocol = "";
    private final String SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        String protocolString;
        super.init(adapterName, token, adapterProperties);
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
        this.imapProtocol = (protocolString = adapterProperties.getProperty("protocol")).equalsIgnoreCase(imaps) ? imaps : (protocolString.equalsIgnoreCase(imap) ? imap : (protocolString.equalsIgnoreCase(psimap) ? psimap : (protocolString.equalsIgnoreCase(psimaps) ? psimaps : (protocolString.equalsIgnoreCase(pop3s) ? pop3s : pop3))));
        SSOAdapterDebug.logMessage("JavaMailSSOAdapter.init() imapProtocol=" + this.imapProtocol);
    }

    public void validate() throws ValidationException {
        String enableProxyAuth;
        String hostString;
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null) {
            try {
                int portInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null) {
            try {
                int portInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
        if ((enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false")).equals("false")) {
            String uidString = this.adapterProperties.getProperty("uid");
            if (uidString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingUid");
                throw ve;
            }
            String passwordString = this.adapterProperties.getProperty("password");
            if (passwordString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingPassword");
                throw ve;
            }
        }
    }

    public Object getConnection() {
        Store obj = null;
        SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getConnection() called");
        try {
            obj = this.getStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store");
        }
        return obj;
    }

    public boolean isAvailable() {
        if (this.mailStore != null && this.mailStore.isConnected()) {
            SSOAdapterDebug.logMessage("JavaMailSSOAdapter.isAvailable() returning true");
            return true;
        }
        SSOAdapterDebug.logMessage("JavaMailSSOAdapter.isAvailable() returning false");
        return false;
    }

    public Store getStore() throws Exception {
        SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getStore(): called");
        if (this.isAvailable()) {
            return this.mailStore;
        }
        Session mailSession = this.getSession();
        if (mailSession == null) {
            return null;
        }
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        String uid = null;
        String password = null;
        String portString = null;
        portString = this.imapProtocol.equalsIgnoreCase(psimaps) || this.imapProtocol.equalsIgnoreCase(imaps) ? this.adapterProperties.getProperty("port", "993") : this.adapterProperties.getProperty("port", this.imapProtocol.equals(pop3) ? "110" : "143");
        if (SSOAdapterDebug.messageEnabled()) {
            SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getStore() adapterProperties returns:");
            SSOAdapterDebug.logMessage("enableProxyAuth=" + enableProxyAuth + "\nportString=" + portString + "\nimapProtocol=" + this.imapProtocol);
        }
        String protocolString = this.imapProtocol;
        if (enableProxyAuth.equals("true")) {
            SSOToken tok = this.getSSOToken();
            if (tok != null) {
                uid = this.adapterProperties.getProperty("proxyAdminUid");
                password = this.adapterProperties.getProperty("proxyAdminPassword");
            }
        } else {
            uid = this.adapterProperties.getProperty("uid");
            password = this.adapterProperties.getProperty("password");
            String domain = this.adapterProperties.getProperty("domain");
            if (domain != null && !domain.equals("")) {
                uid = uid + "@" + domain;
                SSOAdapterDebug.logMessage(this.identifier + " domain=|" + domain + "|");
            }
        }
        SSOAdapterDebug.logMessage(this.identifier + " retrieving store with protocol " + protocolString);
        SSOAdapterDebug.logMessage(this.identifier + "Connecting with following properties: " + "\nuid=" + uid + "\nportString=" + portString + "\nhost=" + this.adapterProperties.getProperty("host"));
        this.mailStore = mailSession.getStore(protocolString);
        this.mailStore.connect(this.adapterProperties.getProperty("host"), Integer.parseInt(portString), uid, password);
        return this.mailStore;
    }

    public Session getSession() throws Exception {
        SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): called");
        if (this.mailSession != null) {
            SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): mailSession not null.");
            return this.mailSession;
        }
        String host = this.adapterProperties.getProperty("host");
        if (host == null) {
            return null;
        }
        String smtpPort = this.adapterProperties.getProperty("smtpPort");
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        Properties props = new Properties();
        props.put("mail.debug", "false");
        props.put("mail.store.pkgs", "com.sun.mail");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.imap.fetchsize", "16384");
        props.put("mail.smtp.host", this.adapterProperties.getProperty("smtpServer", host));
        if (smtpPort != null) {
            props.put("mail.smtp.port", smtpPort);
        }
        StringBuffer output = new StringBuffer();
        SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): imapProtocol=" + this.imapProtocol);
        if (this.imapProtocol.equals(psimaps)) {
            String s = null;
            s = this.adapterProperties.getProperty("socketFactoryClass");
            if (s != null && s.length() > 0) {
                if (SSOAdapterDebug.messageEnabled()) {
                    SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): set socketFactory to " + s);
                }
                props.setProperty("mail.psimaps.socketFactory.class", s);
            } else {
                if (SSOAdapterDebug.messageEnabled()) {
                    System.out.println("JavaMailSSOAdapter.getSession(): defaulting socketFactory to javax.net.ssl.SSLSocketFactory");
                }
                props.setProperty("mail.psimaps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            }
            s = this.adapterProperties.getProperty("socketFactoryFallback");
            if (s != null && s.length() > 0) {
                if (SSOAdapterDebug.messageEnabled()) {
                    SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): set socketFactory fallback to " + s);
                }
                props.setProperty("mail.psimaps.socketFactory.fallback", s);
            } else {
                if (SSOAdapterDebug.messageEnabled()) {
                    SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): defaulting socketFactory fallback to false");
                }
                props.setProperty("mail.psimaps.socketFactory.fallback", "false");
            }
            s = this.adapterProperties.getProperty("port");
            if (s != null && s.length() > 0) {
                if (SSOAdapterDebug.messageEnabled()) {
                    SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): set socketFactory port to " + s);
                }
                props.setProperty("mail.psimaps.socketFactory.port", s);
            } else {
                if (SSOAdapterDebug.messageEnabled()) {
                    SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): defaulting socketFactory port to 993");
                }
                props.setProperty("mail.psimaps.socketFactory.port", "993");
            }
        }
        if (enableProxyAuth.equals("true")) {
            SSOToken tok = this.getSSOToken();
            AMStoreConnection amsc = null;
            AMUser auser = null;
            String usrAttr = null;
            String puid = null;
            props.put("mail.psimap.fetchsize", "16384");
            if (tok != null) {
                usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                try {
                    amsc = new AMStoreConnection(tok);
                    auser = amsc.getUser(tok.getPrincipal().getName());
                    puid = auser.getStringAttribute(usrAttr);
                }
                catch (SSOException ssoe) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ssoe);
                }
                catch (AMException ame) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ame);
                }
                if (puid != null && puid.length() > 0) {
                    String domain = this.adapterProperties.getProperty("domain");
                    if (domain != null && domain.length() > 0) {
                        puid = puid + "@" + domain;
                    }
                    props.put("mail." + this.imapProtocol + ".proxyauth.user", puid);
                }
                SSOAdapterDebug.logMessage(this.identifier + "connecting with proxy uid=" + puid);
            }
        }
        if (SSOAdapterDebug.messageEnabled()) {
            SSOAdapterDebug.logMessage("JavaMailSSOAdapter.getSession(): props contains:");
            Enumeration<?> e = props.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                SSOAdapterDebug.logMessage(key + "=" + props.getProperty(key));
            }
        }
        this.mailSession = Session.getInstance((Properties)props, null);
        return this.mailSession;
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.mailStore.close();
            this.mailStore = null;
            this.mailSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.mailStore != null) {
                this.mailStore.close();
            }
            this.mailStore = null;
            this.mailSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

