/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ssoadapter.impl;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.sun.comclient.calendar.CalendarSession;
import com.sun.comclient.calendar.CalendarStore;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterDebug;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.ValidationException;
import java.util.Date;
import java.util.Properties;

public class JCAPISSOAdapter
extends SSOAdapter {
    protected long checkInterval;
    protected long lastCheckTime = 0L;
    protected static String CALENDAR_DEFAULT_PORT = "80";
    protected static String CLIENT_DEFAULT_PORT = "80";
    protected static String CALENDAR_DEFAULT_PROTOCOL = "http";
    protected static String CLIENT_DEFAULT_PROTOCOL = "http";
    protected static String serviceClass = "com.sun.comclient.calendar.socs.SOCSCalendarStore";
    protected CalendarSession calSession;
    protected CalendarStore calStore;

    public void init(String adapterName, SSOToken token, Properties adapterProperties) throws SSOAdapterException {
        super.init(adapterName, token, adapterProperties);
        try {
            this.checkInterval = Integer.parseInt(adapterProperties.getProperty("checkInterval", "5000"));
        }
        catch (Exception e) {
            String msg = this.getClass().getName() + ".init():  invalid \"checkInterval\" " + "parameter in adapterProperties \"" + this.getName() + "\"";
            throw new SSOAdapterException(msg);
        }
        if (adapterProperties.getProperty("validate", "false").equals("true")) {
            try {
                this.validate();
            }
            catch (ValidationException ve) {
                throw new SSOAdapterException(ve.getLocalizedMessage("ssoadapter", this.locale), true);
            }
        }
    }

    public void validate() throws ValidationException {
        String enableProxyAuth;
        String hostString;
        String portString = this.adapterProperties.getProperty("port");
        if (portString != null) {
            try {
                int portInt = Integer.parseInt(portString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidPort");
                throw ve;
            }
        }
        if ((hostString = this.adapterProperties.getProperty("host")) == null) {
            ValidationException ve = new ValidationException();
            ve.setErrorMessageID("missingHost");
            throw ve;
        }
        String clientPortString = this.adapterProperties.getProperty("clientPort");
        if (clientPortString != null) {
            try {
                int portInt = Integer.parseInt(clientPortString);
            }
            catch (Exception e) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("invalidClientPort");
                throw ve;
            }
        }
        if ((enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false")).equals("false")) {
            String uidString = this.adapterProperties.getProperty("uid");
            if (uidString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingUid");
                throw ve;
            }
            String passwordString = this.adapterProperties.getProperty("password");
            if (passwordString == null) {
                ValidationException ve = new ValidationException();
                ve.setErrorMessageID("missingPassword");
                throw ve;
            }
        }
    }

    public Object getConnection() {
        CalendarStore obj = null;
        try {
            obj = this.getCalStore();
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to get connection. ", e);
        }
        if (obj != null) {
            SSOAdapterDebug.logMessage(this.identifier + " connected to store.");
        }
        return obj;
    }

    public CalendarStore getCalStore() throws Exception {
        Date newCheckDate = new Date();
        long newCheckTime = newCheckDate.getTime();
        long timeSinceLastCheck = newCheckTime - this.lastCheckTime;
        if (timeSinceLastCheck < this.checkInterval && this.calStore != null) {
            return this.calStore;
        }
        this.lastCheckTime = newCheckTime;
        if (this.isAvailable()) {
            return this.calStore;
        }
        String host = this.adapterProperties.getProperty("host");
        String portStr = this.adapterProperties.getProperty("port", CALENDAR_DEFAULT_PORT);
        int port = Integer.parseInt(portStr);
        this.calSession = this.getCalSession();
        this.calStore = this.calSession.getStore(serviceClass);
        this.calStore.connect(host, port);
        return this.calStore;
    }

    public CalendarSession getCalSession() throws Exception {
        if (this.calSession != null) {
            return this.calSession;
        }
        Properties props = new Properties();
        String host = this.adapterProperties.getProperty("host");
        String port = this.adapterProperties.getProperty("port", CALENDAR_DEFAULT_PORT);
        String protocol = this.adapterProperties.getProperty("protocol", CALENDAR_DEFAULT_PROTOCOL);
        String domain = this.adapterProperties.getProperty("domain");
        String enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth", "false");
        String uid = null;
        String puid = null;
        String password = null;
        if (enableProxyAuth.equals("true")) {
            SSOToken tok = this.getSSOToken();
            AMStoreConnection amsc = null;
            AMUser auser = null;
            String usrAttr = null;
            if (tok != null) {
                uid = this.adapterProperties.getProperty("proxyAdminUid");
                password = this.adapterProperties.getProperty("proxyAdminPassword");
                usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
                try {
                    amsc = new AMStoreConnection(tok);
                    auser = amsc.getUser(tok.getPrincipal().getName());
                    puid = auser.getStringAttribute(usrAttr);
                }
                catch (SSOException ssoe) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ssoe);
                }
                catch (AMException ame) {
                    SSOAdapterDebug.logError(this.identifier + "proxy uid retrieval failed ", ame);
                }
                SSOAdapterDebug.logMessage(this.identifier + "connecting with proxy uid=" + puid);
            }
            if (domain == null) {
                SSOAdapterDebug.logMessage(this.identifier + "domain = null");
            } else {
                SSOAdapterDebug.logMessage(this.identifier + "domain= \"" + domain + "\"");
            }
            if (domain != null && domain.length() > 0) {
                puid = puid + "@" + domain;
            }
        } else {
            uid = this.adapterProperties.getProperty("uid");
            password = this.adapterProperties.getProperty("password");
            if (domain != null) {
                uid = uid + "@" + domain;
            }
        }
        if (host != null) {
            props.put("cal.host", host);
        }
        if (port != null) {
            props.put("cal.port", port);
        }
        if (uid != null) {
            props.put("cal.user", uid);
        }
        if (password != null) {
            props.put("cal.password", password);
        }
        if (protocol != null) {
            props.put("cal.protocol", protocol);
        }
        if (puid != null) {
            props.put("cal.proxyauth", puid);
        }
        this.calSession = CalendarSession.getInstance((Properties)props);
        return this.calSession;
    }

    public boolean isAvailable() {
        return this.calStore != null && this.calStore.isConnected();
    }

    public boolean closeConnection() {
        boolean retval = true;
        try {
            this.calStore.disconnect();
            this.calStore = null;
            this.calSession = null;
        }
        catch (Exception e) {
            retval = false;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
        return retval;
    }

    public void ssoTokenChanged(SSOTokenEvent evt) {
        try {
            int evtType = evt.getType();
            if (this.calStore != null) {
                this.calStore.disconnect();
            }
            this.calStore = null;
            this.calSession = null;
        }
        catch (Exception e) {
            SSOAdapterDebug.logMessage(this.identifier + " failed to close connection " + "to store ", e);
            return;
        }
        SSOAdapterDebug.logMessage(this.identifier + " closed connection to store");
    }
}

