/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.netlet.econnection.ReaderWriter;
import com.sun.portal.netlet.econnection.ReaderWriterClear;
import com.sun.portal.netlet.econnection.ReaderWriterLock;
import com.sun.portal.perf.rproxy.PerfContextObject;
import com.sun.portal.perf.rproxy.SocketCount;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.GWThreadPool;
import java.net.Socket;
import org.mozilla.jss.ssl.SSLSocket;

public class RWGroupJSSProxy
extends ReaderWriterLock {
    private Socket fromClient;
    private Socket toServer;
    private ReaderWriterClear src_to_dst;
    private ReaderWriterClear dst_to_src;
    private boolean src_to_dst_clean;
    private boolean dst_to_src_clean;

    public RWGroupJSSProxy(Socket fromSocket, Socket toSocket) {
        block5: {
            block4: {
                this.src_to_dst_clean = false;
                this.dst_to_src_clean = false;
                this.fromClient = fromSocket;
                this.toServer = toSocket;
                try {
                    this.src_to_dst = new ReaderWriterClear(this, this.fromClient.getInputStream(), this.toServer.getOutputStream());
                    this.dst_to_src = new ReaderWriterClear(this, this.toServer.getInputStream(), this.fromClient.getOutputStream());
                }
                catch (Exception ex) {
                    if (!GWDebug.debug.messageEnabled()) break block4;
                    GWDebug.debug.message("Unable to create ReaderWriter threads.", ex);
                }
            }
            try {
                GWThreadPool.run(this.src_to_dst);
                GWThreadPool.run(this.dst_to_src);
            }
            catch (InterruptedException e) {
                if (!GWDebug.debug.errorEnabled()) break block5;
                GWDebug.debug.error("Could not start ReaderWriterClear tasks", e);
            }
        }
    }

    public synchronized void notifyFinished(ReaderWriter obj) {
        if (obj == this.src_to_dst) {
            if (this.dst_to_src.isAlive()) {
                this.dst_to_src.stop();
            }
        } else if (obj == this.dst_to_src && this.src_to_dst.isAlive()) {
            this.src_to_dst.stop();
        }
        this.cleanup();
        if (obj == this.src_to_dst) {
            this.src_to_dst_clean = true;
        } else if (obj == this.dst_to_src) {
            this.dst_to_src_clean = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        if (this.fromClient != null) {
            try {
                this.fromClient.close();
                if (PerfContextObject.ENABLE_PERF) {
                    if (this.fromClient instanceof SSLSocket) {
                        SocketCount.decrementSSLSockets();
                    } else {
                        SocketCount.decrementPlainSockets();
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                this.fromClient = null;
            }
        }
        if (this.toServer != null) {
            try {
                this.toServer.close();
                if (this.toServer instanceof SSLSocket) {
                    SocketCount.decrementSSLSockets();
                } else {
                    SocketCount.decrementPlainSockets();
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.toServer = null;
            }
        }
    }

    public boolean isDone() {
        if (this.dst_to_src_clean && this.src_to_dst_clean) {
            this.dst_to_src = null;
            this.src_to_dst = null;
        }
        return this.dst_to_src_clean && this.src_to_dst_clean;
    }

    public long getLastActivityTime() {
        if (this.src_to_dst.getLastActivityTime() > this.dst_to_src.getLastActivityTime()) {
            return this.src_to_dst.getLastActivityTime();
        }
        return this.dst_to_src.getLastActivityTime();
    }

    public synchronized void stopAll() {
        if (this.dst_to_src != null) {
            this.dst_to_src.stop();
        }
        if (this.src_to_dst != null) {
            this.src_to_dst.stop();
        }
        this.cleanup();
    }

    public int getAppletSrcPort() {
        return 0;
    }

    public long getStartTime() {
        return 0L;
    }
}

