/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.rproxy.connectionhandler;

import com.sun.portal.rproxy.configservlet.client.GatewayProfile;
import com.sun.portal.rproxy.connectionhandler.BasicAuthentication;
import com.sun.portal.rproxy.connectionhandler.CSBufferedInputStream;
import com.sun.portal.rproxy.connectionhandler.CachedSocket;
import com.sun.portal.rproxy.connectionhandler.CachedSocketFactory;
import com.sun.portal.rproxy.connectionhandler.CookieParser;
import com.sun.portal.rproxy.connectionhandler.HTTPResponse;
import com.sun.portal.rproxy.connectionhandler.Request;
import com.sun.portal.rproxy.connectionhandler.Response;
import com.sun.portal.rproxy.connectionhandler.Retriever;
import com.sun.portal.util.DomainWebProxyConfig;
import com.sun.portal.util.GWDebug;
import com.sun.portal.util.ServiceIdentifier;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;

public class HTTPRetriever
implements Retriever {
    private static final String SET_COOKIE = "Set-Cookie";
    private static String gateway_ip;
    private static boolean cookie_management;
    private static boolean doBasicAuthentication;
    public static int numBytesRead;
    private static final int defaultBufferSize = 2048;

    public Response getResponse2(Request req, String destinationHost, Integer logId, byte[] param) {
        HTTPResponse result;
        CachedSocket s;
        block26: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = DomainWebProxyConfig.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                result = new HTTPResponse();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("HTTPRetriever retrieving " + req);
                }
                if (req.getUseProxy()) {
                    s = CachedSocketFactory.getCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever getProxyHost connecting to: " + req.getProxyHost());
                    }
                } else {
                    s = CachedSocketFactory.getCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                    }
                }
                if (s == null) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                    }
                    return null;
                }
                try {
                    this.sendRequest2(req, s, param);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                catch (Exception e) {
                    if (req.getUseProxy()) {
                        s = CachedSocketFactory.getNewCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getProxyHost());
                        }
                    } else {
                        s = CachedSocketFactory.getNewCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                        }
                    }
                    this.sendRequest2(req, s, param);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                if (doBasicAuthentication && result.getStatusCode().compareTo("401") != 0 && result.getStatusCode().compareTo("403") != 0 && password != null) {
                    BasicAuthentication.storePassword(req, destinationHost);
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                in.setClosed();
                in.setLength(length);
                result.setContentStream(in);
                result.setSocket(s);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPRetriever failed", ex);
                }
                result = null;
                if (s == null) break block26;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    public void sendRequest(Request req, CachedSocket s) throws IOException, EOFException {
        if (cookie_management && !req.getHost().equals(gateway_ip)) {
            CookieParser.restoreCookieHeader(req);
        }
        OutputStream out = s.getOutputStream();
        out.write(req.getRequestHeaderBytes());
        out.flush();
        String contentLength = req.getRequestHeader("Content-length");
        if (contentLength != null) {
            int length = Integer.parseInt(contentLength.substring(contentLength.indexOf(58) + 1).trim());
            byte[] content = new byte[2048];
            int read = 0;
            int totalRead = 0;
            BufferedInputStream reqIn = req.getContentStream();
            while (totalRead + 2048 < length) {
                read = reqIn.read(content, 0, 2048);
                if (read == -1 && totalRead < length) {
                    throw new EOFException();
                }
                if (read == 0) break;
                out.write(content, 0, read);
                totalRead += read;
            }
            int buffoffset = 0;
            while (totalRead < length) {
                read = reqIn.read(content, buffoffset, length - totalRead);
                if (read == -1 && totalRead < length) {
                    throw new EOFException();
                }
                if (read == 0) break;
                totalRead += read;
                buffoffset += read;
            }
            out.write(content, 0, buffoffset);
            req.addSize(totalRead);
        }
        out.flush();
    }

    public void sendRequest2(Request req, CachedSocket s, byte[] content) throws IOException, EOFException {
        if (cookie_management && !req.getHost().equals(gateway_ip)) {
            CookieParser.restoreCookieHeader(req);
        }
        OutputStream out = s.getOutputStream();
        out.write(req.getRequestHeaderBytes());
        out.flush();
        String contentLength = req.getRequestHeader("Content-length");
        if (contentLength != null) {
            int length = Integer.parseInt(contentLength.substring(contentLength.indexOf(58) + 1).trim());
            out.write(content);
        }
        out.flush();
    }

    public void getResponseHeader(HTTPResponse result, CSBufferedInputStream in, Request req) throws IOException, EOFException {
        boolean toSetCookie = cookie_management && !req.getHost().equals(gateway_ip);
        boolean keepGoing = true;
        in.setLength(4000);
        ByteArrayOutputStream byteOutStrm = new ByteArrayOutputStream();
        while (keepGoing) {
            int b = in.read();
            if (b == -1) {
                keepGoing = false;
                throw new EOFException();
            }
            byteOutStrm.write(b);
            if (b != 10) continue;
            String s = byteOutStrm.toString();
            if (s.regionMatches(true, 0, SET_COOKIE, 0, SET_COOKIE.length()) && toSetCookie) {
                String s_new = CookieParser.modifyCookieHeader(result, req, s);
                if (s_new != null) {
                    result.addHeaderLine(s_new);
                }
            } else if (s.toLowerCase().startsWith("content-length")) {
                String myHeader = result.getResponseHeader("Content-Length");
                if (myHeader == null) {
                    result.addHeaderLine(s);
                }
            } else if (s.toLowerCase().startsWith("content-disposition")) {
                s = byteOutStrm.toString("ISO-8859-1");
                result.addHeaderLine(s);
            } else {
                result.addHeaderLine(s);
            }
            keepGoing = !result.isHeaderComplete();
            byteOutStrm.reset();
        }
    }

    public Response getResponse(Request req, String destinationHost, Integer logId) {
        HTTPResponse result;
        CachedSocket s;
        block31: {
            s = null;
            CSBufferedInputStream in = null;
            String password = null;
            boolean found_pw = false;
            if (doBasicAuthentication) {
                password = req.getRequestHeader("Authorization");
                if (password == null) {
                    found_pw = BasicAuthentication.getPassword(req, destinationHost);
                } else {
                    String basic = password.substring(password.indexOf(58) + 1).trim();
                    if (!basic.regionMatches(true, 0, "basic ", 0, 5)) {
                        password = null;
                    }
                }
            }
            if (req.getUseProxy()) {
                String proxy_passwd;
                String prxyhost = req.getProxyHost();
                String headerProxyAuth = req.getRequestHeader("Proxy-Authorization");
                if (headerProxyAuth == null && (proxy_passwd = DomainWebProxyConfig.getProxyPassword(prxyhost)) != null) {
                    req.setRequestHeader("Proxy-Authorization", "Proxy-Authorization: Basic " + proxy_passwd);
                }
            }
            result = null;
            try {
                result = new HTTPResponse();
                if (GWDebug.debug.messageEnabled()) {
                    GWDebug.debug.message("HTTPRetriever retrieving " + req);
                }
                if (req.getUseProxy()) {
                    s = CachedSocketFactory.getCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever getProxyHost connecting to: " + req.getProxyHost());
                    }
                } else {
                    s = CachedSocketFactory.getCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                    }
                }
                if (s == null) {
                    if (GWDebug.debug.warningEnabled()) {
                        GWDebug.debug.warning("HTTPRetriever: Null socket returned. Probably couldn't resolve host.");
                    }
                    return null;
                }
                try {
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever before sendRequest(): req == " + req);
                    }
                    if (req.getContentStream() != null) {
                        req.getContentStream().mark(Integer.MAX_VALUE);
                    }
                    this.sendRequest(req, s);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                catch (Exception e) {
                    if (GWDebug.debug.errorEnabled()) {
                        GWDebug.debug.error("HTTPRetriever: Caught exception ", e);
                    }
                    if (req.getUseProxy()) {
                        s = CachedSocketFactory.getNewCachedSocket(req.getProxyHost(), req.getProxyPort(), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getProxyHost());
                        }
                    } else {
                        s = CachedSocketFactory.getNewCachedSocket(req.getHost(), Integer.parseInt(req.getPort()), "plain", logId);
                        if (GWDebug.debug.messageEnabled()) {
                            GWDebug.debug.message("HTTPRetriever: Connecting to: " + req.getHost());
                        }
                    }
                    if (GWDebug.debug.messageEnabled()) {
                        GWDebug.debug.message("HTTPRetriever: inside catch before sendRequest req.getObject() == " + req.getObject());
                    }
                    if (req.getContentStream() != null) {
                        req.getContentStream().reset();
                    }
                    this.sendRequest(req, s);
                    in = s.getInputStream();
                    this.getResponseHeader(result, in, req);
                }
                if (doBasicAuthentication && result.getStatusCode().compareTo("401") != 0 && result.getStatusCode().compareTo("403") != 0 && password != null) {
                    BasicAuthentication.storePassword(req, destinationHost);
                }
                String cl = result.getResponseHeader("content-length");
                int length = 0;
                length = cl != null ? Integer.parseInt(cl.substring(cl.indexOf(58) + 1).trim()) : -1;
                in.setClosed();
                in.setLength(length);
                result.setContentStream(in);
                result.setSocket(s);
            }
            catch (Exception ex) {
                if (GWDebug.debug.errorEnabled()) {
                    GWDebug.debug.error("HTTPRetriever failed", ex);
                }
                result = null;
                if (s == null) break block31;
                try {
                    s.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (result != null) {
            result.setSocket(s);
        }
        return result;
    }

    static {
        doBasicAuthentication = false;
        numBytesRead = 0;
        try {
            byte[] ip = InetAddress.getLocalHost().getAddress();
            gateway_ip = Integer.toString(ip[0] & 0xFF) + "." + Integer.toString(ip[1] & 0xFF) + "." + Integer.toString(ip[2] & 0xFF) + "." + Integer.toString(ip[3] & 0xFF);
        }
        catch (Exception e) {
            gateway_ip = null;
        }
        cookie_management = GatewayProfile.getBoolean("CookieManagement", false) && ServiceIdentifier.isGateway();
        doBasicAuthentication = GatewayProfile.getBoolean("DoBasicAuthentication", false) && ServiceIdentifier.isGateway();
    }
}

