/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class HTTPLogging
implements Filter {
    private Enumeration _params;
    private PrintWriter _reqWriter = null;
    private String _reqFile = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request != null) {
            Enumeration inputParams = request.getParameterNames();
            String curParam = null;
            String[] curValues = null;
            String tmpStr = ((HttpServletRequest)request).getRequestURI();
            if (tmpStr.endsWith(".xml")) {
                tmpStr = "lr file:///test/wbt_handlers" + tmpStr.substring(tmpStr.indexOf("/abs") + 4);
                this._reqWriter.print(tmpStr);
                this._reqWriter.print("?");
                while (inputParams.hasMoreElements()) {
                    curParam = (String)inputParams.nextElement();
                    curValues = request.getParameterValues(curParam);
                    for (int i = 0; i < curValues.length; ++i) {
                        this._reqWriter.print(URLEncoder.encode(curParam) + "=" + URLEncoder.encode(curValues[i]));
                        if (i + 1 >= curValues.length) continue;
                        this._reqWriter.print("&");
                    }
                    if (!inputParams.hasMoreElements()) continue;
                    this._reqWriter.print("&");
                }
                this._reqWriter.println();
                this._reqWriter.flush();
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig cfg) throws ServletException {
        this._params = cfg.getInitParameterNames();
        this._reqFile = cfg.getInitParameter("reqfile");
        if (this._reqFile == null || this._reqFile.length() == 0) {
            this._reqFile = "/tmp/reqfile.txt";
        }
        try {
            FileWriter reqWriter = new FileWriter(this._reqFile, true);
            this._reqWriter = new PrintWriter(reqWriter);
        }
        catch (IOException ioe) {
            throw new ServletException("HTTPLogging.init: Error creating log file: " + ioe.getMessage());
        }
    }

    public void destroy() {
    }
}

