/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.ui;

import com.iplanet.xslui.ui.XSLUILocator;
import com.iplanet.xslui.ui.XSLUILocatorHandler;
import com.iplanet.xslui.xslutil.XSLXMLLogHandler;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class DefaultXSLUILocatorHandler
extends XSLUILocatorHandler {
    public static final String CONFIG_PREFIX = "defaultxsluilocatorhandler";
    public static final String CONFIG_ROOTPATH = "defaultxsluilocatorhandler.rootpath";
    public static final String CONFIG_DEFAULTDEVICE = "defaultxsluilocatorhandler.defaultdevice";
    public static final String CONFIG_USERAGENT = "useragent";
    public static final String CONFIG_SUPPORTCLIENTXSL = "supportclientxsl";
    public static final String CONFIG_DEVICE = "device";
    private XSLXMLLogHandler _logHandler = null;
    private String _rootPath = null;
    private String _defaultDevice = null;
    private Hashtable _userAgentTable = null;

    public boolean init(File configPath, Properties configProperties, XSLXMLLogHandler logHandler) {
        this._logHandler = logHandler;
        this._rootPath = configPath.getAbsolutePath();
        this._userAgentTable = new Hashtable();
        this._defaultDevice = "html";
        boolean useRemoteUiPath = false;
        Enumeration<?> enumeration = configProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String userAgentString;
            UserAgent userAgent;
            File absolutePath;
            File uiPath;
            String parameter = (String)enumeration.nextElement();
            if (!parameter.startsWith(CONFIG_PREFIX)) continue;
            if (parameter.equals(CONFIG_ROOTPATH)) {
                uiPath = new File(configProperties.getProperty(parameter));
                if (uiPath.isAbsolute()) {
                    if (uiPath.exists()) {
                        this._rootPath = uiPath.getAbsolutePath();
                    } else {
                        useRemoteUiPath = true;
                    }
                } else {
                    absolutePath = new File(configPath, uiPath.getPath());
                    if (absolutePath.exists()) {
                        this._rootPath = absolutePath.getAbsolutePath();
                    } else {
                        useRemoteUiPath = true;
                    }
                }
                this._logHandler.debug("DefaultXSLUILocatorHandler.init: rootpath for UI=" + this._rootPath);
                continue;
            }
            if (useRemoteUiPath) {
                uiPath = new File("../../WEB-INF/ui");
                absolutePath = new File(configPath, uiPath.getPath());
                this._rootPath = absolutePath.getAbsolutePath();
                this._logHandler.debug("DefaultXSLUILocatorHandler.init: rootpath for UI=" + this._rootPath);
                useRemoteUiPath = false;
                continue;
            }
            if (parameter.equals(CONFIG_DEFAULTDEVICE)) {
                this._defaultDevice = configProperties.getProperty(parameter);
                continue;
            }
            String pattern = parameter.substring(parameter.indexOf("."), parameter.lastIndexOf(".") + 1);
            if (pattern == null || pattern.length() <= 0 || (userAgent = (UserAgent)this._userAgentTable.get(pattern)) != null || (userAgentString = configProperties.getProperty(CONFIG_PREFIX + pattern + CONFIG_USERAGENT)) == null) continue;
            userAgent = new UserAgent(userAgentString);
            userAgent.setDevice(configProperties.getProperty(CONFIG_PREFIX + pattern + CONFIG_DEVICE, this._defaultDevice));
            boolean supportClientXSL = Boolean.valueOf(configProperties.getProperty(CONFIG_PREFIX + pattern + CONFIG_SUPPORTCLIENTXSL, "false"));
            userAgent.setXSLSupport(supportClientXSL);
            this._logHandler.debug("DefaultXSLUILocatorHandler.init: adding " + pattern + "(" + userAgent.toString() + ")");
            this._userAgentTable.put(pattern, userAgent);
        }
        return true;
    }

    public XSLUILocator getLocator(HttpServletRequest request) throws IOException {
        String device = this._defaultDevice;
        boolean supportClientXSL = false;
        String uri = request.getRequestURI();
        int lastSlash = uri.lastIndexOf("/");
        int secondLastSlash = uri.substring(0, lastSlash).lastIndexOf("/");
        String xmlTemplate = uri.substring(lastSlash + 1);
        String application = "";
        if (secondLastSlash > -1) {
            application = uri.substring(secondLastSlash + 1, lastSlash);
        }
        if (xmlTemplate == null) {
            this._logHandler.error("DefaultXSLUILocatorHandler.getLocator: Couldn't find XML template in " + uri);
            return null;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            this._logHandler.error("DefaultXSLUILocatorHandler.getLocator: no session");
            return null;
        }
        String domain = (String)session.getAttribute("domainname");
        if (domain == null) {
            this._logHandler.error("DefaultXSLUILocatorHandler.getLocator: no domain");
            return null;
        }
        String lang = request.getParameter("lang");
        if (lang != null) {
            session.setAttribute("userlang", (Object)lang);
        } else {
            lang = (String)session.getAttribute("userlang");
            if (lang == null) {
                lang = request.getHeader("Accept-Language");
            }
        }
        if (lang == null) {
            lang = "en";
        }
        Enumeration enumeration = this._userAgentTable.elements();
        while (enumeration.hasMoreElements()) {
            UserAgent userAgent = (UserAgent)enumeration.nextElement();
            if (!userAgent.match(request)) continue;
            device = userAgent.getDevice();
            supportClientXSL = userAgent.supportClientXSL();
            break;
        }
        String[] pathList = new String[]{this._rootPath + "/" + device + "/" + application + "/" + domain + "/" + lang + "/", this._rootPath + "/" + device + "/" + application + "/" + domain + "/", this._rootPath + "/" + device + "/" + domain + "/" + lang + "/", this._rootPath + "/" + device + "/" + domain + "/", this._rootPath + "/" + device + "/" + application + "/" + lang + "/", this._rootPath + "/" + device + "/" + application + "/", this._rootPath + "/" + device + "/" + lang + "/", this._rootPath + "/" + device + "/", this._rootPath + "/" + lang + "/", this._rootPath + "/"};
        XSLUILocator uiLocator = new XSLUILocator(xmlTemplate, "dictionary-" + lang + ".xml", pathList, supportClientXSL);
        return uiLocator;
    }

    private class UserAgent {
        private String _startWith = null;
        private String _device = "html";
        private boolean _supportClientXSL = false;

        public UserAgent(String startWith) {
            this._startWith = startWith;
        }

        public boolean match(HttpServletRequest req) {
            String userAgentString = req.getHeader("User-Agent");
            if (userAgentString == null) {
                return false;
            }
            return userAgentString.startsWith(this._startWith);
        }

        public void setDevice(String device) {
            this._device = device;
        }

        public String getDevice() {
            return this._device;
        }

        public void setXSLSupport(boolean supported) {
            this._supportClientXSL = supported;
        }

        public boolean supportClientXSL() {
            return this._supportClientXSL;
        }

        public String toString() {
            return "Pattern:" + this._startWith + ";Device:" + this._device + ";supportClientXSL:" + this._supportClientXSL;
        }
    }
}

