/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.xslui.tools;

import com.iplanet.xslui.tools.LDAPPool;
import com.iplanet.xslui.tools.PropertyReader;
import com.iplanet.xslui.ui.Logging;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import netscape.ldap.LDAPException;

public class LDAPConfigReader {
    public static final String LDAPHOST = "ldaphost";
    public static final String LDAPPORT = "ldapport";
    public static final String LDAPBINDDN = "ldapbinddn";
    public static final String LDAPBINDCRED = "ldapbindcred";
    public static final String LDAPVERSION = "ldapversion";
    public static final String LDAPPOOLMIN = "ldappoolmin";
    public static final String LDAPPOOLMAX = "ldappoolmax";
    public static final String LDAPPOOLTIMEOUT = "ldappooltimeout";
    private static int _port = 389;
    private static Hashtable _poolTable;

    public static LDAPPool getLDAPPool(PropertyReader propertyReader, String configPrefix) throws LDAPException {
        int ldapPoolMin = propertyReader.getIntProperty(configPrefix + LDAPPOOLMIN, 1);
        int ldapPoolMax = propertyReader.getIntProperty(configPrefix + LDAPPOOLMAX, 4);
        int ldapPoolTimeOut = propertyReader.getIntProperty(configPrefix + LDAPPOOLTIMEOUT, 10);
        String ldapHost = propertyReader.getStringProperty(configPrefix + LDAPHOST, "localhost");
        int ldapPort = propertyReader.getIntProperty(configPrefix + LDAPPORT, _port);
        int ldapVersion = propertyReader.getIntProperty(configPrefix + LDAPVERSION, 3);
        String ldapBindDN = propertyReader.getStringProperty(configPrefix + LDAPBINDDN, "anonymous");
        String ldapBindCred = propertyReader.getStringProperty(configPrefix + LDAPBINDCRED, "");
        String poolLookupKey = ldapHost + ":" + ldapPort + ":" + ldapBindDN;
        if (_poolTable != null && _poolTable.containsKey(poolLookupKey)) {
            Logging.trace((int)1, (String)("Pool exists for -> " + poolLookupKey));
            return (LDAPPool)_poolTable.get(poolLookupKey);
        }
        Logging.trace((int)1, (String)("Pool doesn't exists for -> " + poolLookupKey + " so creating a new one"));
        LDAPPool ldPool = new LDAPPool(ldapPoolMin, ldapPoolMax, ldapPoolTimeOut, ldapHost, ldapPort, ldapBindDN, ldapBindCred, ldapVersion);
        if (_poolTable == null) {
            _poolTable = new Hashtable();
        }
        _poolTable.put(poolLookupKey, ldPool);
        return ldPool;
    }

    public static void setDefaultPort(int port) {
        _port = port;
    }

    public static void destroyPool() {
        Set keys = _poolTable.keySet();
        Iterator itor = keys.iterator();
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)itor.next();
            LDAPPool ldPool = (LDAPPool)_poolTable.get(key);
            if (ldPool != null) {
                ldPool.destroy();
            }
            _poolTable.remove(key);
        }
    }
}

