#
#   File:    filewch-d.prc
#   Version: 1.11
#
#   Copyright (c) 2001 Sun Microsystems Inc.
#

proc checkFiles {} {
    set result ""
    if { [ entries fnames ] == "" } {
        getFileSpecs
    }
    sliceforeach name fname fnames {
        if { [ file exists $fname ] } {
            # Get timestamp of file
            set time [ file mtime $fname ]
            lappend result $time
        }
    }
    return $result
}

proc getFilesInfo {} {

    set args ""

    if { [ entries fnames ] == "" } {
        getFileSpecs
    }

    set entry_toeid [ locate watchTable*watchTableEntry ]

    sliceforeach name fname fnames {
        set delimiter [ lookup -d "" fdelimiters $name ]
        set comment [ lookup -d "" fcomments $name ]
        set fields [ lookup -d "" ffieldss $name ]
        set keyfields [ lookup -d "" fkeyfieldss $name ]
        set fhideValue [ lookup -d "" fhideValues $name ]
        set ffnames [ lookup -d "" ffnamess $name]
        set fformat [ lookup -d "" fformats $name]
        set addsev [ lookup -d "" additionsevs $name ]
        set delsev [ lookup -d "" deletionsevs $name ]
        set chgsev [ lookup -d "" changesevs $name ]
        set script [ lookup -d "" scripts $name ]
        set mstate [ lookup -d "on" mstates $name ]
        set size ""
        set owner ""
        set group ""
        set mode ""
        set time ""

        set modroot [ ilookup internal moduleroot ]
        toe_send $modroot undefine noopen $name
        toe_send $modroot undefine noexist $name

        if { [ file exists $fname ] } {
            set filetype [ file type $fname ]
            if { "$filetype" == "directory" } {
                ddl print debug "filewch: $name is a directory"
                toe_send $modroot define noopen $name "1"
            } else {
                
                #Routine to check if file perms have also been modified
                file stat $fname perm
                set newtime $perm(ctime)

                # Check if file changed and build param lists
                if { [ lsearch [ toe_send $entry_toeid getRowNames ] $name ] != -1 } {
                    # Get previous timestamp if the file was already in the list
                    set oldtime [ toe_send $entry_toeid getRowValue ftimestamp $name ]
                    if { [ string compare $oldtime [ clock format $newtime ] ]  != 0 } {
                        if { [ string compare $mstate "on" ] == 0 } {
                            # prepare file param for get_events
                            regsub -all " " $ffnames "@S@P@A@C@E@" parsedffnames
                            append args $fname " " $delimiter " " $comment " " $fields " " $keyfields " " $fhideValue " " $parsedffnames \n
                        }

                        runValidationScript $script $name
                    }
                } else {
                    # Newly added to the list. Force to make a copy before
                    # we miss the first event...
                    #
                    # prepare file param for get_events
                    regsub -all " " $ffnames "@S@P@A@C@E@" parsedffnames
                    append args $fname " " $delimiter " " $comment " " $fields " " $keyfields " " $fhideValue " " $parsedffnames \n
                    runValidationScript $script $name
                }

                # run the DAQ command 
                set wfanswer [ fw_get_file_data $fname ]
                if { $wfanswer == "" } {
                    toe_send $modroot define noopen $name "1"
                } else {
                    lextract $wfanswer 0 size 1 owner 2 group 3 mode 4 time
                    set time [ clock format $time ]
                }
                undefine wfanswer
            }
        } else {
            runValidationScript $script $name
            ddl print debug "filewch: $name doesn't exist"
            toe_send $modroot define noexist $name "1"
        }
        # put the variable in the list to return
        lappend result [ list $name $fname $delimiter $comment $fields $keyfields $ffnames $fhideValue $addsev $delsev $chgsev $size $owner $group $mode $time $script $fformat $mstate ]
    }

    if { $args != "" }  {
        # we need to check for new events.
        set callme [ list [ toe_self ] { eventResultHandler %result } ]
        sh -u root -cb $callme -c "filewch_new_events $args"
    }

    return $result
}

proc runValidationScript { script name } {
    global env
    # if there is a validation script, it is time to run it
    if { $script != "" } {
        set cmd ""
        append cmd "$env(ESDIR)/SysMgmtPack/filewch/scripts/" $script
        lextract $script 0 scriptname
        if { [ file exists $env(ESDIR)/SysMgmtPack/filewch/scripts/$scriptname ] } {
            if { $script == "fileparse" } {
                set delimiter [ lookup -d "" fdelimiters $name ]
                set comment [ lookup -d "" fcomments $name ]
                set fname [ lookup -d "" fnames $name ]
                set format [ lookup -d "" fformats $name ]
                if { [ string match *"* $format ] } {
                    sh -u root -cb [ list [ toe_self ] "validationResultHandler %result $name" ] -c $cmd -d $delimiter -c $comment -f $format -n $fname
                } else {
                    sh -u root -cb [ list [ toe_self ] "validationResultHandler %result $name" ] -c $cmd -d $delimiter -c $comment -f "$format" -n $fname
                }
            } else {
                sh -u root -cb [ list [ toe_self ] "validationResultHandler %result $name" ] -c $cmd
            }
        }
    }

}

proc eventResultHandler  { result } {
    ddl print debug "filewch: In eventResultHandler $result"
    
    # Let changeTable know it is time to refresh.
    toe_send [ locate filewch*changeTable ] refreshValue
}

proc validationResultHandler  { result name } {
    lextract $result 2 status
    ddl print debug "filewch: In validationResultHandler : status = $status "

    set statuspcs [ split $status ]
    lextract $statuspcs 1 pid 3 kill

    set code [locate .iso*modules.filewch.filewchBase.watchTable.watchTableEntry.exitCode ]
    set table [locate .iso*filewch.filewchBase.watchTable.watchTableEntry ]

    set rowNumber [toe_send $table getRowIndex $name ]

    if { [ string compare $kill killed ] == 0 } {
        set retval "Killed"
    } else {
        lextract $statuspcs 5 retval
    }

    # update and refresh exitCode
    toe_send $code setValue $rowNumber $retval
    toe_send $code refreshValue
}

proc getExitCode {} {
    global env
    set res ""
    set null ""
    set num [ toe_send [ locate watchTable.watchTableEntry ] getTableDepth ]

    for { set i 1 } { $i <= $num } { incr i 1 } {
        set script [ getRowValue watchTable.watchTableEntry.script $i ]
        if { $script == "" } {
            lappend res $null
        } else {
            lextract $script 0 script
            if { [ file exists $env(ESDIR)/SysMgmtPack/filewch/scripts/$script ] != 1 } {
                lappend res "NO_SUCH_SCRIPT"
            } else {
                if { [ catch { getValue $i } result ] == 1 }  {
                   lappend res $null
                } else {
                   lappend res $result
                }
            }
        }
    }
    return $res
}


proc getFileSpecs {} {
    # This function gets the list of file we are monitoring from the disk
    set fileSpecList [ getAttribute fileSpecList "" ]

    undefine fnames
    undefine rowstatus
    undefine fcomments
    undefine ffieldss
    undefine fdelimiters
    undefine fkeyfieldss
    undefine ffnamess
    undefine fformats
    undefine fhideValues
    undefine additionsevs
    undefine deletionsevs
    undefine changesevs
    undefine scripts
    undefine mstates

    if { $fileSpecList != "" } {
        set idx 1
        set rowstatusid [ locate *watchTable.watchTableEntry.rowstatus ]
        foreach entry $fileSpecList {
            lextract $entry 0 name 1 rowstatus 2 fname 3 fcomment 4 ffields 5 fdelimiter 6 fkeyfields 7 ffnames 8 fhideValue 9 additionsev 10 deletionsev 11 changesev 12 script 13 fformat 

            # For backward compatibility. There used to be one less entry.
            set mstate "on"
            catch { lextract $entry 14 mstate }

            define rowstatus $name $rowstatus
            define fnames $name $fname
            define fcomments $name $fcomment
            define ffieldss $name $ffields
            define fdelimiters $name $fdelimiter
            define fkeyfieldss $name $fkeyfields
            define ffnamess $name $ffnames
            define fformats $name $fformat
            define fhideValues $name $fhideValue
            define additionsevs $name $additionsev
            define deletionsevs $name $deletionsev
            define changesevs $name $changesev
            define scripts $name $script
            define mstates $name $mstate
            toe_send $rowstatusid setRowStatus $idx $name $rowstatus
            incr idx
        }
    }
}

proc setEntry { attrib name value } {
    global env
    if { $attrib == "fnames" } {
        # to clear alarm on a previously non-existing file if pb is corrected 
        toe_send [ locate filewchBase.changeTable ] refreshValue
    }
    ddl print debug "filewch: setEntry $attrib $name $value"
    if { $attrib == "scripts" || $attrib == "fformats" } {
        set code ""
        if { $value != "" } {
            lextract $value 0 script
            if { [ file exists $env(ESDIR)/SysMgmtPack/filewch/scripts/$script ] != 1 } {
                set code "NO_SUCH_SCRIPT"
            } else {
                runValidationScript $value $name
            }
        }
        set rowNumber [toe_send [ locate watchTable.watchTableEntry ] getRowIndex $name ]
        toe_send [ locate watchTable.watchTableEntry.exitCode ] setValue $rowNumber $code
    }

    define $attrib $name $value
    return $value
}

proc addEntry { index name rowstatus } {
    define rowstatus $name $rowstatus
}

proc removeEntry { index name } {
    global env

    # This function removes an entry
    deferSyncSlice value

    set tableObject [ locate watchTable.watchTableEntry ]
    if { $tableObject != "" } {
        # clean up
        toe_send $tableObject cleanupRow $name CLEAR_PARMS
        toe_send [ locate filewchBase.changeTable ] refreshValue
    } else {
        ddl print warning "filewch: could not find filewchTableEntry while removing entry $name in module [ getModuleParam moduleSpec ] \n "
    }

    # delete our copy of the file
    set file [ lookup -d "" fnames $name ]
    sh -u root -c "/bin/rm $env(ESDIR)/SysMgmtPack/filewch/files$file"

    undefine fnames $name
    undefine rowstatus $name
    undefine fcomments $name
    undefine ffieldss $name
    undefine fdelimiters $name
    undefine fkeyfieldss $name
    undefine ffnamess $name
    undefine fformats $name
    undefine fhideValues $name
    undefine additionsevs $name
    undefine deletionsevs $name
    undefine changesevs $name
    undefine scripts $name
    undefine mstates $name
   
    toe_send [ getModuleRoot ] undefine noexist $name
    toe_send [ getModuleRoot ] undefine noopen $name

    syncWatchList

    commitSyncSlice value
    toe_send [ locate filewchBase.watchTable ] refreshValue

    return [ list "$name Entry removed" ]
}

proc syncWatchList {} {
    # This function syncs our list of watched files to disk

    set fileSpecList ""

    sliceforeach name fname fnames {
        set rowstatus 	[ lookup -d "1" rowstatus $name ]
        set fcomment 	[ lookup -d "" fcomments $name ]
        set ffields 	[ lookup -d "" ffieldss $name ]
        set fdelimiter 	[ lookup -d "" fdelimiters $name ]
        set fkeyfields 	[ lookup -d "" fkeyfieldss $name ]
        set ffnames 	[ lookup -d "" ffnamess $name ]
        set fformat 	[ lookup -d "" fformats $name ]
        set fhideValue	[ lookup -d "" fhideValues $name ]
        set additionsev [ lookup -d "" additionsevs $name ]
        set deletionsev [ lookup -d "" deletionsevs $name ]
        set changesev   [ lookup -d "" changesevs $name ]
        set script      [ lookup -d "" scripts $name ]
        set mstate      [ lookup -d "on" mstates $name ]

        lappend fileSpecList [ list $name $rowstatus $fname $fcomment $ffields $fdelimiter $fkeyfields $ffnames $fhideValue $additionsev $deletionsev $changesev $script $fformat $mstate ]
    }
    
    setAttribute fileSpecList $fileSpecList
}

proc readEventsLog {} {
    global env
    set index 0
    set result ""
    set log "$env(ESDIR)/SysMgmtPack/filewch/log/events.log"
    if { [ file exists $log ] == 1 } {
        set fd [ open $log r ]
        set events [ read $fd ]
        close $fd
        foreach { file line idx type field old new time } $events {
            regsub -all "@S@P@A@C@E@" $field " " field
            lappend result $index $file $line $idx $type $field $old $new [ clock format $time ]
            incr index
        }
    }

    toe_csend dummy [ locate filewch ] setTrapInfo refreshOID

    return $result
}

proc dumpEvents {} {
    global env

    closeEvents

    set time [ clock format [ clock seconds ] -format {%y%m%d%T} ]
    regsub -all {:} $time {} time

    set logfile "$env(ESDIR)/SysMgmtPack/filewch/log/events_$time.log"
    set callme [ list [ toe_self ] { eventResultHandler %result } ]
    sh -u root -cb $callme -c "/bin/mv $env(ESDIR)/SysMgmtPack/filewch/log/events.log $logfile"
    return $logfile
}

proc closeEvents {} {
    global env
    set file "$env(ESDIR)/SysMgmtPack/filewch/log/events.action"
    set fd [ open $file w ]
    puts $fd "CLOSE"
    close $fd
    toe_send [ locate changeTable ] refreshValue
    set fd [ open $file w ]
    close $fd
    return "OK"
}

proc checkState { value } {
    set retval 0
    if { [ string compare $value "on"] == 0 ||
         [ string compare $value "off"] == 0 } {
        set retval 1
    } else {
        set retval 0
    }
    ddl print debug "Exiting checkState: $retval"
    return $retval
}
