#!/bin/sh -x

# Patch Deinstallation Procedure Instructions:
# --------------------------------------------
# To deinstall the patch, if there are errors or other problem with
# this patch, please run the undo_pre<bug number>.sh shell script
# which is generated automatically when patch.sh is run. Use the
# following syntax to run the deinstall script:
#
# % sh undo_pre4002909_8.1.7.4.0.sh
#
# After deinstalling the patch, revert back to the previous sql
# scripts.

BASEDIR=`/usr/bin/pkgparam SUNWescom BASEDIR`
UNINST_PATCH_LOG="/var$BASEDIR/SUNWsymon/install/ora-patch-uninst.$$"
. ${BASEDIR}/SUNWsymon/sbin/es-common.sh

/usr/bin/sh  $BASEDIR/SUNWsymon/oracle/product/8.1.7/admin/SunMC/patches/4067749/undo_pre4002909_8.1.7.4.0.sh >>$UNINST_PATCH_LOG 2>&1
$CMD_RM  $BASEDIR/SUNWsymon/oracle/product/8.1.7/admin/SunMC/patches/4067749/undo_pre4002909_8.1.7.4.0.sh 

set_basedir
set_db_env
. ${BASEDIR}/lib/sbin/db-common.sh
db_setupEnvironment

# Start database if not already up
db_start_database

# Run sql command
/usr/bin/su - $SMCORAU -c "
    . $BASEDIR/sbin/es-common.sh
    set_db_env
    cd \"$ORACLE_HOME\";
    $ORACLE_HOME/bin/sqlplus /nolog <<EOF 
        connect / as sysdba;


@/opt/SUNWsymon/oracle/product/8.1.7/rdbms/admin/dbmsplts.sql
@/opt/SUNWsymon/oracle/product/8.1.7/rdbms/admin/prvtpexp.plb
@/opt/SUNWsymon/oracle/product/8.1.7/rdbms/admin/prvtplts.plb 

# Finally, compile any invalid PL/SQL objects

 select count(1) from all_objects where STATUS = 'VALID';
 select count(1) from all_objects where STATUS <> 'VALID';
 @/opt/SUNWsymon/oracle/product/8.1.7/rdbms/admin/utlrp.sql
 select count(1) from all_objects where STATUS = 'VALID';
 select count(1) from all_objects where STATUS <> 'VALID';


EOF
        " 2>&1

# Stop Database
db_stop_database

