#!/bin/sh
# 6th Oct 2004. V3.20

trap 'echo "Patch installation aborted!";$UNDO;exit 1' 1 2 3 15
    
#==============================================================
# if you want to see the workings set the environment variable
# ORACLE_TRACE to T -  This will enable the -xv option for the
# bourne shell.

ORACLE_HOME=/opt/SUNWsymon/oracle/product/8.1.7 
export ORACLE_HOME 
PATH=$PATH:$ORACLE_HOME/bin:/usr/ccs/bin
export PATH 

case $ORACLE_TRACE in
    T)  set -xev ;;
esac

setup(){

insttype

PVER="V3.20"
PSE=4002909
BUG=4002909
PATCHSET_FLAG=y
VERSION="8.1.7.4.0"
PLATFORM="Solaris Operating System (SPARC 32-bit):453"
SAVE_SUFFIX="pre"$BUG"_"$VERSION

#
# This list the base bugs that are replaced by this patch. If you
# find a conflict reported and it represents a fix for one of these
# base bugs you can add it to this list. You must follow the format
# shown.

#REPLLIST=""

REPLLIST="3889519 2363247 2379325 2410612 2528524 2598387 2643579"
REPLLIST=$REPLLIST" 2337115 3926963 1811914 2073948 2268284 2271499"
REPLLIST=$REPLLIST" 2346568 2386334 2401670 2450264 2486714 2660592"
REPLLIST=$REPLLIST" 2663395 2664217 2791662 3811838 3828166 0917604"
REPLLIST=$REPLLIST" 2128784 2198861 2225569 2228280 2288481 2293786"
REPLLIST=$REPLLIST" 2324795 2405244 2444568 2479110 2556845 2580648"
REPLLIST=$REPLLIST" 2594253 2656881 2767834 2905667 2986643 3019460"
REPLLIST=$REPLLIST" 3212916 3315378 3197147"
REPLLIST=$REPLLIST" 3821967 4017012 4067749 2597049 2776474" 

MANDATORY_FILES="rdbms/mesg:oraus.msg,oraus.msb"

NEW_FILES=""

OPTIONAL_FILES="lib:libnjssl8.so,libowm2.so"
#OPTIONAL_FILES=$OPTIONAL_FILES" md/admin:prvtmd2.plb"
#OPTIONAL_FILES=$OPTIONAL_FILES" ctx/admin:driload.pkh,dr0out.plb"
OPTIONAL_FILES=$OPTIONAL_FILES" network/lib:libnldapj8.so,libnoncj8.so"
OPTIONAL_FILES=$OPTIONAL_FILES" rdbms/admin:prvtpexp.plb,prvtplts.plb,dbmsplts.sql"

#OPTIONAL_LIBS=
OPTIONAL_LIBS="lib:libctx8.a:druf.o"
optional_libr

#LOBS1="network/lib:libnlsnr8.a:"
#LOBS1=$LOBS1"nsgca.o,nsgcmd.o,nsgcs.o,nsglcst.o,nsgle.o,nsglgr.o,"
#LOBS1=$LOBS1"nsglh.o,nsgli.o,nsgll.o,nsglm.o,nsglpnp.o,nsglro.o,"
#LOBS1=$LOBS1"nsgls.o,nsglsn.o,nsglv.o,nsgsubgt.o,nsgua.o,snsglsn.o"

LOBS2="network/lib:libnlsnrc8.a:"
LOBS2=$LOBS2"2#nsglcst.o"

LOBS3="lib:libn8.a:"
LOBS3=$LOBS3"hdskcert.o,hdskkyex.o,nnciqd.o,nnfu.o,nsdo.o,nsev.o,"
LOBS3=$LOBS3"ntvl.o,ssl2mesg.o,sslrec.o,sslx509.o"

LOBS4="lib:libnl8.a:"
LOBS4=$LOBS4"nlstd.o,nlstdgo.o,nlstdstp.o"

LOBS5="lib:libnro8.a:"
LOBS5=$LOBS5"ncrfipm.o"

LOBS6="lib:libnsslb8.a:"
LOBS6=$LOBS6"asn1dec.o,pkcs.o"

LOBS7="lib:libntcp8.a:"
LOBS7=$LOBS7"ntt.o"

LOBS8="lib:libnzjs8.a:"
LOBS8=$LOBS8"nzjb.o,nzjcu.o,nzjh.o,nzjs.o,nzjsc.o,nzjscb.o,nzjsi.o,"
LOBS8=$LOBS8"nzjsm.o,nzjsu.o,snzjs.o"

LOBS9="lib:libcore8.a:"
LOBS9=$LOBS9"ldidfs.o,ldiifs.o,ldiiftz.o,ldiinp.o,ldiout.o"

LOBSA="lib:libpls8.a:"
LOBSA=$LOBSA"pesblt.o"

LOBSB="lib:libclient8.a:"
LOBSB=$LOBSB"kpuf.o"

LOBSC="lib:libcommon8.a:"
LOBSC=$LOBSC"ttcf.o"

LOBSD="lib:libgeneric8.a:"
LOBSD=$LOBSD"kgff.o,kgl.o,kgl2.o,kol.o,kolf.o,skgfr.o"

LOBSE="lib:libserver8.a:"
LOBSE=$LOBSE"apa.o,atb.o,ctc.o,kcf.o,kcrr.o,kct.o,kcv.o,kdic.o,"
LOBSE=$LOBSE"kfh.o,kfp.o,kkdl.o,kke.o,kkm.o,kko.o,kkqu.o,kks.o,"
LOBSE=$LOBSE"kksl.o,kokb.o,kokb2.o,kokl.o,kokm.o,kprc.o,kql.o,"
LOBSE=$LOBSE"krb.o,krvd.o,kta.o,ktc.o,ktec.o,kxs.o,nsoqbc.o,"
LOBSE=$LOBSE"opiall.o,opiodr.o,prsa.o,prsc.o,prsf.o,prssz.o,"
LOBSE=$LOBSE"psdicd.o,qkadrv.o,qol.o,tbsdrv.o,vop.o"


LIBS_OBJECTS="$LOBS1 $LOBS2 $LOBS3 $LOBS4 $LOBS5 $LOBS6 $LOBS7 $LOBS8"
LIBS_OBJECTS=$LIBS_OBJECTS" $LOBS9 $LOBSA $LOBSB $LOBSC $LOBSD $LOBSE"
LIBS_OBJECTS=$LIBS_OBJECTS" $OPTION_LIB"


if [ "$INST_TYPE" = "Server" ]; then

   MAKE_TRIPLETS="$ORACLE_HOME/rdbms/lib:ins_rdbms.mk:client_sharedlib,ioracle,utilities" 
   MAKE_TRIPLETS=$MAKE_TRIPLETS" $ORACLE_HOME/network/lib:ins_net_server.mk:install"
   MAKE_TRIPLETS=$MAKE_TRIPLETS" $ORACLE_HOME/network/lib:ins_net_client.mk:install"

   EXECUTABLES="bin/trcasst bin/trcroute bin/tnsping"
   EXECUTABLES=$EXECUTABLES" bin/onrsd bin/oracle bin/tnslsnr bin/lsnrctl"
   SHUTDOWN=true

else

   MAKE_TRIPLETS="$ORACLE_HOME/rdbms/lib:ins_rdbms.mk:client_sharedlib,utilities" 
   MAKE_TRIPLETS=$MAKE_TRIPLETS" $ORACLE_HOME/network/lib:ins_net_client.mk:install"

   EXECUTABLES="bin/trcasst bin/trcroute bin/tnsping"
   SHUTDOWN=false
fi

DO_MAKE=true
AGENT_PATCH=false

#================================================================
MANDATORY_LIBS=""
ALL_FILES="$MANDATORY_FILES $OPTIONAL_FILES"
CHMOD="/bin/chmod"
OS_NAME=`uname`
PATCH_HOME=`pwd`
#File where instructions to UNDO the patch are stored
UNDO=$PATCH_HOME/undo_$SAVE_SUFFIX.sh
#UNDO_F=$PATCH_HOME/tmp.txt

#================================================================
}


do_java(){
if [ -x ./java_patch.csh ]; then
   echo " "
   echo "Applying Java updates."
   csh -f ./java_patch.csh
   echo "cd "$PATCH_HOME >> $UNDO
   #echo "t1  cd "$PATCH_HOME >> $UNDO_F
   
   echo "csh -f $PATCH_HOME/java_undo.csh " >> $UNDO
   #echo "t2  csh -f $PATCH_HOME/java_undo.csh " >> $UNDO_F
   echo " "
fi
}



insttype(){
if [ -x $ORACLE_HOME/bin/oracle ]; then
   INST_TYPE="Server"
else
   INST_TYPE="Client"
fi
}



optional_libr(){
OPTION_LIB=""
for entry in $OPTIONAL_LIBS; do
 dir=`echo $entry|awk -F: '{print $1}'`
 lib=`echo $entry|awk -F: '{print $2}'`
 obs=`echo $entry|awk -F: '{print $3}'`
 if [ -f $ORACLE_HOME/$dir/$lib ]; then
    if [ -w $ORACLE_HOME/$dir/$lib ]; then
       OPTION_LIB=$OPTION_LIB"`echo $dir:$lib:$obs` "
#    else
#       echo Optional library $ORACLE_HOME/$dir/$lib found
#       echo but not writable, skipping.
    fi
 else
    echo Optional library not installed.
    echo $ORACLE_HOME/$dir/$lib
 fi
done

}

setup_part2(){
# Make sure we do not produce non writable new files
$CHMOD -R u+w $PATCH_HOME
umask 022
# OS Specific bits
if [ "$OS_NAME" = 'Linux' ]; then
    ECHOFLAG='-e';
fi
}

setup_undo(){
#================================================================
#Create $UNDO file empty and with correct protections. Also test
#to see if we have one already, to try and prevent reapplication
#of a previously run patch, of course this means they would have
#to be in the same directory etc. There is a better way but this
#simple check will have to do for now.
#
if [ -f $UNDO ]; then
 echo " "
 echo "The UNDO file;"
 echo " "
 echo "$UNDO"
 echo " "
 echo "was found. This indicates the patch script has already"
 echo "been run, do you wish run this first, just continue or"
 echo "quit?"
 echo " "
 echo $ECHOFLAG "[R]un,[C]ontinue or [Q]uit [Default=Q] \c"
 RCQ="Q"
 if [ "$RCQ" = "Q" -o "$RCQ" = "q" -o "$RCQ" = "" ]; then
  echo " "
  echo "The UNDO file;"
  echo " "
  echo "$UNDO"
  echo " "
  echo "was found. This indicates the patch script has already"
  echo "been run."
  echo 'Oracle Patch installation aborted.'
  exit 1
 fi
 if [ "$RCQ" = "R" -o "$RCQ" = "r" ]; then
  . $UNDO
 fi
fi
echo 'Continuing with patch installation'
echo ' '
rm -f $UNDO
touch $UNDO
$CHMOD 744 $UNDO
echo "#!/bin/sh" >> $UNDO
echo "ORACLE_HOME=$ORACLE_HOME" >> $UNDO 
#echo "t10  ORACLE_HOME=$ORACLE_HOME" >> $UNDO_F
echo "PATH=$PATH " >> $UNDO 
#echo "t11  PATH=$PATH " >> $UNDO_F 
echo "export  ORACLE_HOME" >> $UNDO
#echo "t12  export ORACLE_HOME" >> $UNDO_F
echo "export PATH" >> $UNDO
#echo "t13  export PATH" >> $UNDO_F
}

check1(){
#================================================================
# Check customer install has mandatory files and libraries.
# Parse library list from LIBS_OBJECTS and MANDATORY_FILES

for entry in $LIBS_OBJECTS; do
 dir=`echo $entry|awk -F: '{print $1}'`
 lib=`echo $entry|awk -F: '{print $2}'`
 MANDATORY_LIBS=$MANDATORY_LIBS" `echo $dir/$lib`"
done

ABORTFLAG=false;

TMP_MANDATORY_FILES=""
for entry in $MANDATORY_FILES; do
 dir=`echo $entry|awk -F: '{print $1}'`
 obj=`echo $entry|awk -F: '{print $2}'`

 obj=`echo $obj|sed 's/,/ /g'`
 for ob1 in $obj; do
   obprefix=""
   obprefix=`echo $ob1|awk -F# '{print $1}'`
   if [ $obprefix = $ob1 ]; then
     ob=$ob1
     obprefix=""
   else
     obprefix=`echo $ob1|awk -F# '{print $1}'`"#"
     ob=`echo $ob1|awk -F# '{print $2}'`
   fi

   TMP_MANDATORY_FILES=$TMP_MANDATORY_FILES" `echo $dir/$ob`"
 done
done

# Check to see if all the necessary files and libraries exist.
for FILE in $TMP_MANDATORY_FILES $MANDATORY_LIBS;
 do
 if [ ! -f $ORACLE_HOME/$FILE ]; then
  echo " File $ORACLE_HOME/$FILE  is missing"
  ABORTFLAG=true;
 fi
 if [ ! -w $ORACLE_HOME/$FILE ]; then
  echo " File $ORACLE_HOME/$FILE  is not writable"
  ABORTFLAG=true;
 fi
 done

if $ABORTFLAG; then
 echo 'Patch can not be installed.'
 exit 1
fi

}

check_space(){
#================================================================
# generate some stats to test if we are going to install
# successfully, this needs work and testing against different
# platforms, it's a start...

size=0
sizeall=0
sizetmp=0
maxlib=0

#Calculate space requirements in $ORACLE_HOME
for FILE in $MANDATORY_LIBS; do
    sizelib=`ls -l $ORACLE_HOME/$FILE|awk '{printf "%d",$5/1024/1024*2}'`
    if [ $sizelib -gt $maxlib ];then
        maxlib=$sizelib
    fi
done
sizeall=$maxlib

#Get current TMPDIR
if [ -z "$TMPDIR" ]; then
    TMPDIR=$ORACLE_HOME/lib; export TMPDIR
    echo "Temporary working directory is:"
    echo $TMPDIR
    echo ' '
fi

#Calculate space requirements in $ORACLE_HOME and $TMPDIR
for FILE in $EXECUTABLES; do
    if [ ! -f $ORACLE_HOME/$FILE ]; then
       echo $ORACLE_HOME/$FILE does not exist.
       continue
    fi
    sizeexe=`ls -l $ORACLE_HOME/$FILE|awk '{printf "%d",$5/1024/1024}'`
    if [ $sizeexe -eq 0 ]; then sizeexe=1; fi
    sizeall=`expr $sizeexe \* 2 + $sizeall`
    if [ $sizeexe -gt $sizetmp ]; then
        sizetmp=$sizeexe
    fi
done
if [ $sizetmp -eq 0 ]; then sizetmp=1; fi
if [ $sizeall -eq 0 ]; then sizeall=1; fi
}

check_space2(){
#================================================================
# More checking to ensure we will succeed.
# HP does slightly different, need to look into.

if [ "$OS_NAME" != 'HP-UX' ]; then
    #Verify that the required space in $ORACLE_HOME is available
    freedisk=`df -k $ORACLE_HOME | sed '1d' |awk '{printf "%d",$2/1024}'`
    if [ $freedisk -lt $sizeall ]; then
        echo "Not enough free space found in $ORACLE_HOME"
        echo "Needed: "$sizeall"Mb, found: "$freedisk"Mb"
        exit 1
    fi

    if $DO_MAKE; then
    #Verify that the required temporary space in $TMPDIR is available
        freedisk=`df -k $TMPDIR | sed '1d' |awk '{printf "%d",$2/1024}'`
        if [ $freedisk -lt $sizetmp ]; then
            echo "Not enough free space found in $TMPDIR"
            echo "Needed: "$sizetmp"Mb, found: "$freedisk"Mb"
            exit 1
        fi
    fi
fi
}

check_instance(){
#================================================================
#Verify that no database is running, this is ok for pre 8i, however
#at 8i and after there is no fool proof way to determine this with
#100% confidence...
#
if $SHUTDOWN; then 
  SIDLIST=/tmp/$$ 
  ps -ef | grep smon | grep -v grep | cut -d_ -f3 > $SIDLIST 
  for sid in `cat $SIDLIST` 
  do 
    if [ -f $ORACLE_HOME/dbs/init$sid.ora ]; then 
      echo "Seems that some databases in $ORACLE_HOME are active" 
      echo "Patch installation aborted" 
      echo "Found instance: $sid open" 
      rm $SIDLIST 
      exit 1 
    fi 
  done 
  rm $SIDLIST 
fi 
}

#================================================================
disclaimer(){
echo "
    This procedure assumes that:
        - Your current working directory
          $PATCH_HOME
          is where you have restored this patch archive to.
        - You have read the README.* file.
        - You have at least $sizeall Mb available in the following filesystem.
          $ORACLE_HOME"

$DO_MAKE && echo "        - You have at least $sizetmp Mb available in following filesystem
          $TMPDIR"

$SHUTDOWN && echo "        - You have shutdown all database instances under this ORACLE_HOME
          before running this script."

echo "        - YOU WILL NOT INTERRUPT THIS PROCEDURE!"
echo $ECHOFLAG "          Are you ready to continue? [N] => \c"

read YN
echo "
     "

if [ "$YN" != 'Y' -a "$YN" != 'y' ];then
    echo 'Patch installation terminated'
    exit 1
fi
}

do_objects(){
if [ ! -z "$LIBS_OBJECTS" ]; then
 for pair in $LIBS_OBJECTS; do
  dir=`echo $pair|awk -F: '{print $1}'`
  lib=`echo $pair|awk -F: '{print $2}'`
  obj=`echo $pair|awk -F: '{print $3}'|sed 's/,/ /g'`

  cd $ORACLE_HOME/$dir

  for ob1 in $obj; do
    obprefix=""
    obprefix=`echo $ob1|awk -F# '{print $1}'`

    if [ $obprefix = $ob1 ]; then
      ob=$ob1
      obprefix=""
    else
      obprefix=`echo $ob1|awk -F# '{print $1}'`"#"
      ob=`echo $ob1|awk -F# '{print $2}'`
    fi
 
    if [ ! -f $PATCH_HOME/$obprefix$ob ]; then
       echo " "
       echo "ERROR: Missing patched object file,"
       echo "$PATCH_HOME/$obprefix$ob"
       echo " "
       echo "Aborting application of patch."
       echo " "
     . $UNDO
     rm $UNDO
     echo " "
     echo "Application of patch aborted. Please contact Oracle Support"
     echo " "
     exit 1
    fi

    #AR_CMD="ar"
    if [ "$OS_NAME" = 'AIX' ]; then
      CHECK_AIX_64=`file $PATCH_HOME/$ob1`
      AIX_64=`echo $CHECK_AIX_64|grep "64-bit"`
    #  if [ "$AIX_64" != "" ]; then
    #    AR_CMD="ar -X64"
    #  fi
    fi

    #qqq=`$AR_CMD -t $ORACLE_HOME/$dir/$lib $ob 2>/dev/null|wc -c|awk '{print $1}'`
    rrr=`echo $ob|wc -c|awk '{print $1}'`

    #if [ $qqq -eq $rrr ]; then
    # echo " cd `pwd` " >> $UNDO
    # if [ -f $ob ]; then
    #   echo "The file $ob already exists in this directory, renaming: "
    #   echodo mv $ob .$ob.$SAVE_SUFFIX.dup
    # fi
    # echodo $AR_CMD -x $ORACLE_HOME/$dir/$lib $ob
    # echodo mv $ob .$obprefix$ob.$SAVE_SUFFIX
    # echo "echodo mv .$obprefix$ob.$SAVE_SUFFIX $ob" >> $UNDO
    # echodo cp $PATCH_HOME/$obprefix$ob ./$ob
    # echodo $AR_CMD crl $ORACLE_HOME/$dir/$lib $ob
    # echo "echodo $AR_CMD crl $ORACLE_HOME/$dir/$lib $ob" >> $UNDO
    # echodo rm -f $ob
    # echo "echodo rm -f $ob" >> $UNDO
    # if [ -f .$ob.$SAVE_SUFFIX.dup ]; then
    #  echo "echodo mv .$ob.$SAVE_SUFFIX.dup $ob" >> $UNDO
    # fi
    #else #This is a new object.
    # if [ "$obprefix" = "NEW#" ]; then
    #  echodo cp $PATCH_HOME/$obprefix$ob ./$ob
    #  echodo $AR_CMD crl $ORACLE_HOME/$dir/$lib $ob
    #  echo "echodo $AR_CMD d $ORACLE_HOME/$dir/$lib $ob" >> $UNDO
    #  echodo rm -f $ob
    # else 
    #  echo $ob not found in library $ORACLE_HOME/$dir/$lib
    #  . $UNDO
    #  rm $UNDO
    #  exit 1
    # fi
    #fi
  done
 done
else
 echo No object modules to process.
fi
}

relink(){
#================================================================
#Relink executables

if $DO_MAKE && [ ! -z "$MAKE_TRIPLETS" ]; then
  echo " "
  echo "*** Starting rebuild for libraries and executables"
  echo " "
  for triplet in $MAKE_TRIPLETS; do
    directory=`echo $triplet|awk -F: '{print $1}'`
    makefile=`echo $triplet|awk -F: '{print $2}'`
    target=`echo $triplet|awk -F: '{print $3}'`
    
    target=`echo $target|sed 's/,/ /g'`
 
   cd $directory
    if echodo make -f $makefile $target; then
      echo "cd $directory" >> $UNDO
      #echo "t3  $directory" >> $UNDO_F
      echo "echodo make -f $makefile $target" >> $UNDO
      #echo "t4 echodo make -f $makefile $target" >> $UNDO_F
    else
      echo "Errors occurred during relink of $target"
      echo "Deinstalling patch..."
      . $UNDO
      rm $UNDO
      echo "Fix error and try again"
      exit 1
    fi
  done
  cd $PATCH_HOME
  echo " "
  echo "%%% Finished rebuilding libraries and executables"
else
  if [ ! -z "$MAKE_TRIPLETS" ]; then
    echo " "
    echo "Please perform the following commands to finish applying the patch:"
    for triplet in $MAKE_TRIPLETS; do
      directory=`echo $triplet|awk -F: '{print $1}'`
      makefile=`echo $triplet|awk -F: '{print $2}'`
      target=`echo $triplet|awk -F: '{print $3}'`
      target=`echo $target|sed 's/,/ /g'`
      echo "cd $ORACLE_HOME/$directory; make -f $makefile $target"
    done
    echo " Be sure to have at least "$sizetmp"Mb in your TMPDIR at relink time"
  fi
fi
}

closing(){
  echo " "
  echo "Patch applied succesfully."
  echo "Patch can be deinstalled by using the script:"
  echo $UNDO
  echo " "
}

update_agent_patch_info(){
#================================================================
# for v2.15
#
# If the patch is for Intelligent Agent, update the patch info
# in $ORACLE_HOME/PATCH_INFO
#
#
if $AGENT_PATCH; then
   INSTALLDATE=`date +%m/%d/%y`
   THREE_DIGITVS=`echo $VERSION|cut -c1-5`

   if [ ! -f $ORACLE_HOME/PATCH_INFO ]
   then
       echo "Product		PatchId          	Install Date" > $ORACLE_HOME/PATCH_INFO
       echo "" >> $ORACLE_HOME/PATCH_INFO
   fi

   # Now write the patch details to the PATCH_INFO file if this file doesn't
   # aready contain the bug. 
   #
   # -- the file will already contain the bug if the patch is being reapplied
   PATCH_STATUS=`grep $BUG $ORACLE_HOME/PATCH_INFO`
   if [ $? -ne 0 ]
   then
     echo "OEMAGENT	$THREE_DIGITVS"_bug"$BUG	$INSTALLDATE" >> $ORACLE_HOME/PATCH_INFO
   fi
   
   # Write to the undo script to allow this update to be backed out
   echo "grep -v $BUG $ORACLE_HOME/PATCH_INFO > $ORACLE_HOME/PATCH_INFO_$$" >> $UNDO
   #echo "t5  grep -v $BUG $ORACLE_HOME/PATCH_INFO > $ORACLE_HOME/PATCH_INFO_$$" >> $UNDO_F
   echo "mv $ORACLE_HOME/PATCH_INFO_$$ $ORACLE_HOME/PATCH_INFO" >> $UNDO
   #echo "t6  mv $ORACLE_HOME/PATCH_INFO_$$ $ORACLE_HOME/PATCH_INFO" >> $UNDO_F
fi
}


new_files(){
#================================================================
#Copy new files
if [ ! -z "$NEW_FILES" ]; then
 echo " "
  echo "*** Starting copying new files"
 echo " "
  for FILE in $NEW_FILES; do
    new_dir=`echo $FILE|awk -F: '{print $1}'`
    new_obj=`echo $FILE|sed "s?$new_dir:??"|sed 's/,/ /g'`
    for new_ob1 in $new_obj; do
      new_obprefix=""
      new_obprefix=`echo $new_ob1|awk -F# '{print $1}'`
      if [ $new_obprefix = $new_ob1 ]; then
        new_ob=$new_ob1
        new_obprefix=""
      else
        new_obprefix=`echo $new_ob1|awk -F# '{print $1}'`"#"
        new_ob=`echo $new_ob1|awk -F# '{print $2}'`
      fi
      cd $ORACLE_HOME/$new_dir
      echo "echodo rm $ORACLE_HOME/$new_dir/$new_ob" >> $UNDO
      #echo "t7  echodo rm $ORACLE_HOME/$new_dir/$new_ob" >> $UNDO_F
      echodo cp $PATCH_HOME/$new_ob1 $ORACLE_HOME/$new_dir/$new_ob
    done
    echo " "
    echo "%%% Finished copying new files"
    echo " "
  done
fi
}

mandatory_files(){
#================================================================
#Copy mandatory files

if [ ! -z "$MANDATORY_FILES" ]; then
  echo " "
  echo "*** Starting copying mandatory files"
  echo " "
  for FILE in $MANDATORY_FILES; do
    man_dir=`echo $FILE|awk -F: '{print $1}'`
    man_obj=`echo $FILE|sed "s?$man_dir:??"|sed 's/,/ /g'`
    for man_ob1 in $man_obj; do
      man_obprefix=""
      man_obprefix=`echo $man_ob1|awk -F# '{print $1}'`
      if [ $man_obprefix = $man_ob1 ]; then
        man_ob=$man_ob1
        man_obprefix=""
      else
        man_obprefix=`echo $man_ob1|awk -F# '{print $1}'`"#"
        man_ob=`echo $man_ob1|awk -F# '{print $2}'`
      fi
      cd $ORACLE_HOME/$man_dir
      echodo mv $ORACLE_HOME/$man_dir/$man_ob $ORACLE_HOME/$man_dir/.$man_ob.$SAVE_SUFFIX
      echo "echodo mv $ORACLE_HOME/$man_dir/.$man_ob.$SAVE_SUFFIX $ORACLE_HOME/$man_dir/$man_ob" >> $UNDO
      #echo "t8  echodo mv $ORACLE_HOME/$man_dir/.$man_ob.$SAVE_SUFFIX $ORACLE_HOME/$man_dir/$man_ob" >> $UNDO_F
      echodo cp $PATCH_HOME/$man_ob1 $ORACLE_HOME/$man_dir/$man_ob
    done
  done
  echo " "
  echo "%%%Finished copying mandatory files"
  echo " "
fi
}

optional_files(){
#================================================================
#Copy optional files (if they exist)

OPTIONAL_FILES_FOUND=""

if [ ! -z "$OPTIONAL_FILES" ]; then
 echo " "
 echo "*** Starting copying optional files"
 echo " "
 for FILE in $OPTIONAL_FILES; do
    opt_dir=`echo $FILE|awk -F: '{print $1}'`
    opt_obj=`echo $FILE|sed "s?$opt_dir:??"|sed 's/,/ /g'`
    for opt_ob1 in $opt_obj; do
      opt_obprefix=""
      opt_obprefix=`echo $opt_ob1|awk -F# '{print $1}'`
      if [ $opt_obprefix = $opt_ob1 ]; then
        opt_ob=$opt_ob1
        opt_obprefix=""
      else
        opt_obprefix=`echo $opt_ob1|awk -F# '{print $1}'`"#"
        opt_ob=`echo $opt_ob1|awk -F# '{print $2}'`
      fi
#
# If file exists, then deal with it.  Otherwise, do nothing, since it 
# is optional.
#
      if [ -d $ORACLE_HOME/$opt_dir ]; then
         cd $ORACLE_HOME/$opt_dir
         if [ -f $opt_ob ]; then
        echodo mv $ORACLE_HOME/$opt_dir/$opt_ob $ORACLE_HOME/$opt_dir/.$opt_ob.$SAVE_SUFFIX
        echo "echodo mv $ORACLE_HOME/$opt_dir/.$opt_ob.$SAVE_SUFFIX $ORACLE_HOME/$opt_dir/$opt_ob" >> $UNDO
        #echo "t9  echodo mv $ORACLE_HOME/$opt_dir/.$opt_ob.$SAVE_SUFFIX $ORACLE_HOME/$opt_dir/$opt_ob" >> $UNDO_F
        echodo cp $PATCH_HOME/$opt_ob1 $ORACLE_HOME/$opt_dir/$opt_ob
        OPTIONAL_FILES_FOUND="$OPTIONAL_FILES_FOUND $opt_dir:$opt_ob" 
         else
            echo "Optional file $ORACLE_HOME/$opt_dir/$opt_ob not installed."
      fi
      else
         echo "Optional file $ORACLE_HOME/$opt_dir/$opt_ob not installed."
      fi
    done
  done
  echo " "
  echo "%%%Finished copying optional files"
  echo " "
fi
}

conflicts(){
#================================================================
# Find potential conflicts with patches previously installed.

# Variable that is used to determine if, for a patch that
# has already been applied, whether the user has asked to reapply the patch.
ASK_QUESTION_IF_ALREADY_APPLIED=true

if [ ! -z "$LIBS_OBJECTS" ]; then

 for pair in $LIBS_OBJECTS; do
  cnf_dir=`echo $pair|awk -F: '{print $1}'`
  cnf_lib=`echo $pair|awk -F: '{print $2}'`
  cnf_obj=`echo $pair|awk -F: '{print $3}'|sed 's/,/ /g'`

  for cnf_ob1 in $cnf_obj; do
    cnf_obprefix=""
    cnf_obprefix=`echo $cnf_ob1|awk -F# '{print $1}'`

    if [ $cnf_obprefix = $cnf_ob1 ]; then
      cnf_ob=$cnf_ob1
      cnf_obprefix=""
    else
      cnf_obprefix=`echo $cnf_ob1|awk -F# '{print $1}'`"#"
      cnf_ob=`echo $cnf_ob1|awk -F# '{print $2}'`
    fi

    cd $ORACLE_HOME/$cnf_dir
    rrr=`echo $cnf_ob|wc -c|awk '{print $1}'`

    prefile=""
    if [ ! -z "$ORACLE_TRACE" ]; then set +e ; fi
    prefile=`ls .$cnf_ob.pre* 2>/dev/null`
    if [ ! -z "$ORACLE_TRACE" ]; then set -e ; fi
    if [ ! -z "$prefile" ]; then
#echo $prefile
      for prefile1 in $prefile; do
#echo $prefile1
         if [ $prefile1 = .$cnf_ob.$SAVE_SUFFIX ]; then
  
           # Don't Put up this warning if previously displayed
           if $ASK_QUESTION_IF_ALREADY_APPLIED ; then
               echo ""
               echo "The patch for $BUG has been applied previously to this ORACLE_HOME"
               echo ""
               echo $ECHOFLAG "Are you sure you want to continue? [N] \c"
               YN="N"
               echo "
               echo  "The answer is " $YN 
                    "
               if [ "$YN" != 'Y' -a "$YN" != 'y' ];then
                 echo ' Patch installation terminated'
                 exit 1
               else
                 # don't ask again
                 ASK_QUESTION_IF_ALREADY_APPLIED=false;
               fi
           fi
         else
# put check in for version
           ver_chk=`echo $prefile1|awk -F_ '{print $1}'|wc -c|awk '{print $1}'`
           ver_chka=`expr $ver_chk + 1`
           if [ $PATCHSET_FLAG = y ]; then
             ver_chkb=`expr $ver_chk + 9`
             VER_MOD2=$VERSION
           else
             ver_chkb=`expr $ver_chk + 5`
             VER_MOD2=`echo $VERSION|cut -c1-5`
           fi

           ver_cmp=`echo $prefile1 | cut -c$ver_chka-$ver_chkb `

           if [ -z "$ver_cmp" ]; then
             uconflict=`echo $prefile1 | cut -f 4 -d "." `
             uconflict=`echo $uconflict | cut -c4- `
             uexist="FALSE"
             for ulist1 in $ulist;
             do
               if [ "$uconflict" = "$ulist1" ]
               then
                 uexist="TRUE"
               fi
             done

             if [ "$uexist" = "FALSE" ]
             then
                ulist=`echo "$ulist $uconflict"`
             fi
           else
             if [ "$VER_MOD2" = "$ver_cmp" ]; then
               conflict=`echo $prefile1 | cut -f 1 -d "_" `
               count=`expr $rrr + 5`
               conflict1=`echo $conflict | cut -c$count- `
               exist="FALSE"
               for list1 in $list;
               do
                 if [ "$conflict1" = "$list1" ]
                 then
                   exist="TRUE"
                 fi
               done

               if [ "$exist" = "FALSE" ]
               then
                 list=`echo "$list $conflict1"`
               fi
             fi
           fi
         fi
      done
    fi
  done
 done
else
 echo No object modules to process.
fi

#plist=""
#zlist="$list"
#   for iz in $zlist; do
#for ir in $REPLLIST; do
#       echo $ir
#       echo $iz
#       if [ $ir = $iz ]; then
#          echo "Bug $ir is superceded by this patch." 
#          ir=
#       else
#          :
#       fi
#   done
#          plist=`echo "$plist $ir"`
#done
#list=`echo $plist`

COMPARISONS="$MANDATORY_FILES $OPTIONAL_FILES $NEW_FILES"

for pair in $COMPARISONS; do
  cnf_dir=`echo $pair|awk -F: '{print $1}'`
  cnf_obj=`echo $pair|sed "s?$cnf_dir:??"|sed 's/,/ /g'`

  for cnf_ob1 in $cnf_obj; do
    cnf_obprefix=""
    cnf_obprefix=`echo $cnf_ob1|awk -F# '{print $1}'`

    if [ $cnf_obprefix = $cnf_ob1 ]; then
      cnf_ob=$cnf_ob1
      cnf_obprefix=""
    else
      cnf_obprefix=`echo $cnf_ob1|awk -F# '{print $1}'`"#"
      cnf_ob=`echo $cnf_ob1|awk -F# '{print $2}'`
    fi

    if [ -d $ORACLE_HOME/$cnf_dir ]; then
    cd $ORACLE_HOME/$cnf_dir
    rrr=`echo $cnf_ob|wc -c|awk '{print $1}'`
    prefile=""
    prefile=`ls .$cnf_ob.pre* 2>/dev/null`

    if [ ! -z "$prefile" ]; then
      for prefile1 in $prefile; do
         if [ $prefile1 = .$cnf_ob.$SAVE_SUFFIX ]; then
            # Don't Put up this warning if previously displayed
            if $ASK_QUESTION_IF_ALREADY_APPLIED ; then
               echo ""
               echo "The patch for $BUG has been applied previously to this ORACLE_HOME"
               echo ""
               echo $ECHOFLAG "Are you sure you want to continue? [N] \c"
               YN="N"
               echo "
                    "
               if [ "$YN" != 'Y' -a "$YN" != 'y' ];then
                 echo ' Patch installation terminated'
                 exit 1
               else
                 # don't ask again
                 ASK_QUESTION_IF_ALREADY_APPLIED=false;
               fi
            fi
         else
# put check in for version
           ver_chk=`echo $prefile1|awk -F_ '{print $1}'|wc -c|awk '{print $1}'`
           ver_chka=`expr $ver_chk + 1`
           if [ $PATCHSET_FLAG = y ]; then
             ver_chkb=`expr $ver_chk + 9`
             VER_MOD2=$VERSION
           else
             ver_chkb=`expr $ver_chk + 5`
             VER_MOD2=`echo $VERSION|cut -c1-5`
           fi

           ver_cmp=`echo $prefile1 | cut -c$ver_chka-$ver_chkb `

           if [ -z "$ver_cmp" ]; then
             uconflict=`echo $prefile1 | cut -f 4 -d "." `
             uconflict=`echo $uconflict | cut -c4- `
             uexist="FALSE"
             for ulist1 in $ulist;
             do
               if [ "$uconflict" = "$ulist1" ]
               then
                 uexist="TRUE"
               fi
             done

             if [ "$uexist" = "FALSE" ]
             then
                ulist=`echo "$ulist $uconflict"`
             fi
           else
             if [ $VER_MOD2 = $ver_cmp ]; then
               conflict=`echo $prefile1 | cut -f 1 -d "_" `
               count=`expr $rrr + 5`
               conflict1=`echo $conflict | cut -c$count- `
               exist="FALSE"
               for list1 in $list;
               do
                 if [ "$conflict1" = "$list1" ]
                 then
                   exist="TRUE"
                 fi
               done

               if [ "$exist" = "FALSE" ]
               then
                  list=`echo "$list $conflict1"`
               fi
             fi
           fi
         fi
      done
    fi
    fi
  done
done


plist=""
zlist=`echo $list`
for iz in $zlist; do
for ir in $REPLLIST; do
#       echo $ir
#       echo $iz
       if [ $ir = $iz -a ! -z $iz ]; then
          echo "Bug $ir is superceded by this patch." 
          iz=
       fi
   done
   plist=`echo "$plist $iz"`
done

if [ ! -z "$plist" ]; then
   echo " "
fi

list=`echo $plist`

if [ ! -z "$list" -o ! -z "$ulist" ]; then
  echo ""
  echo "Previously applied patch(es) may be in conflict with $BUG";
  echo ""
  if [ ! -z "$list" ]; then
    echo "  The patch(es) for Version $VERSION, that may be in"
    echo "  conflict with this patch are:"
    echo ""
    echo "     $list"
    echo ""
  fi
  if [ ! -z "$ulist" ]; then
    if [ ! -z "$list" ]; then
      echo "  In addition, the following patch(es) were found and could be"
    else
      echo "  The following patch(es) were found and could be"
    fi
    echo "  in conflict with this patch; but we were unable to"
    echo "  determine what version they are for:"
    echo ""
    echo "     $ulist"
    echo ""
  fi
  echo "Continuing could overwite all or parts of the patch(es) in conflict."
  echo "You may want to contact support to get a merge of bug $BUG and"
  echo "the above conflicting bug(s)."
  echo ""
  echo "Are you sure you want to continue? [N]"
  read YN
  echo "
       "
  if [ "$YN" != 'Y' -a "$YN" != 'y' ];then
    echo ' Patch installation terminated'
    exit 1
  fi
fi 
}

#
# Start of the patch script.
#


setup

if [ $PATCHSET_FLAG = y ]; then
  ver_chk=7
else
  ver_chk=5
fi
VER_MOD=`echo $VERSION | cut -c-$ver_chk `

echo ' '
echo Patch Utility $PVER:
echo Applying patch for $BUG
echo on $PLATFORM
echo against a $INST_TYPE installation
echo at version $VER_MOD
echo ' '

setup_part2
check_instance
check_space
#disclaimer
check1
conflicts
check_space2
setup_undo
new_files
mandatory_files
optional_files
do_objects
relink
do_java
update_agent_patch_info
closing
#
#================================================================
# We change the values here to suit the patch/One-off, do not
# change anything else.
#
# What do these mean:
#
# SAVE_SUFFIX - this tags the files as they were prior to applying
#               the patch. We use pre<One-off request #>_<$VERSION>
#
# e.g SAVE_SUFFIX=pre1234567_8.1.7.2.0
#
# MANDATORY_FILES - Files we expect to be on the customer site.
#                   Rooted from ORACLE_HOME by default so we have
#                   to specify the full path and filename. This *must*
#                   follow the format in the example, space separated
#                   file list.
#
# e.g MANDATORY_FILES="lib:abc.txt,def.txt rdbms/lib:xyz.a jdbc/admin:eee.xxx"
#
# NEW_FILES       - For whatever reason a new file is required at the
#                   customer site, as it's new it is not checked for.
#                   Setup and usage as MANDATORY_FILES.
# 
# OPTIONAL_FILES  - Files which  may or may not exist on the customer
#                   site, however it still needs to be delivered as
#                   part of the fix, if a version exists then it is
#                   backed up. Setup and usage as MANDATORY_FILES.
#
# LIBS_OBJECTS    - These are objects shipped as part of a One-off. 
#                   The setup and usage is almost the same as the
#                   MANDATORY_FILES but the additional things are;
#
#                   1) A ":" separates the lib path and location from
#                      the contained objects.
#
#                   2) when shipping objects withe the same name a
#                      prefix can be used followed by the "#" sign.
#                      The script will look for the named file and
#                      rename it correctly so in our example 32#b.o
#                      is archived as b.o. We can use this when we
#                      ship for example 32 and 64 bit version of an
#                      object. 
#
# e.g LIBS_OBJECTS="rdbms/lib:libabc.a:a.o lib:libxyz.a:32#b.o,c.o"
#
#                  3) Files which are new objects should be tagged
#                     with "NEW#" e.g "dir:libsome8.a:NEW#afile.o"
#                     else the file is rejected.
#
# MAKE_TRIPLETS   - This represents the make files and targets to be
#                   executed and built. This is represented as three
#                   elements separated by ":", the first part is the
#                   location based of $ORACLE_HOME, the second is the
#                   make file to us and the third is the target to build.
#                   The restriction of only one target has been lifted
#                   multiple targets are comma separated.
#
# e.g MAKE_TRIPLETS="rdbms/lib:ins_rdbms.mk:ioracle,isvrmgrl"
#
# EXECUTABLES     - This is used to help in sizing the required space.
#                   It lists the executables we are going to rebuild.
#                   The setup and syntax is the same as MANDATORY_FILES.
#
# e.g EXECUTABLES="bin/oracle bin/svrmgrl"
#
# SHUTDOWN        - test to see that the instance is down. This is under
#                   review for 8.1+ patches as the method we used is no
#                   longer an option. The current test is not 100% certain
#                   but is "good enough".
#
# DO_MAKE         - This is used, primarily for debugging this script but
#                   can also be used to defer the relink phase for the
#                   application of this one-off .
#
