/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef _SYS_MACHCLOCK_H
#define	_SYS_MACHCLOCK_H

#pragma ident	"@(#)machclock.h	1.1	05/06/30 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

/*
 * Sun4v processors come up with NPT cleared and there is no need to
 * clear it again. Also, clearing of the NPT cannot be done atomically
 * on a CMT processor.
 */
#define	CLEARTICKNPT

#if defined(CPU_MODULE)

/*
 * Constants used to convert hi-res timestamps into nanoseconds
 * (see <sys/clock.h> file for more information)
 */

/*
 * At least 62.5 MHz, for faster %tick-based systems.
 */
#define	NSEC_SHIFT	4
#define	VTRACE_SHIFT	4

#endif /* CPU_MODULE */

#ifdef	__cplusplus
}
#endif

#endif	/* !_SYS_MACHCLOCK_H */
