/*
 * Copyright 2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

#ifndef	_SYS_DDI_SUBRDEFS_H
#define	_SYS_DDI_SUBRDEFS_H

#pragma ident	"@(#)ddi_subrdefs.h	1.4	05/06/14 SMI"

/*
 * Sun DDI platform implementation subroutines definitions
 */

#include <sys/ddi.h>
#include <sys/sunddi.h>
#include <sys/nexusintr_impl.h>

#ifdef	__cplusplus
extern "C" {
#endif

#ifdef	_KERNEL

uint32_t i_ddi_get_intr_pri(dev_info_t *dip, uint_t inumber);

void	i_ddi_alloc_ispec(dev_info_t *dip, uint_t inumber,
	    ddi_intrspec_t *ispecp);
void	i_ddi_free_ispec(ddi_intrspec_t ispecp);

int	i_ddi_add_ivintr(ddi_intr_handle_impl_t *hdlp);
void	i_ddi_rem_ivintr(ddi_intr_handle_impl_t *hdlp);

#endif	/* _KERNEL */

#ifdef	__cplusplus
}
#endif

#endif	/* _SYS_DDI_SUBRDEFS_H */
