/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server.util;

import com.iplanet.im.server.Log;
import java.util.LinkedList;

public class RWLock {
    Thread rwThread = null;
    LinkedList roThreads = new LinkedList();

    public synchronized void getReadLock() {
        while (this.rwThread != null) {
            Log.debug("[RWLock:" + this.hashCode() + "] waiting on rwlock held by " + this.rwThread.getName());
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.roThreads.add(Thread.currentThread());
    }

    public synchronized void getWriteLock() {
        while (this.rwThread != null || this.roThreads.size() > 0) {
            Log.debug("[RWLock:" + this.hashCode() + "] waiting on rw lock held by " + this.rwThreadName());
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
        this.rwThread = Thread.currentThread();
        Log.debug("[RWLock:" + this.hashCode() + "] rwlock obtained by " + this.rwThread.getName());
    }

    public synchronized void releaseReadLock() {
        this.roThreads.remove(Thread.currentThread());
        this.notify();
    }

    private String rwThreadName() {
        return this.rwThread != null ? this.rwThread.getName() : "null";
    }

    public synchronized void releaseWriteLock() {
        Log.debug("[RWLock:" + this.hashCode() + "] rwlock released by " + this.rwThreadName());
        this.rwThread = null;
        this.notify();
    }

    public synchronized void release() {
        if (this.rwThread != null) {
            if (!this.rwThread.equals(Thread.currentThread())) {
                Log.error("[RWLock] releasing lock from a different thread!");
            } else {
                Log.debug("[RWLock:" + this.hashCode() + "] rwlock released by " + this.rwThread.getName());
                this.rwThread = null;
            }
        } else if (this.roThreads.size() > 0) {
            this.roThreads.remove(Thread.currentThread());
        }
        this.notify();
    }

    public synchronized int getRefCount() {
        return this.roThreads.size();
    }
}

