/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server.cacao;

import com.sun.cacao.DeploymentDescriptor;
import com.sun.cacao.Module;
import com.sun.mfwk.cib.CIBApplication;
import com.sun.mfwk.cib.CIBProduct;
import com.sun.mfwk.cib.CIBService;
import com.sun.mfwk.cib.sdk.util.CIBMBeansFactory;
import com.sun.mfwk.discovery.MfDiscoveryInfo;
import com.sun.mfwk.util.log.MfLogService;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class XMPPServerModule
extends Module
implements NotificationListener {
    private CIBProduct cp = null;
    private static final String prodName = "XMPP";
    private static Logger logger = MfLogService.getLogger((String)"XMPP");
    private CIBMBeansFactory cibFactory = null;
    private Map instances = new HashMap();

    public XMPPServerModule(DeploymentDescriptor descriptor) {
        super(descriptor);
        this.cibFactory = new CIBMBeansFactory((Module)this);
    }

    protected void start() {
        NotificationFilterSupport myFilter = new NotificationFilterSupport();
        try {
            this.cp = this.cibFactory.createCIBProduct(prodName, "v1.1", "none", 0L, "Sun Microsystems");
            myFilter.enableType(prodName);
            try {
                ObjectName discoveryServiceObjectName = new ObjectName("com.sun.mfwk.mfwk_module:type=mfDiscoveryService,name=mfDiscoveryService");
                this.getMbs().addNotificationListener(discoveryServiceObjectName, this, (NotificationFilter)myFilter, null);
            }
            catch (Exception e) {
                logger.warning("cannot succeed in adding listener on  : " + e.getMessage());
            }
        }
        catch (Throwable e) {
            logger.warning("Caught Exception during creation of CIB Product : " + e.toString());
        }
    }

    protected void stop() {
        try {
            this.cibFactory.removeCIBProduct(prodName);
        }
        catch (Throwable e) {
            logger.warning("Caught Exception during removal of CIB objects : " + e.toString() + " message : " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            String type = notification.getType();
            logger.info("handling notification; type=" + type);
            MfDiscoveryInfo receivedMsg = (MfDiscoveryInfo)notification.getUserData();
            String logTimeStamp = receivedMsg.getTimeStamp() > -1L ? ", ProductTimeStamp Date: " + new Date(receivedMsg.getTimeStamp()).toString() : "";
            logger.info("Notification: Product: " + receivedMsg.getProduct() + ", ApplicationInstance: " + receivedMsg.getProductInstance() + ", ProductUri: " + receivedMsg.getUri() + ", userData: " + receivedMsg.getUserData() + logTimeStamp);
            if (this.instances.containsKey(receivedMsg.getProductInstance())) {
                Long lastStart = (Long)this.instances.get(receivedMsg.getProductInstance());
                Long startDate = new Long(receivedMsg.getTimeStamp());
                if (lastStart >= startDate) {
                    logger.finest("This is a re-send of discovery message of an already registered appl - nothing to do");
                    return;
                }
                logger.info("This is a restart of instance " + receivedMsg.getProductInstance());
                this.instances.remove(receivedMsg.getProductInstance());
                this.cibFactory.removeCIBApplication(receivedMsg.getProductInstance());
            }
            this.instances.put(receivedMsg.getProductInstance(), new Long(receivedMsg.getTimeStamp()));
            this.cibFactory.createCIBProviderHandler(receivedMsg);
            CIBApplication appl1 = this.cibFactory.newCIBApplication(receivedMsg.getProductInstance(), true, true, false);
            String[] services = new String[]{"auth", "message", "presence", "presence-probe", "presence-subscribe", "presence-unsubscribe", "presence-authorize", "roster-get", "roster-set", "privacy-get", "privacy-set", "private-get", "private-set", "search", "disco", "muc-message", "muc-presence", "muc-admin", "iq-other"};
            for (int i = 0; i < services.length; ++i) {
                CIBService srv = this.cibFactory.newCIBApplicationService(services[i], appl1, true, true, false);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Error while handling notification", e);
            e.printStackTrace();
        }
    }
}

