/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.AbstractHandler;
import com.iplanet.im.server.ContentFilters;
import com.iplanet.im.server.Log;
import com.iplanet.im.server.StreamEndPoint;
import com.iplanet.im.server.XMPPByteStreamBlock;
import com.sun.im.provider.ByteStream;
import com.sun.im.provider.ByteStreamFilter;
import java.util.Iterator;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamElement;

public class XMPPByteStream
implements ByteStream {
    StreamElement _data;
    Packet _packet;
    StreamEndPoint _session;
    Iterator _filterItr;
    String _sid;
    Packet _closePacket;
    String _name;

    public XMPPByteStream(StreamEndPoint session, Packet packet, StreamElement openElement) {
        this._packet = packet;
        this._session = session;
        this._data = openElement;
        this._sid = this._data.getAttributeValue("sid");
        this._session.addByteStream(this._sid, this);
        Log.debug("[IBB] Adding XMPPByteStream: " + this._sid);
    }

    public XMPPByteStream(StreamEndPoint session, String id) {
        this._session = session;
        this._session.addByteStream(id, this);
    }

    public void process() {
        Iterator i = ContentFilters.iterator();
        while (i.hasNext()) {
            try {
                ((ByteStreamFilter)i.next()).openStream(this._packet.getFrom().toString(), this._packet.getTo().toString(), (ByteStream)this);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }

    public void close(Packet packet) {
        this._closePacket = packet;
        Iterator i = ContentFilters.iterator();
        while (i.hasNext()) {
            try {
                ((ByteStreamFilter)i.next()).closeStream((ByteStream)this);
            }
            catch (Exception e) {
                Log.printStackTrace(e);
            }
        }
    }

    public void abort() {
        this.close(null);
        this._session.removeByteStream(this.getID());
    }

    public String getID() {
        return this._sid;
    }

    public String getTo() {
        return this._packet.getTo().toBareJID().toString();
    }

    public String getFrom() {
        return this._packet.getFrom().toBareJID().toString();
    }

    public String getName() {
        return this._name;
    }

    void processData(Packet packet, StreamElement dataElement, AbstractHandler handler) {
        new XMPPByteStreamBlock(this._session, packet, dataElement, handler, this).process();
    }

    public StreamEndPoint getSession() {
        return this._session;
    }

    public Packet getClosePacket() {
        return this._closePacket;
    }

    public StreamElement getOpenElement() {
        return this._data;
    }

    public void setOpenPacket(Packet packet) {
        this._packet = packet;
    }

    public void setOpenElement(StreamElement element) {
        this._data = element;
    }

    public void setSID(String id) {
        this._sid = id;
    }

    public String getSID() {
        return this._sid;
    }

    public void setName(String name) {
        this._name = name;
    }
}

