/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.WatchdogComponent;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

class WatchdogComponentMFWK
extends WatchdogComponent {
    private String _portFileName;

    WatchdogComponentMFWK(String configFile, String pidFileName, String module, String portFileName, Integer numberOfCycles) {
        super(configFile, pidFileName, module, numberOfCycles);
        this._portFileName = portFileName;
    }

    WatchdogComponentMFWK(String configFile, String pidFileName, String module, String portFileName) {
        this(configFile, pidFileName, module, portFileName, null);
    }

    protected boolean checkOperational() {
        this._operational = false;
        Log.debug("mfwk.checkOperational starting");
        try {
            int port = this.getPid(this._portFileName);
            if (port != 0) {
                JMXServiceURL url = new JMXServiceURL("service:jmx:jmxmp://" + InetAddress.getLocalHost().getHostName() + ":" + port);
                JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
                MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                String defaultDomain = mbsc.getDefaultDomain();
                String[] domains = mbsc.getDomains();
                int status = -1;
                for (int i = 0; i < domains.length; ++i) {
                    if (!domains[i].equals("MfInstrum")) continue;
                    status = i;
                }
                if (status >= 0) {
                    ObjectName oldMBeanName = new ObjectName(domains[status] + ":type=MfStatus");
                    Object operationalState = mbsc.getAttribute(oldMBeanName, "OperationalState");
                    Log.debug("OperationalState[" + oldMBeanName + "]=" + operationalState);
                    long currOpsState = Long.parseLong(operationalState.toString().trim());
                    if (currOpsState == 1L || currOpsState == 2L) {
                        this._operational = true;
                    } else {
                        Log.info("Server is not operational: OperationalState[" + oldMBeanName + "]=" + operationalState);
                    }
                }
                jmxc.close();
            } else {
                Log.warning("JMX port is 0 in " + this._portFileName);
            }
        }
        catch (MalformedURLException urle) {
            Log.printStackTrace(urle);
        }
        catch (IOException ioe) {
            Log.printStackTrace(ioe);
        }
        catch (MalformedObjectNameException mone) {
            Log.printStackTrace(mone);
        }
        catch (ReflectionException re) {
            Log.printStackTrace(re);
        }
        catch (MBeanRegistrationException rege) {
            Log.printStackTrace(rege);
        }
        catch (Exception mbe) {
            Log.printStackTrace(mbe);
        }
        return this._operational;
    }
}

