/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.WatchdogComponent;
import com.sun.im.service.util.CertificateVerify;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.JavaxX509TrustManager;
import com.sun.im.service.util.StreamChannelSocketAdaptor;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.io.src.ChannelStreamSource;
import org.jabberstudio.jso.io.src.SocketStreamSource;

class WatchdogComponentJSO
extends WatchdogComponent {
    private JSOImplementation _jso;
    private HostPort _hostPort;
    private boolean _usessl = false;

    WatchdogComponentJSO(boolean useSSL, String configFile, String pidFileName, String module, HostPort hp, Integer numberOfCycles) {
        super(configFile, pidFileName, module, numberOfCycles);
        this._hostPort = hp;
        this._jso = JSOImplementation.getInstance();
        this._usessl = useSSL;
    }

    WatchdogComponentJSO(boolean useSSL, String configFile, String pidFileName, String module, HostPort hp) {
        this(useSSL, configFile, pidFileName, module, hp, null);
    }

    WatchdogComponentJSO(String configFile, String pidFileName, String module, HostPort hp) {
        this(false, configFile, pidFileName, module, hp, null);
    }

    WatchdogComponentJSO(String configFile, String pidFileName, String module, HostPort hp, Integer numberOfCycles) {
        this(false, configFile, pidFileName, module, hp, numberOfCycles);
    }

    protected boolean checkOperational() {
        this._operational = false;
        try {
            Stream connection = this._jso.createStream("jabber:client");
            ChannelStreamSource css = null;
            if (this._usessl) {
                JavaxX509TrustManager trustManager = new JavaxX509TrustManager(new CertificateVerify(){

                    public boolean doYouTrustCertificate(X509Certificate[] chain) {
                        return true;
                    }
                });
                Socket _baseSocket = SocketChannel.open(new InetSocketAddress(this._hostPort.getHostName(), this._hostPort.getPort())).socket();
                StreamChannelSocketAdaptor adapter = new StreamChannelSocketAdaptor(_baseSocket);
                SSLSocketFactory factory = trustManager.getSocketFactory();
                SSLSocket _sslSocket = (SSLSocket)factory.createSocket((Socket)adapter, this._hostPort.getHostName(), this._hostPort.getPort(), true);
                try {
                    _sslSocket.startHandshake();
                    css = new SocketStreamSource((Socket)_sslSocket);
                    _baseSocket.getChannel().configureBlocking(false);
                }
                catch (IOException e) {
                    Log.printStackTrace(e);
                }
            } else {
                css = ChannelStreamSource.createSocket((String)this._hostPort.getHostName(), (int)this._hostPort.getPort());
                ((SocketChannel)css.getChannel()).configureBlocking(false);
            }
            if (css != null) {
                connection.connect((StreamSource)css);
                connection.open(15000L);
                this._operational = true;
                connection.close();
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return this._operational;
    }
}

