/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class WatchdogComponent {
    protected boolean _running;
    protected boolean _operational;
    private String _pidFileName;
    private File _pidFile;
    private String _module;
    private ArrayList _statusList;
    private int _failuresCount;
    private int _maxNumberOfCycles;
    private int _defaultNbOfCycles = 10;
    private String _configFile;

    WatchdogComponent(String configFile, String pidFileName, String module, Integer numberOfCycles) {
        this._configFile = configFile;
        this._pidFileName = pidFileName;
        try {
            this._pidFile = new File(pidFileName);
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        this._module = module;
        this._maxNumberOfCycles = numberOfCycles != null ? numberOfCycles : this._defaultNbOfCycles;
        this.init();
    }

    WatchdogComponent(String configFile, String pidFileName, String module) {
        this(configFile, pidFileName, module, null);
    }

    private void reset() {
        this._running = false;
        this._operational = false;
        this._failuresCount = 0;
        this._statusList.clear();
    }

    private void init() {
        this._statusList = new ArrayList();
        this.reset();
    }

    public int getNumberOfCycles() {
        return this._statusList.size();
    }

    private void failuresCountRefresh() {
        int rv = 0;
        for (int i = 0; i < this._statusList.size(); ++i) {
            boolean tmp = (Boolean)this._statusList.get(i);
            if (tmp) continue;
            ++rv;
        }
        this._failuresCount = rv;
    }

    public int getFailuresCount() {
        return this._failuresCount;
    }

    private void addCycleStatus(boolean cycleStatus) {
        this._statusList.add(new Boolean(cycleStatus));
        if (this._statusList.size() > this._maxNumberOfCycles) {
            this._statusList.remove(0);
        }
        this.failuresCountRefresh();
    }

    private int getPid(File myFile) {
        int myPid = 0;
        String tmp = "0";
        try {
            if (myFile.exists()) {
                BufferedReader reader = new BufferedReader(new FileReader(myFile));
                tmp = reader.readLine();
                reader.close();
            } else {
                Log.debug("pid file not found: " + myFile.getAbsolutePath());
            }
            myPid = Integer.parseInt(tmp.trim());
        }
        catch (Exception e) {
            Log.printStackTrace(e);
        }
        return myPid;
    }

    private int getPid() {
        return this.getPid(this._pidFile);
    }

    protected int getPid(String myFileName) {
        return this.getPid(new File(myFileName));
    }

    protected String getModule() {
        return this._module;
    }

    public boolean checkShutDown() {
        if (this.getPid() == 0) {
            this.reset();
            return true;
        }
        return false;
    }

    public boolean checkRunning() {
        this._running = false;
        try {
            if (!this.checkShutDown()) {
                this._running = this.runCmd("/bin/ps -p" + this.getPid(), false) == 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._running;
    }

    protected boolean checkOperational() {
        this._operational = this.checkRunning();
        return this._operational;
    }

    public boolean isOperational() {
        return this._operational;
    }

    public boolean isRunning() {
        return this._running;
    }

    protected int runCmd(String myCmd, boolean output) {
        int rv = -1;
        try {
            Process p = Runtime.getRuntime().exec(myCmd);
            if (output) {
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                new Thread(new ConsoleOutputRunnable(stdInput)).start();
                BufferedReader stdErr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                new Thread(new ConsoleOutputRunnable(stdErr)).start();
            }
            rv = p.waitFor();
        }
        catch (Exception e) {
            rv = 1;
        }
        return rv;
    }

    protected int runCmd(String myCmd) {
        return this.runCmd(myCmd, true);
    }

    public int restart() {
        if (!this.checkShutDown()) {
            this.runCmd(WatchdogComponent.getCommandString(this._module, "stop", this._configFile));
        }
        return this.runCmd(WatchdogComponent.getCommandString(this._module, "start", this._configFile));
    }

    public boolean check() {
        if (!this.checkRunning()) {
            this._operational = false;
            return false;
        }
        return this.checkOperational();
    }

    public int watchRV() {
        int rv = -1;
        boolean cycleStatus = this.check();
        if (!this.checkShutDown()) {
            this.addCycleStatus(cycleStatus);
            if (!cycleStatus) {
                rv = this.restart();
            }
        } else {
            rv = -2;
        }
        return rv;
    }

    public int watchRunningRV() {
        int rv = -1;
        boolean cycleStatus = this.checkRunning();
        if (!this.checkShutDown()) {
            this.addCycleStatus(cycleStatus);
            if (!cycleStatus) {
                rv = this.restart();
            }
        } else {
            rv = -2;
        }
        return rv;
    }

    public boolean watch() {
        return this.watchRV() >= 0;
    }

    public boolean watchRunning() {
        return this.watchRunningRV() >= 0;
    }

    private static String getCommandString(String module, String action, String configFile) {
        String _administrativeBin = "sh imadmin -c ";
        String _adminStartCmd = "start";
        String _adminStopCmd = "stop";
        String _adminRestartCmd = "refresh";
        String _adminServerSuffix = "server";
        String _adminMuxSuffix = "multiplexor";
        String _adminCalBotSuffix = "agent-calendar";
        String _adminAllSuffix = "legacy";
        String _serverLabel = "server";
        String _muxLabel = "mux";
        String _calbotLabel = "calbot";
        String _startLabel = "start";
        String _stopLabel = "stop";
        String _restartLabel = "restart";
        String rv = "sh imadmin -c " + configFile;
        if ((module.equalsIgnoreCase("all") || module.equalsIgnoreCase("server") || module.equalsIgnoreCase("mux") || module.equalsIgnoreCase("calbot")) && (action.equalsIgnoreCase("start") || action.equalsIgnoreCase("stop") || action.equalsIgnoreCase("restart"))) {
            rv = rv + " ";
            rv = action.equalsIgnoreCase("start") ? rv + "start" : (action.equalsIgnoreCase("stop") ? rv + "stop" : rv + "refresh");
            rv = rv + " ";
            rv = module.equalsIgnoreCase("server") ? rv + "server" : (module.equalsIgnoreCase("mux") ? rv + "multiplexor" : (module.equalsIgnoreCase("calbot") ? rv + "agent-calendar" : rv + "legacy"));
        } else {
            rv = "";
        }
        return rv;
    }

    static class ConsoleOutputRunnable
    implements Runnable {
        BufferedReader stdInput;

        ConsoleOutputRunnable(BufferedReader stdInput) {
            this.stdInput = stdInput;
        }

        public void run() {
            String s = null;
            try {
                while ((s = this.stdInput.readLine()) != null) {
                    System.out.println(s);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

