/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.server;

import com.iplanet.im.server.Log;
import com.iplanet.im.server.ServerConfig;
import com.iplanet.im.server.WatchdogComponent;
import com.iplanet.im.server.WatchdogComponentJSO;
import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.StringUtility;
import java.io.File;

public class Watchdog {
    private static boolean _verbose = false;
    private static boolean _watchServer;
    private static boolean _watchMux;
    private static boolean _watchAgent;
    private static boolean _watchCalBot;
    private static boolean _useServerPort;
    private static boolean _useMFWK;
    private static boolean _useSSL;
    private static int period;
    private static String _configFile;
    private static int _maxRetries;
    private static String _cwd;
    private static String _varDir;
    private static String _logDir;
    private static String _serverPidFile;
    private static String _muxPidFile;
    private static String _calBotPidFile;
    private static String _serverJmxPortFile;
    private static HostPort _muxHostPort;
    private static HostPort _serverHostPort;
    private static final String PERIOD = "iim_wd.period";
    private static final String MAX_RETRIES = "iim_wd.maxretries";
    private static final int svrWaitAfterStart = 60000;
    private static final int muxWaitAfterStart = 30000;

    public static String getCWD() {
        File f = new File(".");
        String cwd = f.getAbsolutePath();
        return cwd.substring(0, cwd.length() - 1);
    }

    private static void myPrint(boolean newLine, String stuffToPiout) {
        if (_verbose) {
            if (newLine) {
                System.out.println(stuffToPiout);
            } else {
                System.out.print(stuffToPiout);
            }
        }
    }

    private static void myPrint(String stuffToPiout) {
        Watchdog.myPrint(true, stuffToPiout);
    }

    private static boolean loadConf() {
        boolean rv = false;
        try {
            ServerConfig sc = ServerConfig.getFreshServerConfig();
            try {
                period = Integer.parseInt(sc.getSetting(PERIOD, "300"));
            }
            catch (Exception e) {
                Log.error("unable to parse watchdog period value from config file. Defaulting to 5 minutes");
                Log.printStackTrace(e);
                period = 300;
            }
            period *= 1000;
            _watchServer = StringUtility.getBoolean((String)sc.getSetting("iim_server.enable", "true"), (boolean)true);
            _watchMux = StringUtility.getBoolean((String)sc.getSetting("iim_mux.enable", "true"), (boolean)true);
            _watchAgent = StringUtility.getBoolean((String)sc.getSetting("iim_agent.enable", "false"), (boolean)false);
            if (_watchAgent) {
                _watchCalBot = StringUtility.getBoolean((String)sc.getSetting("iim_agent.agent-calendar.enable", "false"), (boolean)false);
            }
            _maxRetries = Integer.parseInt(sc.getSetting(MAX_RETRIES, "3"));
            _varDir = sc.getSetting("iim.instancevardir", "..") + File.separator;
            _logDir = _varDir + "log" + File.separator;
            _serverPidFile = _logDir + sc.getSetting("iim.pidfile", "xmppd.pid");
            _muxPidFile = _logDir + "mux.pid";
            _calBotPidFile = _logDir + "agent-calendar.pid";
            _serverJmxPortFile = _logDir + "xmppd.jmx";
            _muxHostPort = new HostPort(sc.getSetting("iim_mux.listenport", "5222"), 5222);
            _useServerPort = StringUtility.getBoolean((String)sc.getSetting("iim_server.useport", "true"), (boolean)true);
            if (_useServerPort) {
                _serverHostPort = new HostPort(sc.getSetting("iim_server.port", "5269"), 5269);
            }
            rv = true;
            _useSSL = StringUtility.getBoolean((String)sc.getSetting("iim_mux.usessl", "off"), (boolean)false);
            Log.info("Watchdog using [" + _configFile + "] as configuration file");
            Log.debug("watchdog main parameters: monitoring server?[" + _watchServer + "] monitoring multiplexor?[" + _watchMux + "] monitoring agent-calendar?[" + _watchCalBot + "] period [" + period + "] fail over after [" + _maxRetries + "] retries var dir [" + _varDir + "] log dir[" + _logDir + "]");
            Log.debug("server main parameters:" + (_useServerPort ? "server hostport [" + _serverHostPort.toString() : "") + "] server jmx file [" + _serverJmxPortFile + "] server pid file [" + _serverPidFile + "]");
            Log.debug("multiplexor main parameters: multiplexor hostport [" + _muxHostPort + "] SSL on?[" + _useSSL + "] multiplexor pid file[" + _muxPidFile + "]");
            Log.debug("agents main parameters: calendar agent pid file [" + _calBotPidFile + "]");
            _useMFWK = StringUtility.getBoolean((String)sc.getSetting("iim_server.monitor.enable"), (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rv;
    }

    private static void usage() {
        Watchdog.myPrint("Usage: config file must be specified");
    }

    public static void main(String[] args) {
        boolean keepLooping = true;
        _cwd = Watchdog.getCWD();
        try {
            Object[] params;
            Class[] paramTypes;
            Class<?> javaLangString;
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-c")) {
                    if (i + 1 < args.length) {
                        _configFile = args[++i];
                    } else {
                        Watchdog.usage();
                    }
                }
                if (!args[i].equalsIgnoreCase("-v")) continue;
                _verbose = true;
            }
            ServerConfig.init(_configFile);
            Log.init("iim_wd");
            Log.notice("Loading configuration from " + _configFile);
            Watchdog.loadConf();
            WatchdogComponent wdcServer = null;
            try {
                ClassLoader.getSystemClassLoader().loadClass("com.sun.mfwk.util.instrum.MfStatus");
            }
            catch (Exception e) {
                _useMFWK = false;
            }
            if (_useMFWK) {
                try {
                    javaLangString = ClassLoader.getSystemClassLoader().loadClass("java.lang.String");
                    paramTypes = new Class[]{javaLangString, javaLangString, javaLangString, javaLangString};
                    params = new Object[]{_configFile, _serverPidFile, "server", _serverJmxPortFile};
                    wdcServer = (WatchdogComponent)Class.forName("com.iplanet.im.server.WatchdogComponentMFWK").getDeclaredConstructor(paramTypes).newInstance(params);
                    Log.notice("JES Monitoring framework found");
                }
                catch (Exception e) {
                    _useMFWK = false;
                }
            }
            if (!_useMFWK) {
                Log.info("Not using Monitoring framework");
                try {
                    if (_useServerPort) {
                        javaLangString = ClassLoader.getSystemClassLoader().loadClass("java.lang.String");
                        paramTypes = new Class[]{javaLangString, javaLangString, javaLangString, ClassLoader.getSystemClassLoader().loadClass("com.sun.im.service.util.HostPort")};
                        params = new Object[]{_configFile, _serverPidFile, "server", _serverHostPort};
                        wdcServer = (WatchdogComponent)Class.forName("com.iplanet.im.server.WatchdogComponentJSO").getDeclaredConstructor(paramTypes).newInstance(params);
                    } else {
                        wdcServer = new WatchdogComponent(_configFile, _serverPidFile, "server");
                    }
                }
                catch (Exception e) {
                    Log.error("Failed to start watchdog: " + e);
                    e.printStackTrace();
                    Log.printStackTrace(e);
                    return;
                }
            }
            WatchdogComponentJSO wdcMux = new WatchdogComponentJSO(_useSSL, _configFile, _muxPidFile, "mux", _muxHostPort);
            WatchdogComponent wdcCalBot = new WatchdogComponent(_configFile, _calBotPidFile, "calbot");
            boolean serverRestarted = false;
            boolean muxRestarted = false;
            if (_watchServer) {
                if (!wdcServer.check()) {
                    wdcServer.restart();
                    serverRestarted = true;
                    Log.info("Server started");
                    Log.info("Server failed " + wdcServer.getFailuresCount() + " times in the last " + wdcServer.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                } else {
                    Log.info("Server running and operational");
                }
            }
            if (_watchMux) {
                if (!_watchServer || serverRestarted) {
                    if (!wdcMux.checkRunning()) {
                        wdcMux.restart();
                        muxRestarted = true;
                    }
                } else if (!wdcMux.check()) {
                    wdcMux.restart();
                    muxRestarted = true;
                }
            }
            if (muxRestarted) {
                Log.info("Multiplexor started");
                Log.info("Multiplexor failed " + wdcMux.getFailuresCount() + " times in the last " + wdcMux.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
            } else {
                Log.info("Multiplexor running and operational");
            }
            if (_watchCalBot) {
                if (!wdcCalBot.check()) {
                    wdcCalBot.restart();
                    Log.info("Agent-calendar started");
                    Log.info("Agent-calendar failed " + wdcCalBot.getFailuresCount() + " times in the last " + wdcCalBot.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                } else {
                    Log.info("Agent-calendar running");
                }
            }
            boolean calbotUnconfigured = false;
            int compTimeWait = 0;
            while (keepLooping) {
                String msg;
                if (period > compTimeWait) {
                    Log.debug("Will check again in " + (period - compTimeWait) + " ms");
                    try {
                        Thread.sleep(period - compTimeWait);
                    }
                    catch (InterruptedException ie) {
                        Log.warning(ie.toString());
                    }
                } else {
                    Log.debug("Will check again in 0 ms");
                }
                compTimeWait = 0;
                serverRestarted = false;
                muxRestarted = false;
                if (Watchdog.loadConf()) {
                    if (_watchServer && wdcServer.watch()) {
                        Log.info("Server restarted");
                        serverRestarted = true;
                    }
                    Log.debug("Server failed " + wdcServer.getFailuresCount() + " times in the last " + wdcServer.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                    if (_watchMux) {
                        muxRestarted = !_watchServer || serverRestarted || wdcServer.checkShutDown() ? wdcMux.watchRunning() : wdcMux.watch();
                    }
                    if (muxRestarted) {
                        Log.info("Multiplexor restarted");
                        Watchdog.myPrint("muliplexor restarted");
                    }
                    Log.debug("Multiplexor failed " + wdcMux.getFailuresCount() + " times in the last " + wdcMux.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                    if (_watchCalBot && !calbotUnconfigured) {
                        wdcCalBot.watch();
                        Log.debug("Agent:Calendar failed " + wdcCalBot.getFailuresCount() + " times in the last " + wdcCalBot.getNumberOfCycles() + " cycles and max is set to " + _maxRetries);
                        if (wdcCalBot.getFailuresCount() >= _maxRetries) {
                            calbotUnconfigured = true;
                            msg = "Restarted Agent:Calendar " + _maxRetries + " times in " + wdcCalBot.getNumberOfCycles() + " cycles - Disabling Agent:Calendar watching";
                            System.out.println(msg);
                            Log.warning(msg);
                        }
                    }
                    if (serverRestarted && wdcServer.getFailuresCount() >= _maxRetries) {
                        if (60000 > compTimeWait) {
                            try {
                                Thread.sleep(60000 - compTimeWait);
                            }
                            catch (InterruptedException ie) {
                                Log.warning(ie.toString());
                            }
                            compTimeWait = 60000;
                        }
                        if (!wdcServer.checkShutDown() && !wdcServer.check()) {
                            keepLooping = false;
                            msg = "Failing over as watchdog restarted server " + wdcServer.getFailuresCount() + " times within " + wdcServer.getNumberOfCycles() + " cycles and latest restart attempt failed.";
                            Log.error(msg);
                            Watchdog.myPrint(msg);
                        }
                    }
                    if (!muxRestarted || !keepLooping || wdcMux.getFailuresCount() < _maxRetries) continue;
                    if (30000 > compTimeWait) {
                        try {
                            Thread.sleep(30000 - compTimeWait);
                        }
                        catch (InterruptedException ie) {
                            Log.warning(ie.toString());
                        }
                        compTimeWait = 30000;
                    }
                    if (!wdcMux.checkShutDown()) {
                        if (_watchServer && !wdcServer.checkShutDown() && wdcServer.isOperational()) {
                            if (!wdcMux.check()) {
                                keepLooping = false;
                            }
                        } else if (!wdcMux.checkRunning()) {
                            keepLooping = false;
                        }
                    }
                    if (keepLooping) continue;
                    msg = "Failing over as watchdog restarted multiplexor " + wdcMux.getFailuresCount() + " times within " + wdcMux.getNumberOfCycles() + " cycles and latest restart attempt failed.";
                    Log.error(msg);
                    Watchdog.myPrint(msg);
                    continue;
                }
                keepLooping = false;
                msg = "Could not reload configuration file";
                Log.fatal(msg);
                Watchdog.myPrint(msg);
            }
        }
        catch (Exception e) {
            Log.printStackTrace(e);
            System.exit(1);
        }
        System.exit(0);
    }

    static {
        _watchCalBot = false;
        _useMFWK = true;
        _useSSL = false;
        period = 300000;
        _configFile = ".." + File.separator + "config" + File.separator + "iim.conf";
        _maxRetries = 3;
        _varDir = "..";
        _muxPidFile = ".." + File.separator + "log" + File.separator + "mux.pid";
        _calBotPidFile = ".." + File.separator + "log" + File.separator + "calimbot.pid";
        _serverHostPort = null;
    }
}

